/************************************************************************************************/
/* Stata User File for H60 Data                                                                 */
/*                                                                                              */
/* This file contains information and a sample Stata program to create a permanent              */
/* Stata dataset for users who want to use Stata in processing the MEPS data provided           */
/* in this PUF release.  Stata (StataCorp) has the capability to produce                        */
/* appropriate standard errors for estimates from a survey with a complex sample                */
/* design such as the Medical Expenditure Panel Survey (MEPS).                                  */
/* The input file for creating a permanent Stata dataset is the ASCII data file                 */
/* (H60.DAT) supplied in this PUF release, which in turn can be extracted from the              */
/* .EXE file. After entering the Stata interactive environment access the Stata DO-File         */
/* editor by clicking on the appropriate icon in the command line at the top of the             */
/* screen.  Copy and paste the following Stata commands into the editor and save as a           */
/* DO file.  A DO file is a Stata program which may then be executed using the DO command.      */
/* For example, if the DO file is named H60.DO and is located in the directory                  */
/* C:\MEPS\PROG, then the file may be executed by typing the following command into             */
/* the Stata command line:                                                                      */
/*                         do C:\MEPS\PROG\H60.DO                                               */
/* The program below will output the Stata dataset H60.DTA                                      */
/************************************************************************************************/


#delimit ;
cd $datadir/MEPS/dat/fullyearconsolidated;
clear;

* INPUT ALL VARIABLES;
infix
  long   DUID 1-5
  int    PID 6-8
  str    DUPERSID 9-16
  byte   PANEL01 17-17
  str    FAMID31 18-19
  str    FAMID42 20-21
  str    FAMID53 22-23
  str    FAMID01 24-25
  str    FAMIDYR 26-27
  str    CPSFAMID 28-29
  str    HIEUIDX 30-36
  byte   FCSZ1231 37-38
  byte   FCRP1231 39-40
  str    RULETR31 41-42
  str    RULETR42 43-44
  str    RULETR53 45-46
  str    RULETR01 47-48
  byte   RUSIZE31 49-50
  byte   RUSIZE42 51-52
  byte   RUSIZE53 53-54
  byte   RUSIZE01 55-56
  byte   RUCLAS31 57-58
  byte   RUCLAS42 59-60
  byte   RUCLAS53 61-62
  byte   RUCLAS01 63-63
  byte   FAMSZE31 64-65
  byte   FAMSZE42 66-67
  byte   FAMSZE53 68-69
  byte   FAMSZE01 70-71
  byte   FMRS1231 72-73
  byte   FAMS1231 74-75
  byte   FAMSZEYR 76-77
  byte   FAMRFPYR 78-79
  int    REFPRS31 80-82
  int    REFPRS42 83-85
  int    REFPRS53 86-88
  int    REFPRS01 89-91
  byte   RESP31 92-92
  byte   RESP42 93-93
  byte   RESP53 94-94
  byte   RESP01 95-95
  byte   PROXY31 96-97
  byte   PROXY42 98-99
  byte   PROXY53 100-101
  byte   PROXY01 102-102
  byte   INTVLANG 103-104
  byte   BEGRFD31 105-106
  byte   BEGRFM31 107-108
  int    BEGRFY31 109-112
  byte   ENDRFD31 113-114
  byte   ENDRFM31 115-116
  int    ENDRFY31 117-120
  byte   BEGRFD42 121-122
  byte   BEGRFM42 123-124
  int    BEGRFY42 125-128
  byte   ENDRFD42 129-130
  byte   ENDRFM42 131-132
  int    ENDRFY42 133-136
  byte   BEGRFD53 137-138
  byte   BEGRFM53 139-140
  int    BEGRFY53 141-144
  byte   ENDRFD53 145-146
  byte   ENDRFM53 147-148
  int    ENDRFY53 149-152
  byte   ENDRFD01 153-154
  byte   ENDRFM01 155-156
  int    ENDRFY01 157-160
  byte   KEYNESS 161-161
  byte   INSCOP31 162-162
  byte   INSCOP42 163-163
  byte   INSCOP53 164-164
  byte   INSCOP01 165-165
  byte   INSC1231 166-166
  byte   INSCOPE 167-167
  byte   ELGRND31 168-168
  byte   ELGRND42 169-169
  byte   ELGRND53 170-170
  byte   ELGRND01 171-171
  byte   ELIGIBLE 172-172
  byte   PSTATS31 173-174
  byte   PSTATS42 175-176
  byte   PSTATS53 177-178
  str    RURSLT31 179-180
  str    RURSLT42 181-182
  str    RURSLT53 183-184
  byte   REGION31 185-186
  byte   REGION42 187-188
  byte   REGION53 189-190
  byte   REGION01 191-192
  byte   MSA31 193-194
  byte   MSA42 195-196
  byte   MSA53 197-198
  byte   MSA01 199-200
  byte   AGE31X 201-202
  byte   AGE42X 203-204
  byte   AGE53X 205-206
  byte   AGE01X 207-208
  byte   DOBMM 209-210
  int    DOBYY 211-214
  byte   SEX 215-215
  byte   RACEX 216-216
  byte   RACETHNX 217-217
  byte   HISPANX 218-218
  byte   HISPCAT 219-220
  byte   MARRY31X 221-222
  byte   MARRY42X 223-224
  byte   MARRY53X 225-226
  byte   MARRY01X 227-228
  int    SPOUID31 229-231
  int    SPOUID42 232-234
  int    SPOUID53 235-237
  int    SPOUID01 238-240
  byte   SPOUIN31 241-242
  byte   SPOUIN42 243-244
  byte   SPOUIN53 245-246
  byte   SPOUIN01 247-248
  byte   EDUCYEAR 249-250
  byte   HIDEGYR 251-252
  byte   FTSTU31X 253-254
  byte   FTSTU42X 255-256
  byte   FTSTU53X 257-258
  byte   FTSTU01X 259-260
  byte   ACTDTY31 261-262
  byte   ACTDTY42 263-264
  byte   ACTDTY53 265-266
  byte   DIDSERVE 267-268
  byte   VETVIET 269-270
  byte   VETKOR 271-272
  byte   VETWW 273-274
  byte   VETGULF 275-276
  byte   VETOTH 277-278
  byte   RFREL31X 279-280
  byte   RFREL42X 281-282
  byte   RFREL53X 283-284
  byte   RFREL01X 285-286
  int    MOPID31X 287-289
  int    MOPID42X 290-292
  int    MOPID53X 293-295
  int    DAPID31X 296-298
  int    DAPID42X 299-301
  int    DAPID53X 302-304
  byte   SSIDIS01 305-306
  byte   AFDC01 307-308
  byte   FILEDR01 309-310
  byte   WILFIL01 311-312
  byte   FLSTAT01 313-314
  byte   FILER01 315-316
  byte   JTINRU01 317-318
  int    JNTPID01 319-321
  byte   CLMDEP01 322-323
  byte   DEPDNT01 324-325
  byte   DPINRU01 326-327
  byte   DPOTSD01 328-329
  byte   TAXFRM01 330-331
  byte   DEDUCT01 332-333
  byte   ITMEXP01 334-335
  double MEXAMT01 336-343
  double NTMDED01 344-351
  double TOTDED01 352-360
  byte   CLMHIP01 361-362
  byte   ELDISC01 363-364
  byte   EICRDT01 365-366
  int    UNEMTX01 367-369
  int    INTRTX01 370-372
  int    SSECTX01 373-375
  int    IRATAX01 376-378
  byte   FOODST01 379-380
  byte   FOODMN01 381-382
  double FOODCT01 383-388
  double FOODVL01 389-395
  long   TTLP01X 396-401
  byte   POVCAT01 402-402
  long   WAGEP01X 403-408
  byte   WAGIMP01 409-409
  long   BUSNP01X 410-415
  byte   BUSIMP01 416-416
  long   FARMP01X 417-422
  byte   FARIMP01 423-423
  long   UNEMP01X 424-428
  byte   UNEIMP01 429-429
  long   WCMPP01X 430-434
  byte   WCPIMP01 435-435
  long   INTRP01X 436-440
  byte   INTIMP01 441-441
  long   DIVDP01X 442-446
  byte   DIVIMP01 447-447
  long   SALEP01X 448-453
  byte   SALIMP01 454-454
  long   PENSP01X 455-460
  byte   PENIMP01 461-461
  long   SSECP01X 462-466
  byte   SSCIMP01 467-467
  long   TRSTP01X 468-473
  byte   TRTIMP01 474-474
  long   VETSP01X 475-479
  byte   VETIMP01 480-480
  long   IRASP01X 481-485
  byte   IRAIMP01 486-486
  long   REFDP01X 487-491
  byte   REFIMP01 492-492
  long   ALIMP01X 493-497
  byte   ALIIMP01 498-498
  long   CHLDP01X 499-503
  byte   CHLIMP01 504-504
  long   CASHP01X 505-509
  byte   CSHIMP01 510-510
  long   SSIP01X 511-515
  byte   SSIIMP01 516-516
  long   PUBP01X 517-521
  byte   PUBIMP01 522-522
  long   OTHRP01X 523-527
  byte   OTHIMP01 528-528
  byte   EMPST31 529-530
  byte   EMPST42 531-532
  byte   EMPST53 533-534
  byte   RNDFLG31 535-536
  byte   MORJOB31 537-538
  byte   MORJOB42 539-540
  byte   MORJOB53 541-542
  byte   EVRWRK 543-544
  double HRWG31X 545-550
  double HRWG42X 551-556
  double HRWG53X 557-562
  byte   HRWGIM31 563-563
  byte   HRWGIM42 564-564
  byte   HRWGIM53 565-565
  byte   HRHOW31 566-567
  byte   HRHOW42 568-569
  byte   HRHOW53 570-571
  int    HOUR31 572-574
  int    HOUR42 575-577
  byte   HOUR53 578-579
  byte   TEMPJB31 580-581
  byte   TEMPJB42 582-583
  byte   TEMPJB53 584-585
  byte   SSNLJB31 586-587
  byte   SSNLJB42 588-589
  byte   SSNLJB53 590-591
  byte   SELFCM31 592-593
  byte   SELFCM42 594-595
  byte   SELFCM53 596-597
  byte   DISVW31X 598-599
  byte   DISVW42X 600-601
  byte   DISVW53X 602-603
  byte   CHOIC31 604-605
  byte   CHOIC42 606-607
  byte   CHOIC53 608-609
  byte   CIND31 610-611
  byte   CIND42 612-613
  byte   CIND53 614-615
  int    NUMEMP31 616-618
  int    NUMEMP42 619-621
  int    NUMEMP53 622-624
  byte   MORE31 625-626
  byte   MORE42 627-628
  byte   MORE53 629-630
  byte   UNION31 631-632
  byte   UNION42 633-634
  byte   UNION53 635-636
  byte   NWK31 637-638
  byte   NWK42 639-640
  byte   NWK53 641-642
  byte   CHGJ3142 643-644
  byte   CHGJ4253 645-646
  byte   YCHJ3142 647-648
  byte   YCHJ4253 649-650
  byte   STJBMM31 651-652
  byte   STJBDD31 653-654
  int    STJBYY31 655-658
  byte   STJBMM42 659-660
  byte   STJBDD42 661-662
  int    STJBYY42 663-666
  byte   STJBMM53 667-668
  byte   STJBDD53 669-670
  int    STJBYY53 671-674
  byte   EVRETIRE 675-676
  byte   COCCP31 677-678
  byte   COCCP42 679-680
  byte   COCCP53 681-682
  byte   PAYVAC31 683-684
  byte   PAYVAC42 685-686
  byte   PAYVAC53 687-688
  byte   SICPAY31 689-690
  byte   SICPAY42 691-692
  byte   SICPAY53 693-694
  byte   PAYDR31 695-696
  byte   PAYDR42 697-698
  byte   PAYDR53 699-700
  byte   RETPLN31 701-702
  byte   RETPLN42 703-704
  byte   RETPLN53 705-706
  byte   BSNTY31 707-708
  byte   BSNTY42 709-710
  byte   BSNTY53 711-712
  byte   JOBORG31 713-714
  byte   JOBORG42 715-716
  byte   JOBORG53 717-718
  byte   HELD31X 719-720
  byte   HELD42X 721-722
  byte   HELD53X 723-724
  byte   OFFER31X 725-726
  byte   OFFER42X 727-728
  byte   OFFER53X 729-730
  byte   TRIJA01X 731-732
  byte   TRIFE01X 733-734
  byte   TRIMA01X 735-736
  byte   TRIAP01X 737-738
  byte   TRIMY01X 739-740
  byte   TRIJU01X 741-742
  byte   TRIJL01X 743-744
  byte   TRIAU01X 745-746
  byte   TRISE01X 747-748
  byte   TRIOC01X 749-750
  byte   TRINO01X 751-752
  byte   TRIDE01X 753-754
  byte   MCRJA01 755-756
  byte   MCRFE01 757-758
  byte   MCRMA01 759-760
  byte   MCRAP01 761-762
  byte   MCRMY01 763-764
  byte   MCRJU01 765-766
  byte   MCRJL01 767-768
  byte   MCRAU01 769-770
  byte   MCRSE01 771-772
  byte   MCROC01 773-774
  byte   MCRNO01 775-776
  byte   MCRDE01 777-778
  byte   MCRJA01X 779-780
  byte   MCRFE01X 781-782
  byte   MCRMA01X 783-784
  byte   MCRAP01X 785-786
  byte   MCRMY01X 787-788
  byte   MCRJU01X 789-790
  byte   MCRJL01X 791-792
  byte   MCRAU01X 793-794
  byte   MCRSE01X 795-796
  byte   MCROC01X 797-798
  byte   MCRNO01X 799-800
  byte   MCRDE01X 801-802
  byte   MCDJA01 803-804
  byte   MCDFE01 805-806
  byte   MCDMA01 807-808
  byte   MCDAP01 809-810
  byte   MCDMY01 811-812
  byte   MCDJU01 813-814
  byte   MCDJL01 815-816
  byte   MCDAU01 817-818
  byte   MCDSE01 819-820
  byte   MCDOC01 821-822
  byte   MCDNO01 823-824
  byte   MCDDE01 825-826
  byte   MCDJA01X 827-828
  byte   MCDFE01X 829-830
  byte   MCDMA01X 831-832
  byte   MCDAP01X 833-834
  byte   MCDMY01X 835-836
  byte   MCDJU01X 837-838
  byte   MCDJL01X 839-840
  byte   MCDAU01X 841-842
  byte   MCDSE01X 843-844
  byte   MCDOC01X 845-846
  byte   MCDNO01X 847-848
  byte   MCDDE01X 849-850
  byte   OPAJA01 851-852
  byte   OPAFE01 853-854
  byte   OPAMA01 855-856
  byte   OPAAP01 857-858
  byte   OPAMY01 859-860
  byte   OPAJU01 861-862
  byte   OPAJL01 863-864
  byte   OPAAU01 865-866
  byte   OPASE01 867-868
  byte   OPAOC01 869-870
  byte   OPANO01 871-872
  byte   OPADE01 873-874
  byte   OPBJA01 875-876
  byte   OPBFE01 877-878
  byte   OPBMA01 879-880
  byte   OPBAP01 881-882
  byte   OPBMY01 883-884
  byte   OPBJU01 885-886
  byte   OPBJL01 887-888
  byte   OPBAU01 889-890
  byte   OPBSE01 891-892
  byte   OPBOC01 893-894
  byte   OPBNO01 895-896
  byte   OPBDE01 897-898
  byte   STAJA01 899-900
  byte   STAFE01 901-902
  byte   STAMA01 903-904
  byte   STAAP01 905-906
  byte   STAMY01 907-908
  byte   STAJU01 909-910
  byte   STAJL01 911-912
  byte   STAAU01 913-914
  byte   STASE01 915-916
  byte   STAOC01 917-918
  byte   STANO01 919-920
  byte   STADE01 921-922
  byte   PUBJA01X 923-924
  byte   PUBFE01X 925-926
  byte   PUBMA01X 927-928
  byte   PUBAP01X 929-930
  byte   PUBMY01X 931-932
  byte   PUBJU01X 933-934
  byte   PUBJL01X 935-936
  byte   PUBAU01X 937-938
  byte   PUBSE01X 939-940
  byte   PUBOC01X 941-942
  byte   PUBNO01X 943-944
  byte   PUBDE01X 945-946
  byte   PEGJA01 947-948
  byte   PEGFE01 949-950
  byte   PEGMA01 951-952
  byte   PEGAP01 953-954
  byte   PEGMY01 955-956
  byte   PEGJU01 957-958
  byte   PEGJL01 959-960
  byte   PEGAU01 961-962
  byte   PEGSE01 963-964
  byte   PEGOC01 965-966
  byte   PEGNO01 967-968
  byte   PEGDE01 969-970
  byte   PDKJA01 971-972
  byte   PDKFE01 973-974
  byte   PDKMA01 975-976
  byte   PDKAP01 977-978
  byte   PDKMY01 979-980
  byte   PDKJU01 981-982
  byte   PDKJL01 983-984
  byte   PDKAU01 985-986
  byte   PDKSE01 987-988
  byte   PDKOC01 989-990
  byte   PDKNO01 991-992
  byte   PDKDE01 993-994
  byte   PNGJA01 995-996
  byte   PNGFE01 997-998
  byte   PNGMA01 999-1000
  byte   PNGAP01 1001-1002
  byte   PNGMY01 1003-1004
  byte   PNGJU01 1005-1006
  byte   PNGJL01 1007-1008
  byte   PNGAU01 1009-1010
  byte   PNGSE01 1011-1012
  byte   PNGOC01 1013-1014
  byte   PNGNO01 1015-1016
  byte   PNGDE01 1017-1018
  byte   POGJA01 1019-1020
  byte   POGFE01 1021-1022
  byte   POGMA01 1023-1024
  byte   POGAP01 1025-1026
  byte   POGMY01 1027-1028
  byte   POGJU01 1029-1030
  byte   POGJL01 1031-1032
  byte   POGAU01 1033-1034
  byte   POGSE01 1035-1036
  byte   POGOC01 1037-1038
  byte   POGNO01 1039-1040
  byte   POGDE01 1041-1042
  byte   PRSJA01 1043-1044
  byte   PRSFE01 1045-1046
  byte   PRSMA01 1047-1048
  byte   PRSAP01 1049-1050
  byte   PRSMY01 1051-1052
  byte   PRSJU01 1053-1054
  byte   PRSJL01 1055-1056
  byte   PRSAU01 1057-1058
  byte   PRSSE01 1059-1060
  byte   PRSOC01 1061-1062
  byte   PRSNO01 1063-1064
  byte   PRSDE01 1065-1066
  byte   POUJA01 1067-1068
  byte   POUFE01 1069-1070
  byte   POUMA01 1071-1072
  byte   POUAP01 1073-1074
  byte   POUMY01 1075-1076
  byte   POUJU01 1077-1078
  byte   POUJL01 1079-1080
  byte   POUAU01 1081-1082
  byte   POUSE01 1083-1084
  byte   POUOC01 1085-1086
  byte   POUNO01 1087-1088
  byte   POUDE01 1089-1090
  byte   PRIJA01 1091-1092
  byte   PRIFE01 1093-1094
  byte   PRIMA01 1095-1096
  byte   PRIAP01 1097-1098
  byte   PRIMY01 1099-1100
  byte   PRIJU01 1101-1102
  byte   PRIJL01 1103-1104
  byte   PRIAU01 1105-1106
  byte   PRISE01 1107-1108
  byte   PRIOC01 1109-1110
  byte   PRINO01 1111-1112
  byte   PRIDE01 1113-1114
  byte   HPEJA01 1115-1116
  byte   HPEFE01 1117-1118
  byte   HPEMA01 1119-1120
  byte   HPEAP01 1121-1122
  byte   HPEMY01 1123-1124
  byte   HPEJU01 1125-1126
  byte   HPEJL01 1127-1128
  byte   HPEAU01 1129-1130
  byte   HPESE01 1131-1132
  byte   HPEOC01 1133-1134
  byte   HPENO01 1135-1136
  byte   HPEDE01 1137-1138
  byte   HPDJA01 1139-1140
  byte   HPDFE01 1141-1142
  byte   HPDMA01 1143-1144
  byte   HPDAP01 1145-1146
  byte   HPDMY01 1147-1148
  byte   HPDJU01 1149-1150
  byte   HPDJL01 1151-1152
  byte   HPDAU01 1153-1154
  byte   HPDSE01 1155-1156
  byte   HPDOC01 1157-1158
  byte   HPDNO01 1159-1160
  byte   HPDDE01 1161-1162
  byte   HPNJA01 1163-1164
  byte   HPNFE01 1165-1166
  byte   HPNMA01 1167-1168
  byte   HPNAP01 1169-1170
  byte   HPNMY01 1171-1172
  byte   HPNJU01 1173-1174
  byte   HPNJL01 1175-1176
  byte   HPNAU01 1177-1178
  byte   HPNSE01 1179-1180
  byte   HPNOC01 1181-1182
  byte   HPNNO01 1183-1184
  byte   HPNDE01 1185-1186
  byte   HPOJA01 1187-1188
  byte   HPOFE01 1189-1190
  byte   HPOMA01 1191-1192
  byte   HPOAP01 1193-1194
  byte   HPOMY01 1195-1196
  byte   HPOJU01 1197-1198
  byte   HPOJL01 1199-1200
  byte   HPOAU01 1201-1202
  byte   HPOSE01 1203-1204
  byte   HPOOC01 1205-1206
  byte   HPONO01 1207-1208
  byte   HPODE01 1209-1210
  byte   HPSJA01 1211-1212
  byte   HPSFE01 1213-1214
  byte   HPSMA01 1215-1216
  byte   HPSAP01 1217-1218
  byte   HPSMY01 1219-1220
  byte   HPSJU01 1221-1222
  byte   HPSJL01 1223-1224
  byte   HPSAU01 1225-1226
  byte   HPSSE01 1227-1228
  byte   HPSOC01 1229-1230
  byte   HPSNO01 1231-1232
  byte   HPSDE01 1233-1234
  byte   HPRJA01 1235-1236
  byte   HPRFE01 1237-1238
  byte   HPRMA01 1239-1240
  byte   HPRAP01 1241-1242
  byte   HPRMY01 1243-1244
  byte   HPRJU01 1245-1246
  byte   HPRJL01 1247-1248
  byte   HPRAU01 1249-1250
  byte   HPRSE01 1251-1252
  byte   HPROC01 1253-1254
  byte   HPRNO01 1255-1256
  byte   HPRDE01 1257-1258
  byte   INSJA01X 1259-1260
  byte   INSFE01X 1261-1262
  byte   INSMA01X 1263-1264
  byte   INSAP01X 1265-1266
  byte   INSMY01X 1267-1268
  byte   INSJU01X 1269-1270
  byte   INSJL01X 1271-1272
  byte   INSAU01X 1273-1274
  byte   INSSE01X 1275-1276
  byte   INSOC01X 1277-1278
  byte   INSNO01X 1279-1280
  byte   INSDE01X 1281-1282
  byte   PRVEV01 1283-1283
  byte   TRIEV01 1284-1284
  byte   MCREV01 1285-1285
  byte   MCDEV01 1286-1286
  byte   OPAEV01 1287-1287
  byte   OPBEV01 1288-1288
  byte   UNINS01 1289-1289
  byte   INSCOV01 1290-1290
  byte   MCDHMO31 1291-1292
  byte   MCDHMO42 1293-1294
  byte   MCDHMO01 1295-1296
  byte   MCDMC31 1297-1298
  byte   MCDMC42 1299-1300
  byte   MCDMC01 1301-1302
  byte   PRVHMO31 1303-1304
  byte   PRVHMO42 1305-1306
  byte   PRVHMO01 1307-1308
  byte   PRVMNC31 1309-1310
  byte   PRVMNC42 1311-1312
  byte   PRVMNC01 1313-1314
  byte   PRVDRL31 1315-1316
  byte   PRVDRL42 1317-1318
  byte   PRVDRL01 1319-1320
  byte   PHMONP31 1321-1322
  byte   PHMONP42 1323-1324
  byte   PHMONP01 1325-1326
  byte   PMNCNP31 1327-1328
  byte   PMNCNP42 1329-1330
  byte   PMNCNP01 1331-1332
  byte   PRDRNP31 1333-1334
  byte   PRDRNP42 1335-1336
  byte   PRDRNP01 1337-1338
  byte   PREVCOVR 1339-1340
  byte   COVRMM 1341-1342
  int    COVRYY 1343-1346
  byte   WASESTB 1347-1348
  byte   WASMCARE 1349-1350
  byte   WASMCAID 1351-1352
  byte   WASCHAMP 1353-1354
  byte   WASVA 1355-1356
  byte   WASPRIV 1357-1358
  byte   WASOTGOV 1359-1360
  byte   WASAFDC 1361-1362
  byte   WASSSI 1363-1364
  byte   WASSTAT1 1365-1366
  byte   WASSTAT2 1367-1368
  byte   WASOTHER 1369-1370
  byte   NOINSBEF 1371-1372
  byte   NOINSTM 1373-1374
  byte   NOINUNIT 1375-1376
  byte   MORECOVR 1377-1378
  byte   INSENDMM 1379-1380
  int    INSENDYY 1381-1384
  byte   DENYINSR 1385-1386
  byte   DNYCANC 1387-1388
  byte   DNYHYPER 1389-1390
  byte   DNYDIAB 1391-1392
  byte   DNYCORON 1393-1394
  byte   DENYOTH 1395-1396
  byte   INSLOOK 1397-1398
  byte   INSLIMIT 1399-1400
  byte   LMTBACK 1401-1402
  byte   LIMITOT 1403-1404
  byte   TRICR31X 1405-1406
  byte   TRICR42X 1407-1408
  byte   TRICR53X 1409-1410
  byte   TRICR01X 1411-1412
  byte   TRIAT31X 1413-1414
  byte   TRIAT42X 1415-1416
  byte   TRIAT53X 1417-1418
  byte   TRIAT01X 1419-1420
  byte   MCAID31 1421-1422
  byte   MCAID42 1423-1424
  byte   MCAID53 1425-1426
  byte   MCAID01 1427-1428
  byte   MCAID31X 1429-1430
  byte   MCAID42X 1431-1432
  byte   MCAID53X 1433-1434
  byte   MCAID01X 1435-1436
  byte   MCARE31 1437-1438
  byte   MCARE42 1439-1440
  byte   MCARE53 1441-1442
  byte   MCARE01 1443-1444
  byte   MCARE31X 1445-1446
  byte   MCARE42X 1447-1448
  byte   MCARE53X 1449-1450
  byte   MCARE01X 1451-1452
  byte   MCDAT31X 1453-1454
  byte   MCDAT42X 1455-1456
  byte   MCDAT53X 1457-1458
  byte   MCDAT01X 1459-1460
  byte   OTPAAT31 1461-1462
  byte   OTPAAT42 1463-1464
  byte   OTPAAT53 1465-1466
  byte   OTPAAT01 1467-1468
  byte   OTPBAT31 1469-1470
  byte   OTPBAT42 1471-1472
  byte   OTPBAT53 1473-1474
  byte   OTPBAT01 1475-1476
  byte   OTPUBA31 1477-1478
  byte   OTPUBA42 1479-1480
  byte   OTPUBA53 1481-1482
  byte   OTPUBA01 1483-1484
  byte   OTPUBB31 1485-1486
  byte   OTPUBB42 1487-1488
  byte   OTPUBB53 1489-1490
  byte   OTPUBB01 1491-1492
  byte   PRIDK31 1493-1494
  byte   PRIDK42 1495-1496
  byte   PRIDK53 1497-1498
  byte   PRIDK01 1499-1500
  byte   PRIEU31 1501-1502
  byte   PRIEU42 1503-1504
  byte   PRIEU53 1505-1506
  byte   PRIEU01 1507-1508
  byte   PRING31 1509-1510
  byte   PRING42 1511-1512
  byte   PRING53 1513-1514
  byte   PRING01 1515-1516
  byte   PRIOG31 1517-1518
  byte   PRIOG42 1519-1520
  byte   PRIOG53 1521-1522
  byte   PRIOG01 1523-1524
  byte   PRIS31 1525-1526
  byte   PRIS42 1527-1528
  byte   PRIS53 1529-1530
  byte   PRIS01 1531-1532
  byte   PRIV31 1533-1534
  byte   PRIV42 1535-1536
  byte   PRIV53 1537-1538
  byte   PRIV01 1539-1540
  byte   PRIVAT31 1541-1542
  byte   PRIVAT42 1543-1544
  byte   PRIVAT53 1545-1546
  byte   PRIVAT01 1547-1548
  byte   PROUT31 1549-1550
  byte   PROUT42 1551-1552
  byte   PROUT53 1553-1554
  byte   PROUT01 1555-1556
  byte   PUB31X 1557-1558
  byte   PUB42X 1559-1560
  byte   PUB53X 1561-1562
  byte   PUB01X 1563-1564
  byte   PUBAT31X 1565-1566
  byte   PUBAT42X 1567-1568
  byte   PUBAT53X 1569-1570
  byte   PUBAT01X 1571-1572
  byte   INS31X 1573-1574
  byte   INS42X 1575-1576
  byte   INS53X 1577-1578
  byte   INS01X 1579-1580
  byte   INSAT31X 1581-1582
  byte   INSAT42X 1583-1584
  byte   INSAT53X 1585-1586
  byte   INSAT01X 1587-1588
  byte   STAPR31 1589-1590
  byte   STAPR42 1591-1592
  byte   STAPR53 1593-1594
  byte   STAPR01 1595-1596
  byte   STPRAT31 1597-1598
  byte   STPRAT42 1599-1600
  byte   STPRAT53 1601-1602
  byte   STPRAT01 1603-1604
  byte   DENTIN31 1605-1606
  byte   DENTIN42 1607-1608
  byte   DENTIN53 1609-1610
  byte   PMEDIN31 1611-1612
  byte   PMEDIN42 1613-1614
  byte   PMEDIN53 1615-1616
  int    DDNWRK31 1617-1619
  int    DDNWRK42 1620-1622
  int    DDNWRK53 1623-1625
  int    WKINBD31 1626-1628
  int    WKINBD42 1629-1631
  int    WKINBD53 1632-1634
  byte   DDNSCL31 1635-1636
  int    DDNSCL42 1637-1639
  int    DDNSCL53 1640-1642
  byte   SCLNBD31 1643-1644
  byte   SCLNBD42 1645-1646
  int    SCLNBD53 1647-1649
  int    DDBDYS31 1650-1652
  int    DDBDYS42 1653-1655
  int    DDBDYS53 1656-1658
  byte   OTHDYS31 1659-1660
  byte   OTHDYS42 1661-1662
  byte   OTHDYS53 1663-1664
  int    OTHNDD31 1665-1667
  int    OTHNDD42 1668-1670
  int    OTHNDD53 1671-1673
  byte   ACCELI42 1674-1675
  byte   HAVEUS42 1676-1677
  byte   YNOUSC42 1678-1679
  byte   NOREAS42 1680-1681
  byte   SELDSI42 1682-1683
  byte   NEWARE42 1684-1685
  byte   DKWHRU42 1686-1687
  byte   USCNOT42 1688-1689
  byte   PERSLA42 1690-1691
  byte   DIFFPL42 1692-1693
  byte   INSRPL42 1694-1695
  byte   MYSELF42 1696-1697
  byte   CARECO42 1698-1699
  byte   OTHINS42 1700-1701
  byte   OTHREA42 1702-1703
  byte   TYPEPL42 1704-1705
  byte   PROVTY42 1706-1707
  byte   YGOTOU42 1708-1709
  byte   NOREA942 1710-1711
  byte   LIKESU42 1712-1713
  byte   DKELSE42 1714-1715
  byte   AFFORD42 1716-1717
  byte   OFFICE42 1718-1719
  byte   AVAILT42 1720-1721
  byte   CONVEN42 1722-1723
  byte   BSTPLA42 1724-1725
  byte   INSREA42 1726-1727
  byte   OTHRE942 1728-1729
  byte   GETTOU42 1730-1731
  byte   TYPEPE42 1732-1733
  byte   LOCATI42 1734-1735
  byte   MINORP42 1736-1737
  byte   PREVEN42 1738-1739
  byte   REFFRL42 1740-1741
  byte   OFFHOU42 1742-1743
  byte   APPTWL42 1744-1745
  byte   APPDIF42 1746-1747
  byte   WAITTI42 1748-1749
  byte   PHONED42 1750-1751
  byte   PRLIST42 1752-1753
  byte   TREATM42 1754-1755
  byte   CONFID42 1756-1757
  byte   PROVST42 1758-1759
  byte   USCQUA42 1760-1761
  byte   CHNGUS42 1762-1763
  byte   YCHNGU42 1764-1765
  byte   ANYUSC42 1766-1767
  byte   YNOMOR42 1768-1769
  byte   NOCARE42 1770-1771
  byte   HCNEED42 1772-1773
  byte   OBTAIN42 1774-1775
  byte   MAINPR42 1776-1777
  byte   NOOTHP42 1778-1779
  byte   NOAFFO42 1780-1781
  byte   INSNOP42 1782-1783
  byte   PREEXC42 1784-1785
  byte   INSRQR42 1786-1787
  byte   REFUSI42 1788-1789
  byte   DISTAN42 1790-1791
  byte   PUBTRA42 1792-1793
  byte   EXPENS42 1794-1795
  byte   HEARPR42 1796-1797
  byte   LANGBA42 1798-1799
  byte   INTOBL42 1800-1801
  byte   INSIDE42 1802-1803
  byte   EQUIPM42 1804-1805
  byte   OFFWOR42 1806-1807
  byte   DKWHER42 1808-1809
  byte   REFUSE42 1810-1811
  byte   CHLDCA42 1812-1813
  byte   NOTIME42 1814-1815
  byte   OTHRPR42 1816-1817
  byte   RTHLTH31 1818-1819
  byte   RTHLTH42 1820-1821
  byte   RTHLTH53 1822-1823
  byte   RTPROX31 1824-1825
  byte   RTPROX42 1826-1827
  byte   RTPROX53 1828-1829
  byte   MNHLTH31 1830-1831
  byte   MNHLTH42 1832-1833
  byte   MNHLTH53 1834-1835
  byte   MNPROX31 1836-1837
  byte   MNPROX42 1838-1839
  byte   MNPROX53 1840-1841
  byte   IADLHP31 1842-1843
  byte   IADLHP42 1844-1845
  byte   IADLHP53 1846-1847
  byte   ADLHLP31 1848-1849
  byte   ADLHLP42 1850-1851
  byte   ADLHLP53 1852-1853
  byte   AIDHLP31 1854-1855
  byte   AIDHLP53 1856-1857
  byte   WLKLIM31 1858-1859
  byte   WLKLIM53 1860-1861
  byte   LFTDIF31 1862-1863
  byte   LFTDIF53 1864-1865
  byte   STPDIF31 1866-1867
  byte   STPDIF53 1868-1869
  byte   WLKDIF31 1870-1871
  byte   WLKDIF53 1872-1873
  byte   MILDIF31 1874-1875
  byte   MILDIF53 1876-1877
  byte   STNDIF31 1878-1879
  byte   STNDIF53 1880-1881
  byte   BENDIF31 1882-1883
  byte   BENDIF53 1884-1885
  byte   RCHDIF31 1886-1887
  byte   RCHDIF53 1888-1889
  byte   FNGRDF31 1890-1891
  byte   FNGRDF53 1892-1893
  byte   ACTLIM31 1894-1895
  byte   ACTLIM53 1896-1897
  byte   WRKLIM31 1898-1899
  byte   WRKLIM53 1900-1901
  byte   HSELIM31 1902-1903
  byte   HSELIM53 1904-1905
  byte   SCHLIM31 1906-1907
  byte   SCHLIM53 1908-1909
  byte   UNABLE31 1910-1911
  byte   UNABLE53 1912-1913
  byte   SOCLIM31 1914-1915
  byte   SOCLIM53 1916-1917
  byte   COGLIM31 1918-1919
  byte   COGLIM53 1920-1921
  byte   WRGLAS42 1922-1923
  byte   SEEDIF42 1924-1925
  byte   BLIND42 1926-1927
  byte   READNW42 1928-1929
  byte   RECPEP42 1930-1931
  byte   VISION42 1932-1933
  byte   HEARAD42 1934-1935
  byte   HEARDI42 1936-1937
  byte   DEAF42 1938-1939
  byte   HEARMO42 1940-1941
  byte   HEARSM42 1942-1943
  byte   HEARNG42 1944-1945
  byte   ANYLIM01 1946-1947
  byte   LSHLTH42 1948-1949
  byte   NEVILL42 1950-1951
  byte   SICEAS42 1952-1953
  byte   HLTHLF42 1954-1955
  byte   WRHLTH42 1956-1957
  byte   CHPMED42 1958-1959
  byte   CHPMHB42 1960-1961
  byte   CHPMCN42 1962-1963
  byte   CHSERV42 1964-1965
  byte   CHSRHB42 1966-1967
  byte   CHSRCN42 1968-1969
  byte   CHLIMI42 1970-1971
  byte   CHLIHB42 1972-1973
  byte   CHLICO42 1974-1975
  byte   CHTHER42 1976-1977
  byte   CHTHHB42 1978-1979
  byte   CHTHCO42 1980-1981
  byte   CHCOUN42 1982-1983
  byte   CHEMPB42 1984-1985
  byte   CSHCN42 1986-1987
  byte   MOMPRO42 1988-1989
  byte   DADPRO42 1990-1991
  byte   UNHAP42 1992-1993
  byte   SCHLBH42 1994-1995
  byte   HAVFUN42 1996-1997
  byte   ADUPRO42 1998-1999
  byte   NERVAF42 2000-2001
  byte   SIBPRO42 2002-2003
  byte   KIDPRO42 2004-2005
  byte   SPRPRO42 2006-2007
  byte   SCHPRO42 2008-2009
  byte   HOMEBH42 2010-2011
  byte   TRBLE42 2012-2013
  byte   CHRTCR42 2014-2015
  byte   CHRTWW42 2016-2017
  byte   CHILCR42 2018-2019
  byte   CHILWW42 2020-2021
  byte   CHAPPT42 2022-2023
  byte   CHNECR42 2024-2025
  byte   CHLIST42 2026-2027
  byte   CHEXPL42 2028-2029
  byte   CHRESP42 2030-2031
  byte   CHPRTM42 2032-2033
  byte   CHHECR42 2034-2035
  byte   CHSPEC42 2036-2037
  byte   CHPRRE42 2038-2039
  byte   MESHGT42 2040-2041
  byte   WHNHGT42 2042-2043
  byte   MESWGT42 2044-2045
  byte   WHNWGT42 2046-2047
  double CHBMIX42 2048-2051
  byte   MESVIS42 2052-2053
  byte   MESBPR42 2054-2055
  byte   WHNBPR42 2056-2057
  byte   DENTAL42 2058-2059
  byte   WHNDEN42 2060-2061
  byte   EATHLT42 2062-2063
  byte   WHNEAT42 2064-2065
  byte   PHYSCL42 2066-2067
  byte   WHNPHY42 2068-2069
  byte   SAFEST42 2070-2071
  byte   WHNSAF42 2072-2073
  byte   BOOST42 2074-2075
  byte   WHNBST42 2076-2077
  byte   LAPBLT42 2078-2079
  byte   WHNLAP42 2080-2081
  byte   HELMET42 2082-2083
  byte   WHNHEL42 2084-2085
  byte   NOSMOK42 2086-2087
  byte   WHNSMK42 2088-2089
  byte   TIMALN42 2090-2091
  byte   DENTCK53 2092-2093
  byte   CHOLCK53 2094-2095
  byte   CHECK53 2096-2097
  byte   FLUSHT53 2098-2099
  byte   LSTETH53 2100-2101
  byte   PSA53 2102-2103
  byte   HYSTER53 2104-2105
  byte   PAPSMR53 2106-2107
  byte   BRSTEX53 2108-2109
  byte   MAMOGR53 2110-2111
  byte   STOOL53 2112-2113
  byte   WHENST53 2114-2115
  byte   BOWEL53 2116-2117
  byte   WHNBWL53 2118-2119
  byte   PHYACT53 2120-2121
  double BMINDX53 2122-2125
  byte   SEATBE53 2126-2127
  byte   SRTHRT53 2128-2129
  byte   THSYMP53 2130-2131
  byte   DRTHRT53 2132-2133
  byte   THANTB53 2134-2135
  byte   THSWAB53 2136-2137
  byte   THSYMF53 2138-2139
  byte   THSWBF53 2140-2141
  byte   THANTF53 2142-2143
  byte   DIABDX53 2144-2145
  byte   ASTHDX53 2146-2147
  byte   ASATAK53 2148-2149
  byte   ASMED53 2150-2151
  byte   ASSTER53 2152-2153
  byte   ASFLOW53 2154-2155
  byte   HIBPDX53 2156-2157
  byte   BPMLDX53 2158-2159
  byte   BPCHEK53 2160-2161
  byte   BPMONT53 2162-2163
  byte   CHDDX53 2164-2165
  byte   ANGIDX53 2166-2167
  byte   MIDX53 2168-2169
  byte   OHRTDX53 2170-2171
  byte   STRKDX53 2172-2173
  byte   EMPHDX53 2174-2175
  byte   NOFAT53 2176-2177
  byte   EXRCIS53 2178-2179
  byte   ASPRIN53 2180-2181
  byte   NOASPR53 2182-2183
  byte   STOMCH53 2184-2185
  byte   JTPAIN53 2186-2187
  byte   ARTHDX53 2188-2189
  byte   ARTHTX53 2190-2191
  byte   SVERLANG 2192-2193
  int    ADPRX42 2194-2196
  byte   ADRTCR42 2197-2198
  byte   ADRTWW42 2199-2200
  byte   ADILCR42 2201-2202
  byte   ADILWW42 2203-2204
  byte   ADAPPT42 2205-2206
  byte   ADNECR42 2207-2208
  byte   ADLIST42 2209-2210
  byte   ADEXPL42 2211-2212
  byte   ADRESP42 2213-2214
  byte   ADPRTM42 2215-2216
  byte   ADHECR42 2217-2218
  byte   ADSMOK42 2219-2220
  byte   ADDSMK42 2221-2222
  byte   ADDRBP42 2223-2224
  byte   ADSPEC42 2225-2226
  byte   ADPRRE42 2227-2228
  byte   ADGENH42 2229-2230
  byte   ADDAYA42 2231-2232
  byte   ADCLIM42 2233-2234
  byte   ADPACC42 2235-2236
  byte   ADPLMT42 2237-2238
  double PCS42 2239-2243
  byte   ADMACC42 2244-2245
  byte   ADMLMT42 2246-2247
  double MCS42 2248-2252
  byte   SFFLAG42 2253-2253
  byte   ADPAIN42 2254-2255
  byte   ADCALM42 2256-2257
  byte   ADPEP42 2258-2259
  byte   ADBLUE42 2260-2261
  byte   ADSOCA42 2262-2263
  byte   ADMOBI42 2264-2265
  byte   ADSELF42 2266-2267
  byte   ADACTI42 2268-2269
  byte   ADPAYN42 2270-2271
  byte   ADDEPR42 2272-2273
  int    ADSCAL42 2274-2276
  double EQU42 2277-2281
  byte   ADINSA42 2282-2283
  byte   ADINSB42 2284-2285
  byte   ADRISK42 2286-2287
  byte   ADOVER42 2288-2289
  byte   DSDIA53 2290-2291
  byte   DSA1C53 2292-2293
  byte   DSCKFT53 2294-2295
  byte   DSEYE53 2296-2297
  byte   DSKIDN53 2298-2299
  byte   DSEYPR53 2300-2301
  byte   DSDIET53 2302-2303
  byte   DSMED53 2304-2305
  byte   DSINSU53 2306-2307
  byte   DSPRX53 2308-2309
  long   TOTTCH01 2310-2315
  long   TOTEXP01 2316-2321
  long   TOTSLF01 2322-2326
  long   TOTMCR01 2327-2332
  long   TOTMCD01 2333-2338
  long   TOTPRV01 2339-2344
  long   TOTVA01 2345-2349
  long   TOTTRI01 2350-2354
  long   TOTOFD01 2355-2359
  long   TOTSTL01 2360-2364
  long   TOTWCP01 2365-2369
  long   TOTOPR01 2370-2375
  long   TOTOPU01 2376-2381
  long   TOTOSR01 2382-2386
  int    OBTOTV01 2387-2389
  long   OBVTCH01 2390-2395
  long   OBVEXP01 2396-2400
  long   OBVSLF01 2401-2405
  long   OBVMCR01 2406-2410
  long   OBVMCD01 2411-2415
  long   OBVPRV01 2416-2420
  long   OBVVA01 2421-2425
  int    OBVTRI01 2426-2429
  int    OBVOFD01 2430-2433
  int    OBVSTL01 2434-2437
  long   OBVWCP01 2438-2442
  long   OBVOPR01 2443-2447
  long   OBVOPU01 2448-2452
  long   OBVOSR01 2453-2457
  int    OBDRV01 2458-2460
  long   OBDTCH01 2461-2466
  long   OBDEXP01 2467-2471
  long   OBDSLF01 2472-2476
  long   OBDMCR01 2477-2481
  long   OBDMCD01 2482-2486
  long   OBDPRV01 2487-2491
  long   OBDVA01 2492-2496
  int    OBDTRI01 2497-2500
  int    OBDOFD01 2501-2504
  int    OBDSTL01 2505-2508
  long   OBDWCP01 2509-2513
  long   OBDOPR01 2514-2518
  long   OBDOPU01 2519-2523
  long   OBDOSR01 2524-2528
  int    OBOTHV01 2529-2531
  long   OBOTCH01 2532-2536
  long   OBOEXP01 2537-2541
  long   OBOSLF01 2542-2546
  long   OBOMCR01 2547-2551
  int    OBOMCD01 2552-2555
  long   OBOPRV01 2556-2560
  int    OBOVA01 2561-2564
  int    OBOTRI01 2565-2568
  int    OBOOFD01 2569-2572
  int    OBOSTL01 2573-2576
  long   OBOWCP01 2577-2581
  long   OBOOPR01 2582-2586
  int    OBOOPU01 2587-2590
  int    OBOOSR01 2591-2594
  int    OBCHIR01 2595-2597
  long   OBCTCH01 2598-2602
  long   OBCEXP01 2603-2607
  int    OBCSLF01 2608-2611
  int    OBCMCR01 2612-2615
  int    OBCMCD01 2616-2619
  int    OBCPRV01 2620-2623
  int    OBCVA01 2624-2626
  int    OBCTRI01 2627-2630
  byte   OBCOFD01 2631-2631
  int    OBCSTL01 2632-2634
  long   OBCWCP01 2635-2639
  int    OBCOPR01 2640-2643
  byte   OBCOPU01 2644-2644
  int    OBCOSR01 2645-2648
  int    OBNURS01 2649-2651
  long   OBNTCH01 2652-2656
  long   OBNEXP01 2657-2661
  long   OBNSLF01 2662-2666
  long   OBNMCR01 2667-2671
  int    OBNMCD01 2672-2675
  long   OBNPRV01 2676-2680
  int    OBNVA01 2681-2684
  int    OBNTRI01 2685-2687
  int    OBNOFD01 2688-2691
  int    OBNSTL01 2692-2695
  int    OBNWCP01 2696-2699
  long   OBNOPR01 2700-2704
  int    OBNOPU01 2705-2708
  int    OBNOSR01 2709-2712
  byte   OBOPTO01 2713-2714
  int    OBETCH01 2715-2718
  int    OBEEXP01 2719-2722
  int    OBESLF01 2723-2726
  int    OBEMCR01 2727-2730
  int    OBEMCD01 2731-2733
  int    OBEPRV01 2734-2737
  int    OBEVA01 2738-2740
  int    OBETRI01 2741-2743
  byte   OBEOFD01 2744-2745
  int    OBESTL01 2746-2748
  int    OBEWCP01 2749-2751
  int    OBEOPR01 2752-2754
  byte   OBEOPU01 2755-2755
  int    OBEOSR01 2756-2758
  byte   OBASST01 2759-2760
  int    OBATCH01 2761-2764
  int    OBAEXP01 2765-2768
  int    OBASLF01 2769-2771
  int    OBAMCR01 2772-2774
  int    OBAMCD01 2775-2778
  int    OBAPRV01 2779-2782
  int    OBAVA01 2783-2786
  int    OBATRI01 2787-2789
  int    OBAOFD01 2790-2792
  byte   OBASTL01 2793-2794
  int    OBAWCP01 2795-2798
  int    OBAOPR01 2799-2801
  int    OBAOPU01 2802-2804
  int    OBAOSR01 2805-2808
  byte   OBTHER01 2809-2810
  long   OBTTCH01 2811-2815
  long   OBTEXP01 2816-2820
  long   OBTSLF01 2821-2825
  int    OBTMCR01 2826-2829
  int    OBTMCD01 2830-2833
  int    OBTPRV01 2834-2837
  int    OBTVA01 2838-2841
  int    OBTTRI01 2842-2844
  int    OBTOFD01 2845-2847
  int    OBTSTL01 2848-2851
  long   OBTWCP01 2852-2856
  int    OBTOPR01 2857-2860
  int    OBTOPU01 2861-2863
  int    OBTOSR01 2864-2867
  int    OPTOTV01 2868-2870
  long   OPFTCH01 2871-2876
  long   OPFEXP01 2877-2881
  long   OPFSLF01 2882-2886
  long   OPFMCR01 2887-2891
  long   OPFMCD01 2892-2896
  long   OPFPRV01 2897-2901
  long   OPFVA01 2902-2906
  int    OPFTRI01 2907-2910
  int    OPFOFD01 2911-2914
  int    OPFSTL01 2915-2918
  long   OPFWCP01 2919-2923
  long   OPFOPR01 2924-2928
  int    OPFOPU01 2929-2932
  int    OPFOSR01 2933-2936
  long   OPDEXP01 2937-2941
  long   OPDTCH01 2942-2946
  int    OPDSLF01 2947-2950
  int    OPDMCR01 2951-2954
  int    OPDMCD01 2955-2958
  int    OPDPRV01 2959-2962
  int    OPDVA01 2963-2966
  int    OPDTRI01 2967-2969
  byte   OPDOFD01 2970-2970
  int    OPDSTL01 2971-2973
  int    OPDWCP01 2974-2977
  int    OPDOPR01 2978-2981
  int    OPDOPU01 2982-2984
  int    OPDOSR01 2985-2988
  byte   OPDRV01 2989-2990
  long   OPVTCH01 2991-2995
  long   OPVEXP01 2996-3000
  long   OPVSLF01 3001-3005
  long   OPVMCR01 3006-3010
  int    OPVMCD01 3011-3014
  long   OPVPRV01 3015-3019
  int    OPVVA01 3020-3023
  int    OPVTRI01 3024-3027
  int    OPVOFD01 3028-3031
  int    OPVSTL01 3032-3035
  long   OPVWCP01 3036-3040
  int    OPVOPR01 3041-3044
  int    OPVOPU01 3045-3048
  int    OPVOSR01 3049-3052
  long   OPSEXP01 3053-3057
  long   OPSTCH01 3058-3062
  int    OPSSLF01 3063-3066
  int    OPSMCR01 3067-3070
  int    OPSMCD01 3071-3074
  int    OPSPRV01 3075-3078
  int    OPSVA01 3079-3081
  int    OPSTRI01 3082-3084
  byte   OPSOFD01 3085-3085
  int    OPSSTL01 3086-3088
  int    OPSWCP01 3089-3092
  int    OPSOPR01 3093-3096
  int    OPSOPU01 3097-3099
  int    OPSOSR01 3100-3103
  int    OPOTHV01 3104-3106
  long   OPOTCH01 3107-3112
  long   OPOEXP01 3113-3117
  int    OPOSLF01 3118-3121
  long   OPOMCR01 3122-3126
  long   OPOMCD01 3127-3131
  long   OPOPRV01 3132-3136
  int    OPOVA01 3137-3140
  int    OPOTRI01 3141-3144
  int    OPOOFD01 3145-3148
  int    OPOSTL01 3149-3152
  long   OPOWCP01 3153-3157
  long   OPOOPR01 3158-3162
  int    OPOOPU01 3163-3165
  int    OPOOSR01 3166-3169
  long   OPPEXP01 3170-3174
  long   OPPTCH01 3175-3179
  int    OPPSLF01 3180-3183
  int    OPPMCR01 3184-3187
  int    OPPMCD01 3188-3191
  int    OPPPRV01 3192-3195
  int    OPPVA01 3196-3199
  int    OPPTRI01 3200-3202
  byte   OPPOFD01 3203-3203
  int    OPPSTL01 3204-3206
  int    OPPWCP01 3207-3209
  int    OPPOPR01 3210-3213
  int    OPPOPU01 3214-3216
  int    OPPOSR01 3217-3219
  int    AMCHIR01 3220-3222
  long   AMCTCH01 3223-3227
  long   AMCEXP01 3228-3232
  int    AMCSLF01 3233-3236
  int    AMCMCR01 3237-3240
  int    AMCMCD01 3241-3244
  int    AMCPRV01 3245-3248
  int    AMCVA01 3249-3252
  int    AMCTRI01 3253-3256
  int    AMCOFD01 3257-3260
  int    AMCSTL01 3261-3263
  long   AMCWCP01 3264-3268
  int    AMCOPR01 3269-3272
  byte   AMCOPU01 3273-3273
  int    AMCOSR01 3274-3277
  int    AMNURS01 3278-3280
  long   AMNTCH01 3281-3286
  long   AMNEXP01 3287-3291
  long   AMNSLF01 3292-3296
  long   AMNMCR01 3297-3301
  long   AMNMCD01 3302-3306
  long   AMNPRV01 3307-3311
  int    AMNVA01 3312-3315
  int    AMNTRI01 3316-3318
  int    AMNOFD01 3319-3322
  int    AMNSTL01 3323-3326
  int    AMNWCP01 3327-3330
  long   AMNOPR01 3331-3335
  int    AMNOPU01 3336-3339
  int    AMNOSR01 3340-3343
  byte   AMOPTO01 3344-3345
  int    AMETCH01 3346-3349
  int    AMEEXP01 3350-3353
  int    AMESLF01 3354-3357
  int    AMEMCR01 3358-3361
  int    AMEMCD01 3362-3364
  int    AMEPRV01 3365-3368
  int    AMEVA01 3369-3371
  int    AMETRI01 3372-3374
  int    AMEOFD01 3375-3377
  int    AMESTL01 3378-3380
  int    AMEWCP01 3381-3383
  int    AMEOPR01 3384-3386
  byte   AMEOPU01 3387-3387
  int    AMEOSR01 3388-3390
  byte   AMASST01 3391-3392
  int    AMATCH01 3393-3396
  int    AMAEXP01 3397-3400
  int    AMASLF01 3401-3403
  int    AMAMCR01 3404-3406
  int    AMAMCD01 3407-3410
  int    AMAPRV01 3411-3414
  int    AMAVA01 3415-3418
  int    AMATRI01 3419-3421
  int    AMAOFD01 3422-3424
  byte   AMASTL01 3425-3426
  int    AMAWCP01 3427-3430
  int    AMAOPR01 3431-3433
  int    AMAOPU01 3434-3436
  int    AMAOSR01 3437-3440
  int    AMTHER01 3441-3443
  long   AMTTCH01 3444-3448
  long   AMTEXP01 3449-3453
  long   AMTSLF01 3454-3458
  long   AMTMCR01 3459-3463
  int    AMTMCD01 3464-3467
  long   AMTPRV01 3468-3472
  int    AMTVA01 3473-3476
  int    AMTTRI01 3477-3480
  int    AMTOFD01 3481-3483
  int    AMTSTL01 3484-3487
  long   AMTWCP01 3488-3492
  int    AMTOPR01 3493-3496
  int    AMTOPU01 3497-3499
  int    AMTOSR01 3500-3503
  byte   AMTOTC01 3504-3505
  byte   AMDRC01 3506-3507
  byte   ERTOT01 3508-3509
  long   ERFTCH01 3510-3514
  long   ERFEXP01 3515-3519
  int    ERFSLF01 3520-3523
  long   ERFMCR01 3524-3528
  int    ERFMCD01 3529-3532
  long   ERFPRV01 3533-3537
  int    ERFVA01 3538-3541
  int    ERFTRI01 3542-3545
  int    ERFOFD01 3546-3549
  int    ERFSTL01 3550-3553
  int    ERFWCP01 3554-3557
  long   ERFOPR01 3558-3562
  int    ERFOPU01 3563-3566
  int    ERFOSR01 3567-3570
  int    ERDEXP01 3571-3574
  long   ERDTCH01 3575-3579
  int    ERDSLF01 3580-3583
  int    ERDMCR01 3584-3587
  int    ERDMCD01 3588-3591
  int    ERDPRV01 3592-3595
  int    ERDVA01 3596-3598
  int    ERDTRI01 3599-3601
  byte   ERDOFD01 3602-3603
  int    ERDSTL01 3604-3606
  int    ERDWCP01 3607-3610
  int    ERDOPR01 3611-3614
  int    ERDOPU01 3615-3618
  int    ERDOSR01 3619-3621
  byte   IPZERO01 3622-3623
  long   ZIFTCH01 3624-3628
  long   ZIFEXP01 3629-3633
  int    ZIFSLF01 3634-3637
  long   ZIFMCR01 3638-3642
  int    ZIFMCD01 3643-3646
  int    ZIFPRV01 3647-3650
  int    ZIFVA01 3651-3654
  byte   ZIFTRI01 3655-3655
  byte   ZIFOFD01 3656-3656
  byte   ZIFSTL01 3657-3657
  int    ZIFWCP01 3658-3661
  int    ZIFOPR01 3662-3665
  byte   ZIFOPU01 3666-3666
  int    ZIFOSR01 3667-3670
  int    ZIDEXP01 3671-3674
  long   ZIDTCH01 3675-3679
  int    ZIDSLF01 3680-3683
  int    ZIDMCR01 3684-3687
  int    ZIDMCD01 3688-3690
  int    ZIDPRV01 3691-3694
  byte   ZIDVA01 3695-3695
  byte   ZIDTRI01 3696-3696
  byte   ZIDOFD01 3697-3697
  byte   ZIDSTL01 3698-3698
  int    ZIDWCP01 3699-3701
  int    ZIDOPR01 3702-3705
  int    ZIDOPU01 3706-3708
  byte   ZIDOSR01 3709-3709
  byte   IPDIS01 3710-3711
  long   IPFEXP01 3712-3717
  long   IPFTCH01 3718-3723
  long   IPFSLF01 3724-3728
  long   IPFMCR01 3729-3734
  long   IPFMCD01 3735-3739
  long   IPFPRV01 3740-3745
  long   IPFVA01 3746-3750
  long   IPFTRI01 3751-3755
  int    IPFOFD01 3756-3759
  long   IPFSTL01 3760-3764
  long   IPFWCP01 3765-3769
  long   IPFOPR01 3770-3774
  long   IPFOPU01 3775-3780
  long   IPFOSR01 3781-3785
  long   IPDEXP01 3786-3790
  long   IPDTCH01 3791-3795
  int    IPDSLF01 3796-3799
  long   IPDMCR01 3800-3804
  int    IPDMCD01 3805-3808
  long   IPDPRV01 3809-3813
  int    IPDVA01 3814-3817
  int    IPDTRI01 3818-3821
  byte   IPDOFD01 3822-3823
  int    IPDSTL01 3824-3826
  int    IPDWCP01 3827-3830
  long   IPDOPR01 3831-3835
  int    IPDOPU01 3836-3839
  int    IPDOSR01 3840-3843
  int    IPNGTD01 3844-3846
  byte   DVTOT01 3847-3848
  long   DVTTCH01 3849-3853
  long   DVTEXP01 3854-3858
  long   DVTSLF01 3859-3863
  int    DVTMCR01 3864-3867
  int    DVTMCD01 3868-3871
  long   DVTPRV01 3872-3876
  int    DVTVA01 3877-3880
  int    DVTTRI01 3881-3884
  int    DVTOFD01 3885-3888
  int    DVTSTL01 3889-3892
  int    DVTWCP01 3893-3896
  int    DVTOPR01 3897-3900
  int    DVTOPU01 3901-3904
  int    DVTOSR01 3905-3908
  byte   DVGEN01 3909-3910
  long   DVGTCH01 3911-3915
  long   DVGEXP01 3916-3920
  long   DVGSLF01 3921-3925
  int    DVGMCR01 3926-3929
  int    DVGMCD01 3930-3933
  int    DVGPRV01 3934-3937
  int    DVGVA01 3938-3941
  int    DVGTRI01 3942-3945
  int    DVGOFD01 3946-3949
  int    DVGSTL01 3950-3953
  int    DVGWCP01 3954-3957
  int    DVGOPR01 3958-3961
  int    DVGOPU01 3962-3965
  int    DVGOSR01 3966-3969
  byte   DVORTH01 3970-3971
  long   DVOTCH01 3972-3976
  long   DVOEXP01 3977-3981
  long   DVOSLF01 3982-3986
  byte   DVOMCR01 3987-3987
  int    DVOMCD01 3988-3991
  long   DVOPRV01 3992-3996
  int    DVOVA01 3997-4000
  int    DVOTRI01 4001-4004
  byte   DVOOFD01 4005-4005
  int    DVOSTL01 4006-4009
  byte   DVOWCP01 4010-4010
  int    DVOOPR01 4011-4013
  byte   DVOOPU01 4014-4014
  int    DVOOSR01 4015-4018
  int    HHTOTD01 4019-4021
  int    HHAGD01 4022-4024
  long   HHATCH01 4025-4030
  long   HHAEXP01 4031-4036
  long   HHASLF01 4037-4041
  long   HHAMCR01 4042-4046
  long   HHAMCD01 4047-4052
  long   HHAPRV01 4053-4057
  long   HHAVA01 4058-4062
  byte   HHATRI01 4063-4063
  int    HHAOFD01 4064-4067
  long   HHASTL01 4068-4072
  byte   HHAWCP01 4073-4073
  long   HHAOPR01 4074-4079
  int    HHAOPU01 4080-4082
  byte   HHAOSR01 4083-4083
  int    HHINDD01 4084-4086
  long   HHNTCH01 4087-4091
  long   HHNEXP01 4092-4096
  long   HHNSLF01 4097-4101
  int    HHNMCR01 4102-4105
  int    HHNMCD01 4106-4109
  int    HHNPRV01 4110-4113
  int    HHNVA01 4114-4117
  byte   HHNTRI01 4118-4118
  byte   HHNOFD01 4119-4119
  int    HHNSTL01 4120-4122
  byte   HHNWCP01 4123-4123
  int    HHNOPR01 4124-4127
  int    HHNOPU01 4128-4131
  int    HHNOSR01 4132-4134
  int    HHINFD01 4135-4137
  int    VISEXP01 4138-4141
  int    VISTCH01 4142-4145
  int    VISSLF01 4146-4149
  int    VISMCR01 4150-4152
  int    VISMCD01 4153-4156
  int    VISPRV01 4157-4160
  int    VISVA01 4161-4163
  int    VISTRI01 4164-4166
  int    VISOFD01 4167-4169
  int    VISSTL01 4170-4172
  int    VISWCP01 4173-4175
  int    VISOPR01 4176-4178
  int    VISOPU01 4179-4181
  int    VISOSR01 4182-4184
  long   OTHTCH01 4185-4189
  long   OTHEXP01 4190-4194
  long   OTHSLF01 4195-4199
  int    OTHMCR01 4200-4203
  int    OTHMCD01 4204-4207
  int    OTHPRV01 4208-4211
  int    OTHVA01 4212-4215
  int    OTHTRI01 4216-4218
  int    OTHOFD01 4219-4222
  int    OTHSTL01 4223-4226
  int    OTHWCP01 4227-4230
  int    OTHOPR01 4231-4234
  int    OTHOPU01 4235-4237
  int    OTHOSR01 4238-4240
  int    RXTOT01 4241-4243
  long   RXEXP01 4244-4248
  long   RXSLF01 4249-4253
  int    RXMCR01 4254-4257
  long   RXMCD01 4258-4262
  long   RXPRV01 4263-4267
  int    RXVA01 4268-4271
  int    RXTRI01 4272-4275
  int    RXOFD01 4276-4279
  int    RXSTL01 4280-4283
  long   RXWCP01 4284-4288
  int    RXOPR01 4289-4292
  int    RXOPU01 4293-4296
  int    RXOSR01 4297-4300
  double PERWT01F 4301-4312
  double FAMWT01F 4313-4324
  double FAMWT01C 4325-4336
  double SAQWT01F 4337-4348
  double DIABW01F 4349-4360
  int    VARSTR01 4361-4363
  byte   VARPSU01 4364-4365
using H60.dat;

*DEFINE VARIABLE LABELS;
label variable DUID "DWELLING UNIT ID";
label variable PID "PERSON NUMBER";
label variable DUPERSID "PERSID (DUID + PID)";
label variable PANEL01 "PANEL NUMBER";
label variable FAMID31 "FAMILY ID (STUDENT MERGED IN) - R3/1";
label variable FAMID42 "FAMILY ID (STUDENT MERGED IN) - R4/2";
label variable FAMID53 "FAMILY ID (STUDENT MERGED IN) - R5/3";
label variable FAMID01 "FAMILY ID (STUDENT MERGED IN) - 12/31/01";
label variable FAMIDYR "ANNUAL FAMILY IDENTIFIER";
label variable CPSFAMID "CPS-LIKE FAMILY IDENTIFIER";
label variable HIEUIDX "HIEU IDENTIFIER";
label variable FCSZ1231 "FAM SIZE RESPONDING 12/31 CPS FAMILY-01";
label variable FCRP1231 "REF PERSON OF 12/31 CPS FAMILY-01";
label variable RULETR31 "RU LETTER - R3/1";
label variable RULETR42 "RU LETTER - R4/2";
label variable RULETR53 "RU LETTER - R5/3";
label variable RULETR01 "RU LETTER AS OF 12/31/01";
label variable RUSIZE31 "RU SIZE - R3/1";
label variable RUSIZE42 "RU SIZE - R4/2";
label variable RUSIZE53 "RU SIZE - R5/3";
label variable RUSIZE01 "RU SIZE AS OF 12/31/01";
label variable RUCLAS31 "RU FIELDED AS:STANDARD/NEW/STUDENT-R3/1";
label variable RUCLAS42 "RU FIELDED AS:STANDARD/NEW/STUDENT-R4/2";
label variable RUCLAS53 "RU FIELDED AS:STANDARD/NEW/STUDENT-R5/3";
label variable RUCLAS01 "RU FIELDED AS:STANDARD/NEW/STUD-12/31/01";
label variable FAMSZE31 "RU SIZE INCLUDING STUDENTS - R3/1";
label variable FAMSZE42 "RU SIZE INCLUDING STUDENTS - R4/2";
label variable FAMSZE53 "RU SIZE INCLUDING STUDENTS - R5/3";
label variable FAMSZE01 "RU SIZE INCLUDING STUDENT AS OF 12/31/01";
label variable FMRS1231 "MEMBER OF RESPONDING 12/31 FAMILY";
label variable FAMS1231 "FAMILY SIZE OF RESPONDING 12/31 FAMILY";
label variable FAMSZEYR "SIZE OF RESPONDING ANNUALIZED FAMILY";
label variable FAMRFPYR "REFERENCE PERSON OF ANNUALIZED FAMILY";
label variable REFPRS31 "REFERENCE PERSON AT - R3/1";
label variable REFPRS42 "REFERENCE PERSON AT - R4/2";
label variable REFPRS53 "REFERENCE PERSON AT - R5/3";
label variable REFPRS01 "REFERENCE PERSON AS OF 12/31/01";
label variable RESP31 "1ST RESPONDENT INDICATOR FOR R3/1";
label variable RESP42 "1ST RESPONDENT INDICATOR FOR R4/2";
label variable RESP53 "1ST RESPONDENT INDICATOR FOR R5/3";
label variable RESP01 "1ST RESPONDENT INDICATOR AS OF 12/31/01";
label variable PROXY31 "WAS RESPONDENT A PROXY IN R3/1";
label variable PROXY42 "WAS RESPONDENT A PROXY IN R4/2";
label variable PROXY53 "WAS RESPONDENT A PROXY IN R5/3";
label variable PROXY01 "WAS RESPONDENT A PROXY AS OF 12/31/01";
label variable INTVLANG "LANGUAGE INTERVIEW WAS COMPLETED";
label variable BEGRFD31 "R3/1 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM31 "R3/1 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY31 "R3/1 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD31 "R3/1 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM31 "R3/1 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY31 "R3/1 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFD42 "R4/2 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM42 "R4/2 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY42 "R4/2 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD42 "R4/2 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM42 "R4/2 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY42 "R4/2 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFD53 "R5/3 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM53 "R5/3 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY53 "R5/3 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD53 "R5/3 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM53 "R5/3 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY53 "R5/3 REFERENCE PERIOD END DATE: YEAR";
label variable ENDRFD01 "2001 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM01 "2001 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY01 "2001 REFERENCE PERIOD END DATE: YEAR";
label variable KEYNESS "PERSON KEY STATUS";
label variable INSCOP31 "INSCOPE - R3/1";
label variable INSCOP42 "INSCOPE - R4/2";
label variable INSCOP53 "INSCOPE - R5/3";
label variable INSCOP01 "INSCOPE - R5/3 START THROUGH 12/31/01";
label variable INSC1231 "INSCOPE STATUS ON 12/31/01";
label variable INSCOPE "WAS PERSON EVER INSCOPE IN 2001";
label variable ELGRND31 "ELIGIBILITY - R3/1";
label variable ELGRND42 "ELIGIBILITY - R4/2";
label variable ELGRND53 "ELIGIBILITY - R5/3";
label variable ELGRND01 "ELIGIBILITY STATUS AS OF 12/31/01";
label variable ELIGIBLE "WAS PERSON EVER ELIGIBLE IN 2001";
label variable PSTATS31 "PERSON DISPOSITION STATUS - R3/1";
label variable PSTATS42 "PERSON DISPOSITION STATUS - R4/2";
label variable PSTATS53 "PERSON DISPOSITION STATUS - R5/3";
label variable RURSLT31 "RU RESULT - R3/1";
label variable RURSLT42 "RU RESULT - R4/2";
label variable RURSLT53 "RU RESULT - R5/3";
label variable REGION31 "CENSUS REGION - R3/1";
label variable REGION42 "CENSUS REGION - R4/2";
label variable REGION53 "CENSUS REGION - R5/3";
label variable REGION01 "CENSUS REGION AS OF 12/31/01";
label variable MSA31 "MSA STATUS - R3/1";
label variable MSA42 "MSA STATUS - R4/2";
label variable MSA53 "MSA STATUS - R5/3";
label variable MSA01 "MSA AS OF 12/31/01";
label variable AGE31X "AGE - R3/1 (EDITED/IMPUTED)";
label variable AGE42X "AGE - R4/2 (EDITED/IMPUTED)";
label variable AGE53X "AGE - R5/3 (EDITED/IMPUTED)";
label variable AGE01X "AGE AS OF 12/31/01 (EDITED/IMPUTED)";
label variable DOBMM "DATE OF BIRTH: MONTH";
label variable DOBYY "DATE OF BIRTH: YEAR";
label variable SEX "SEX";
label variable RACEX "RACE (EDITED/IMPUTED)";
label variable RACETHNX "RACE/ETHNICITY (EDITED/IMPUTED)";
label variable HISPANX "HISPANIC ETHNICITY (EDITED/IMPUTED)";
label variable HISPCAT "SPECIFIC HISPANIC ETHNICITY GROUP";
label variable MARRY31X "MARITAL STATUS - R3/1 (EDITED/IMPUTED)";
label variable MARRY42X "MARITAL STATUS - R4/2 (EDITED/IMPUTED)";
label variable MARRY53X "MARITAL STATUS - R5/3 (EDITED/IMPUTED)";
label variable MARRY01X "MARITAL STATUS-12/31/01 (EDITED/IMPUTED)";
label variable SPOUID31 "SPOUSE ID - R3/1";
label variable SPOUID42 "SPOUSE ID - R4/2";
label variable SPOUID53 "SPOUSE ID - R5/3";
label variable SPOUID01 "SPOUSE ID - 12/31/01";
label variable SPOUIN31 "MARITAL STATUS W/SPOUSE PRESENT-R3/1";
label variable SPOUIN42 "MARITAL STATUS W/SPOUSE PRESENT-R4/2";
label variable SPOUIN53 "MARITAL STATUS W/SPOUSE PRESENT-R5/3";
label variable SPOUIN01 "MARITAL STATUS W/SPOUSE PRESENT-12/31/01";
label variable EDUCYEAR "YEARS OF EDUC WHEN FIRST ENTERED MEPS";
label variable HIDEGYR "HIGHEST DEGREE WHEN FIRST ENTERED MEPS";
label variable FTSTU31X "STUDENT STATUS IF AGES 17-23 - R3/1";
label variable FTSTU42X "STUDENT STATUS IF AGES 17-23 - R4/2";
label variable FTSTU53X "STUDENT STATUS IF AGES 17-23 - R5/3";
label variable FTSTU01X "STUDENT STATUS IF AGES 17-23 - 12/31/01";
label variable ACTDTY31 "MILITARY FULL-TIME ACTIVE DUTY - R3/1";
label variable ACTDTY42 "MILITARY FULL-TIME ACTIVE DUTY - R4/2";
label variable ACTDTY53 "MILITARY FULL-TIME ACTIVE DUTY - R5/3";
label variable DIDSERVE "EVER SERVED IN ARMED FORCES";
label variable VETVIET "SERVED IN VIETNAM WAR ERA";
label variable VETKOR "SERVED IN KOREAN WAR ERA";
label variable VETWW "SERVED IN WWI OR WW2 ERA";
label variable VETGULF "SERVED IN PERSIAN GULF/DESERT STORM";
label variable VETOTH "SERVED IN OTHER PERIOD";
label variable RFREL31X "RELATION TO REF PERS-R3/1 (EDIT/IMP)";
label variable RFREL42X "RELATION TO REF PERS-R4/2 (EDIT/IMP)";
label variable RFREL53X "RELATION TO REF PERS-R5/3 (EDIT/IMP)";
label variable RFREL01X "RELATION TO REF PERS-12/31/01 (EDIT/IMP)";
label variable MOPID31X "PID OF PERSON S MOM - RD 3/1";
label variable MOPID42X "PID OF PERSON S MOM - RD 4/2";
label variable MOPID53X "PID OF PERSON S MOM - RD 5/3";
label variable DAPID31X "PID OF PERSON S DAD - RD 3/1";
label variable DAPID42X "PID OF PERSON S DAD - RD 4/2";
label variable DAPID53X "PID OF PERSON S DAD - RD 5/3";
label variable SSIDIS01 "SSI RECEIPT DUE TO DISABILITY";
label variable AFDC01 "DID PERSON S CHECK INCLUDE TANF";
label variable FILEDR01 "HAS PERSON FILED A FED INCOME TAX RETURN";
label variable WILFIL01 "WILL PERSON FILE FED INCOME TAX RETURN";
label variable FLSTAT01 "PERSON S FILING STATUS";
label variable FILER01 "PRIMARY OR SECONDARY FILER";
label variable JTINRU01 "JOINT FILER S MEMBERSHIP IN RU";
label variable JNTPID01 "PID OF JOINT FILER";
label variable CLMDEP01 "DID/WILL PERS CLAIM DEPENDENTS ON RETURN";
label variable DEPDNT01 "PERSON IS FLAGGED A DEPENDENT";
label variable DPINRU01 "DEPENDENTS IN/OUT OF RU";
label variable DPOTSD01 "HOW MANY DEPENDENTS LIVE OUTSIDE RU";
label variable TAXFRM01 "TAX FORM PERSON WILL FILE";
label variable DEDUCT01 "ITEMIZE OR STANDARD DEDUCTION";
label variable ITMEXP01 "WILL PERSON ITEMIZE MEDICAL EXPENSE";
label variable MEXAMT01 "TOTAL MEDICAL EXPENSES DEDUCTED";
label variable NTMDED01 "PERSON S NET MEDICAL EXPENSE DEDUCTION";
label variable TOTDED01 "TOTAL OF ALL ITEMIZED DEDUCTIONS";
label variable CLMHIP01 "DID/WILL PERS DEDUCT HEALTH INSUR. PREM.";
label variable ELDISC01 "DID/WILL PERS RECEIVE ELDERLY/DISAB CRED";
label variable EICRDT01 "DID/WILL PERS RECEIVE EARNED INC CREDIT";
label variable UNEMTX01 "TAXABLE PERCENTAGE OF UNEMPLOYMENT";
label variable INTRTX01 "TAXABLE PERCENTAGE OF INTEREST";
label variable SSECTX01 "TAXABLE PERCENTAGE OF SOCIAL SECURITY";
label variable IRATAX01 "TAXABLE PERCENTAGE OF IRA INCOME";
label variable FOODST01 "DID ANYONE PURCHASE FOOD STAMPS";
label variable FOODMN01 "NUMBER OF MONTHS FOOD STAMPS PURCHASED";
label variable FOODCT01 "MONTHLY AMT FAMILY PAID FOR FOOD STAMPS";
label variable FOODVL01 "MONTHLY VALUE OF FOOD STAMPS";
label variable TTLP01X "PERSON S TOTAL INCOME";
label variable POVCAT01 "FAMILY INCOME AS PERCENT OF POVERTY LINE";
label variable WAGEP01X "PERSON S WAGE INCOME";
label variable WAGIMP01 "WAGE IMPUTATION FLAG";
label variable BUSNP01X "PERSON S BUSINESS INCOME";
label variable BUSIMP01 "BUSINESS INCOME IMPUTATION FLAG";
label variable FARMP01X "PERSON S FARM INCOME";
label variable FARIMP01 "FARM INCOME IMPUTATION FLAG";
label variable UNEMP01X "PERSON S UNEMPLOYMENT COMP INCOME";
label variable UNEIMP01 "UNEMPLOYMENT IMPUTATION FLAG";
label variable WCMPP01X "PERSON S WORKERS  COMPENSATION";
label variable WCPIMP01 "WORKER S COMP IMPUTATION FLAG";
label variable INTRP01X "PERSON S INTEREST INCOME";
label variable INTIMP01 "INTEREST INCOME IMPUTATION FLAG";
label variable DIVDP01X "PERSON S DIVIDEND INCOME";
label variable DIVIMP01 "DIVIDEND INCOME IMPUTATION FLAG";
label variable SALEP01X "PERSON S SALES INCOME";
label variable SALIMP01 "SALES INCOME IMPUTATION FLAG";
label variable PENSP01X "PERSON S PENSION INCOME";
label variable PENIMP01 "PENSION INCOME IMPUTATION FLAG";
label variable SSECP01X "PERSON S SOCIAL SECURITY INCOME";
label variable SSCIMP01 "SOCIAL SECURITY INCOME IMPUTATION FLAG";
label variable TRSTP01X "PERSON S TRUST/RENT INCOME";
label variable TRTIMP01 "TRUST INCOME IMPUTATION FLAG";
label variable VETSP01X "PERSON S VETERANS INCOME";
label variable VETIMP01 "VETERAN S INCOME IMPUTATION FLAG";
label variable IRASP01X "PERSON S IRA INCOME";
label variable IRAIMP01 "IRA INCOME IMPUTATION FLAG";
label variable REFDP01X "PERSON S REFUND INCOME";
label variable REFIMP01 "REFUND INCOME IMPUTATION FLAG";
label variable ALIMP01X "PERSON S ALIMONY INCOME";
label variable ALIIMP01 "ALIMONY INCOME IMPUTATION FLAG";
label variable CHLDP01X "PERSON S CHILD SUPPORT";
label variable CHLIMP01 "CHILD SUPPORT IMPUTATION FLAG";
label variable CASHP01X "PERSON S OTHER REGULAR CASH CONTRIBUTION";
label variable CSHIMP01 "CASH CONTRIBUTION IMPUTATION FLAG";
label variable SSIP01X "PERSON S SSI";
label variable SSIIMP01 "SSI IMPUTATION FLAG";
label variable PUBP01X "PERSON S PUBLIC ASSISTANCE";
label variable PUBIMP01 "PUBLIC ASSISTANCE IMPUTATION FLAG";
label variable OTHRP01X "PERSON S OTHER INCOME";
label variable OTHIMP01 "OTHER INCOME IMPUTAION FLAG";
label variable EMPST31 "EMPLOYMENT STATUS RD 3/1";
label variable EMPST42 "EMPLOYMENT STATUS RD 4/2";
label variable EMPST53 "EMPLOYMENT STATUS RD 5/3";
label variable RNDFLG31 "DATA COLLECTION ROUND FOR RD 3/1 CMJ";
label variable MORJOB31 "HAS MORE THAN ONE JOB RD 3/1 INT DATE";
label variable MORJOB42 "HAS MORE THAN ONE JOB RD 4/2 INT DATE";
label variable MORJOB53 "HAS MORE THAN ONE JOB RD 5/3 INT DATE";
label variable EVRWRK "EVER WRKD FOR PAY IN LIFE AS OF 12/31/01";
label variable HRWG31X "HOURLY WAGE RD 3/1 CMJ (IMP)";
label variable HRWG42X "HOURLY WAGE RD 4/2 CMJ (IMP)";
label variable HRWG53X "HOURLY WAGE RD 5/3 CMJ (IMP)";
label variable HRWGIM31 "HRWG31X IMPUTATION FLAG";
label variable HRWGIM42 "HRWG42X IMPUTATION FLAG";
label variable HRWGIM53 "HRWG53X IMPUTATION FLAG";
label variable HRHOW31 "HOW HOURLY WAGE WAS CALCULATED RD 3/1";
label variable HRHOW42 "HOW HOURLY WAGE WAS CALCULATED RD 4/2";
label variable HRHOW53 "HOW HOURLY WAGE WAS CALCULATED RD 5/3";
label variable HOUR31 "HOURS PER WEEK AT RD 3/1 CMJ";
label variable HOUR42 "HOURS PER WEEK AT RD 4/2 CMJ";
label variable HOUR53 "HOURS PER WEEK AT RD 5/3 CMJ";
label variable TEMPJB31 "IS CMJ A TEMPORARY JOB RD 3/1";
label variable TEMPJB42 "IS CMJ A TEMPORARY JOB RD 4/2";
label variable TEMPJB53 "IS CMJ A TEMPORARY JOB RD 5/3";
label variable SSNLJB31 "IS CMJ A SEASONAL JOB RD 3/1";
label variable SSNLJB42 "IS CMJ A SEASONAL JOB RD 4/2";
label variable SSNLJB53 "IS CMJ A SEASONAL JOB RD 5/3";
label variable SELFCM31 "SELF-EMPLOYED AT RD 3/1 CMJ";
label variable SELFCM42 "SELF-EMPLOYED AT RD 4/2 CMJ";
label variable SELFCM53 "SELF-EMPLOYED AT RD 5/3 CMJ";
label variable DISVW31X "DISAVOWED HEALTH INS AT RD 3/1 CMJ (ED)";
label variable DISVW42X "DISAVOWED HEALTH INS AT RD 4/2 CMJ (ED)";
label variable DISVW53X "DISAVOWED HEALTH INS AT RD 5/3 CMJ (ED)";
label variable CHOIC31 "CHOICE OF HEALTH PLANS AT RD 3/1 CMJ";
label variable CHOIC42 "CHOICE OF HEALTH PLANS AT RD 4/2 CMJ";
label variable CHOIC53 "CHOICE OF HEALTH PLANS AT RD 5/3 CMJ";
label variable CIND31 "CONDENSED INDUSTRY CODE RD 3/1 CMJ";
label variable CIND42 "CONDENSED INDUSTRY CODE RD 4/2 CMJ";
label variable CIND53 "CONDENSED INDUSTRY CODE RD 5/3 CMJ";
label variable NUMEMP31 "NUMBER OF EMPLOYEES AT RD 3/1 CMJ";
label variable NUMEMP42 "NUMBER OF EMPLOYEES AT RD 4/2 CMJ";
label variable NUMEMP53 "NUMBER OF EMPLOYEES AT RD 5/3 CMJ";
label variable MORE31 "RD 3/1 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable MORE42 "RD 4/2 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable MORE53 "RD 5/3 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable UNION31 "UNION STATUS AT RD 3/1 CMJ";
label variable UNION42 "UNION STATUS AT RD 4/2 CMJ";
label variable UNION53 "UNION STATUS AT RD 5/3 CMJ";
label variable NWK31 "REASON NOT WORKING DURING RD 3/1";
label variable NWK42 "REASON NOT WORKING DURING RD 4/2";
label variable NWK53 "REASON NOT WORKING DURING RD 5/3";
label variable CHGJ3142 "CHANGED JOB BETWEEN RD 3/1 AND RD 4/2";
label variable CHGJ4253 "CHANGED JOB BETWEEN RD 4/2 AND RD 5/3";
label variable YCHJ3142 "WHY CHNGD JOB BETWEEN RD 3/1 AND RD 4/2";
label variable YCHJ4253 "WHY CHNGD JOB BETWEEN RD 4/2 AND RD 5/3";
label variable STJBMM31 "MONTH STARTED RD 3/1 CMJ";
label variable STJBDD31 "DAY STARTED RD 3/1 CMJ";
label variable STJBYY31 "YEAR STARTED RD 3/1 CMJ";
label variable STJBMM42 "MONTH STARTED RD 4/2 CMJ";
label variable STJBDD42 "DAY STARTED RD 4/2 CMJ";
label variable STJBYY42 "YEAR STARTED RD 4/2 CMJ";
label variable STJBMM53 "MONTH STARTED RD 5/3 CMJ";
label variable STJBDD53 "DAY STARTED RD 5/3 CMJ";
label variable STJBYY53 "YEAR STARTED RD 5/3 CMJ";
label variable EVRETIRE "PERSON HAS EVER RETIRED";
label variable COCCP31 "CONDENSED OCCUPATION CODE RD 3/1 CMJ";
label variable COCCP42 "CONDENSED OCCUPATION CODE RD 4/2 CMJ";
label variable COCCP53 "CONDENSED OCCUPATION CODE RD 5/3 CMJ";
label variable PAYVAC31 "PAID VACATION AT RD 3/1 CMJ";
label variable PAYVAC42 "PAID VACATION AT RD 4/2 CMJ";
label variable PAYVAC53 "PAID VACATION AT RD 5/3 CMJ";
label variable SICPAY31 "PAID SICK LEAVE AT RD 3/1 CMJ";
label variable SICPAY42 "PAID SICK LEAVE AT RD 4/2 CMJ";
label variable SICPAY53 "PAID SICK LEAVE AT RD 5/3 CMJ";
label variable PAYDR31 "PAID LEAVE TO VISIT DR RD 3/1 CMJ";
label variable PAYDR42 "PAID LEAVE TO VISIT DR RD 4/2 CMJ";
label variable PAYDR53 "PAID LEAVE TO VISIT DR RD 5/3 CMJ";
label variable RETPLN31 "PENSION PLAN AT RD 3/1 CMJ";
label variable RETPLN42 "PENSION PLAN AT RD 4/2 CMJ";
label variable RETPLN53 "PENSION PLAN AT RD 5/3 CMJ";
label variable BSNTY31 "SOLE PROP, PARTNER, CORP, RD 3/1 CMJ";
label variable BSNTY42 "SOLE PROP, PARTNER, CORP, RD 4/2 CMJ";
label variable BSNTY53 "SOLE PROP, PARTNER, CORP, RD 5/3 CMJ";
label variable JOBORG31 "PRIV (PROFIT,NONPROFIT) GOV RD 3/1 CMJ";
label variable JOBORG42 "PRIV (PROFIT,NONPROFIT) GOV RD 4/2 CMJ";
label variable JOBORG53 "PRIV (PROFIT,NONPROFIT) GOV RD 5/3 CMJ";
label variable HELD31X "HEALTH INSUR HELD FROM RD 3/1 CMJ (ED)";
label variable HELD42X "HEALTH INSUR HELD FROM RD 4/2 CMJ (ED)";
label variable HELD53X "HEALTH INSUR HELD FROM RD 5/3 CMJ (ED)";
label variable OFFER31X "HEALTH INSUR OFFERED BY RD 3/1 CMJ (ED)";
label variable OFFER42X "HEALTH INSUR OFFERED BY RD 4/2 CMJ (ED)";
label variable OFFER53X "HEALTH INSUR OFFERED BY RD 5/3 CMJ (ED)";
label variable TRIJA01X "COVERED BY TRICARE IN JAN01 (ED)";
label variable TRIFE01X "COVERED BY TRICARE IN FEB01 (ED)";
label variable TRIMA01X "COVERED BY TRICARE IN MAR01 (ED)";
label variable TRIAP01X "COVERED BY TRICARE IN APR01 (ED)";
label variable TRIMY01X "COVERED BY TRICARE IN MAY01 (ED)";
label variable TRIJU01X "COVERED BY TRICARE IN JUN01 (ED)";
label variable TRIJL01X "COVERED BY TRICARE IN JUL01 (ED)";
label variable TRIAU01X "COVERED BY TRICARE IN AUG01 (ED)";
label variable TRISE01X "COVERED BY TRICARE IN SEP01 (ED)";
label variable TRIOC01X "COVERED BY TRICARE IN OCT01 (ED)";
label variable TRINO01X "COVERED BY TRICARE IN NOV01 (ED)";
label variable TRIDE01X "COVERED BY TRICARE IN DEC01 (ED)";
label variable MCRJA01 "COVERED BY MEDICARE IN JAN01";
label variable MCRFE01 "COVERED BY MEDICARE IN FEB01";
label variable MCRMA01 "COVERED BY MEDICARE IN MAR01";
label variable MCRAP01 "COVERED BY MEDICARE IN APR01";
label variable MCRMY01 "COVERED BY MEDICARE IN MAY01";
label variable MCRJU01 "COVERED BY MEDICARE IN JUN01";
label variable MCRJL01 "COVERED BY MEDICARE IN JUL01";
label variable MCRAU01 "COVERED BY MEDICARE IN AUG01";
label variable MCRSE01 "COVERED BY MEDICARE IN SEP01";
label variable MCROC01 "COVERED BY MEDICARE IN OCT01";
label variable MCRNO01 "COVERED BY MEDICARE IN NOV01";
label variable MCRDE01 "COVERED BY MEDICARE IN DEC01";
label variable MCRJA01X "COVERED BY MEDICARE IN JAN01 (ED)";
label variable MCRFE01X "COVERED BY MEDICARE IN FEB01 (ED)";
label variable MCRMA01X "COVERED BY MEDICARE IN MAR01 (ED)";
label variable MCRAP01X "COVERED BY MEDICARE IN APR01 (ED)";
label variable MCRMY01X "COVERED BY MEDICARE IN MAY01 (ED)";
label variable MCRJU01X "COVERED BY MEDICARE IN JUN01 (ED)";
label variable MCRJL01X "COVERED BY MEDICARE IN JUL01 (ED)";
label variable MCRAU01X "COVERED BY MEDICARE IN AUG01 (ED)";
label variable MCRSE01X "COVERED BY MEDICARE IN SEP01 (ED)";
label variable MCROC01X "COVERED BY MEDICARE IN OCT01 (ED)";
label variable MCRNO01X "COVERED BY MEDICARE IN NOV01 (ED)";
label variable MCRDE01X "COVERED BY MEDICARE IN DEC01 (ED)";
label variable MCDJA01 "COV BY MEDICAID OR SCHIP IN JAN01";
label variable MCDFE01 "COV BY MEDICAID OR SCHIP IN FEB01";
label variable MCDMA01 "COV BY MEDICAID OR SCHIP IN MAR01";
label variable MCDAP01 "COV BY MEDICAID OR SCHIP IN APR01";
label variable MCDMY01 "COV BY MEDICAID OR SCHIP IN MAY01";
label variable MCDJU01 "COV BY MEDICAID OR SCHIP IN JUN01";
label variable MCDJL01 "COV BY MEDICAID OR SCHIP IN JUL01";
label variable MCDAU01 "COV BY MEDICAID OR SCHIP IN AUG01";
label variable MCDSE01 "COV BY MEDICAID OR SCHIP IN SEP01";
label variable MCDOC01 "COV BY MEDICAID OR SCHIP IN OCT01";
label variable MCDNO01 "COV BY MEDICAID OR SCHIP IN NOV01";
label variable MCDDE01 "COV BY MEDICAID OR SCHIP IN DEC01";
label variable MCDJA01X "COV BY MEDICAID OR SCHIP IN JAN01 (ED)";
label variable MCDFE01X "COV BY MEDICAID OR SCHIP IN FEB01 (ED)";
label variable MCDMA01X "COV BY MEDICAID OR SCHIP IN MAR01 (ED)";
label variable MCDAP01X "COV BY MEDICAID OR SCHIP IN APR01 (ED)";
label variable MCDMY01X "COV BY MEDICAID OR SCHIP IN MAY01 (ED)";
label variable MCDJU01X "COV BY MEDICAID OR SCHIP IN JUN01 (ED)";
label variable MCDJL01X "COV BY MEDICAID OR SCHIP IN JUL01 (ED)";
label variable MCDAU01X "COV BY MEDICAID OR SCHIP IN AUG01 (ED)";
label variable MCDSE01X "COV BY MEDICAID OR SCHIP IN SEP01 (ED)";
label variable MCDOC01X "COV BY MEDICAID OR SCHIP IN OCT01 (ED)";
label variable MCDNO01X "COV BY MEDICAID OR SCHIP IN NOV01 (ED)";
label variable MCDDE01X "COV BY MEDICAID OR SCHIP IN DEC01 (ED)";
label variable OPAJA01 "COV BY OTHER PUBLIC A INS IN JAN01";
label variable OPAFE01 "COV BY OTHER PUBLIC A INS IN FEB01";
label variable OPAMA01 "COV BY OTHER PUBLIC A INS IN MAR01";
label variable OPAAP01 "COV BY OTHER PUBLIC A INS IN APR01";
label variable OPAMY01 "COV BY OTHER PUBLIC A INS IN MAY01";
label variable OPAJU01 "COV BY OTHER PUBLIC A INS IN JUN01";
label variable OPAJL01 "COV BY OTHER PUBLIC A INS IN JUL01";
label variable OPAAU01 "COV BY OTHER PUBLIC A INS IN AUG01";
label variable OPASE01 "COV BY OTHER PUBLIC A INS IN SEP01";
label variable OPAOC01 "COV BY OTHER PUBLIC A INS IN OCT01";
label variable OPANO01 "COV BY OTHER PUBLIC A INS IN NOV01";
label variable OPADE01 "COV BY OTHER PUBLIC A INS IN DEC01";
label variable OPBJA01 "COV BY OTHER PUBLIC B INS IN JAN01";
label variable OPBFE01 "COV BY OTHER PUBLIC B INS IN FEB01";
label variable OPBMA01 "COV BY OTHER PUBLIC B INS IN MAR01";
label variable OPBAP01 "COV BY OTHER PUBLIC B INS IN APR01";
label variable OPBMY01 "COV BY OTHER PUBLIC B INS IN MAY01";
label variable OPBJU01 "COV BY OTHER PUBLIC B INS IN JUN01";
label variable OPBJL01 "COV BY OTHER PUBLIC B INS IN JUL01";
label variable OPBAU01 "COV BY OTHER PUBLIC B INS IN AUG01";
label variable OPBSE01 "COV BY OTHER PUBLIC B INS IN SEP01";
label variable OPBOC01 "COV BY OTHER PUBLIC B INS IN OCT01";
label variable OPBNO01 "COV BY OTHER PUBLIC B INS IN NOV01";
label variable OPBDE01 "COV BY OTHER PUBLIC B INS IN DEC01";
label variable STAJA01 "COVERED BY OTHER STATE PROG IN JAN01";
label variable STAFE01 "COVERED BY OTHER STATE PROG IN FEB01";
label variable STAMA01 "COVERED BY OTHER STATE PROG IN MAR01";
label variable STAAP01 "COVERED BY OTHER STATE PROG IN APR01";
label variable STAMY01 "COVERED BY OTHER STATE PROG IN MAY01";
label variable STAJU01 "COVERED BY OTHER STATE PROG IN JUN01";
label variable STAJL01 "COVERED BY OTHER STATE PROG IN JUL01";
label variable STAAU01 "COVERED BY OTHER STATE PROG IN AUG01";
label variable STASE01 "COVERED BY OTHER STATE PROG IN SEP01";
label variable STAOC01 "COVERED BY OTHER STATE PROG IN OCT01";
label variable STANO01 "COVERED BY OTHER STATE PROG IN NOV01";
label variable STADE01 "COVERED BY OTHER STATE PROG IN DEC01";
label variable PUBJA01X "COVR BY ANY PUBLIC INS IN JAN01 (ED)";
label variable PUBFE01X "COVR BY ANY PUBLIC INS IN FEB01 (ED)";
label variable PUBMA01X "COVR BY ANY PUBLIC INS IN MAR01 (ED)";
label variable PUBAP01X "COVR BY ANY PUBLIC INS IN APR01 (ED)";
label variable PUBMY01X "COVR BY ANY PUBLIC INS IN MAY01 (ED)";
label variable PUBJU01X "COVR BY ANY PUBLIC INS IN JUN01 (ED)";
label variable PUBJL01X "COVR BY ANY PUBLIC INS IN JUL01 (ED)";
label variable PUBAU01X "COVR BY ANY PUBLIC INS IN AUG01 (ED)";
label variable PUBSE01X "COVR BY ANY PUBLIC INS IN SEP01 (ED)";
label variable PUBOC01X "COVR BY ANY PUBLIC INS IN OCT01 (ED)";
label variable PUBNO01X "COVR BY ANY PUBLIC INS IN NOV01 (ED)";
label variable PUBDE01X "COVR BY ANY PUBLIC INS IN DEC01 (ED)";
label variable PEGJA01 "COVERED BY EMPL UNION INS IN JAN01";
label variable PEGFE01 "COVERED BY EMPL UNION INS IN FEB01";
label variable PEGMA01 "COVERED BY EMPL UNION INS IN MAR01";
label variable PEGAP01 "COVERED BY EMPL UNION INS IN APR01";
label variable PEGMY01 "COVERED BY EMPL UNION INS IN MAY01";
label variable PEGJU01 "COVERED BY EMPL UNION INS IN JUN01";
label variable PEGJL01 "COVERED BY EMPL UNION INS IN JUL01";
label variable PEGAU01 "COVERED BY EMPL UNION INS IN AUG01";
label variable PEGSE01 "COVERED BY EMPL UNION INS IN SEP01";
label variable PEGOC01 "COVERED BY EMPL UNION INS IN OCT01";
label variable PEGNO01 "COVERED BY EMPL UNION INS IN NOV01";
label variable PEGDE01 "COVERED BY EMPL UNION INS IN DEC01";
label variable PDKJA01 "COVR BY PRIV INS (SOURCE UNKNWN) JAN01";
label variable PDKFE01 "COVR BY PRIV INS (SOURCE UNKNWN) FEB01";
label variable PDKMA01 "COVR BY PRIV INS (SOURCE UNKNWN) MAR01";
label variable PDKAP01 "COVR BY PRIV INS (SOURCE UNKNWN) APR01";
label variable PDKMY01 "COVR BY PRIV INS (SOURCE UNKNWN) MAY01";
label variable PDKJU01 "COVR BY PRIV INS (SOURCE UNKNWN) JUN01";
label variable PDKJL01 "COVR BY PRIV INS (SOURCE UNKNWN) JUL01";
label variable PDKAU01 "COVR BY PRIV INS (SOURCE UNKNWN) AUG01";
label variable PDKSE01 "COVR BY PRIV INS (SOURCE UNKNWN) SEP01";
label variable PDKOC01 "COVR BY PRIV INS (SOURCE UNKNWN) OCT01";
label variable PDKNO01 "COVR BY PRIV INS (SOURCE UNKNWN) NOV01";
label variable PDKDE01 "COVR BY PRIV INS (SOURCE UNKNWN) DEC01";
label variable PNGJA01 "COVERED BY NONGROUP INS IN JAN01";
label variable PNGFE01 "COVERED BY NONGROUP INS IN FEB01";
label variable PNGMA01 "COVERED BY NONGROUP INS IN MAR01";
label variable PNGAP01 "COVERED BY NONGROUP INS IN APR01";
label variable PNGMY01 "COVERED BY NONGROUP INS IN MAY01";
label variable PNGJU01 "COVERED BY NONGROUP INS IN JUN01";
label variable PNGJL01 "COVERED BY NONGROUP INS IN JUL01";
label variable PNGAU01 "COVERED BY NONGROUP INS IN AUG01";
label variable PNGSE01 "COVERED BY NONGROUP INS IN SEP01";
label variable PNGOC01 "COVERED BY NONGROUP INS IN OCT01";
label variable PNGNO01 "COVERED BY NONGROUP INS IN NOV01";
label variable PNGDE01 "COVERED BY NONGROUP INS IN DEC01";
label variable POGJA01 "COVERED BY OTHER GROUP INS IN JAN01";
label variable POGFE01 "COVERED BY OTHER GROUP INS IN FEB01";
label variable POGMA01 "COVERED BY OTHER GROUP INS IN MAR01";
label variable POGAP01 "COVERED BY OTHER GROUP INS IN APR01";
label variable POGMY01 "COVERED BY OTHER GROUP INS IN MAY01";
label variable POGJU01 "COVERED BY OTHER GROUP INS IN JUN01";
label variable POGJL01 "COVERED BY OTHER GROUP INS IN JUL01";
label variable POGAU01 "COVERED BY OTHER GROUP INS IN AUG01";
label variable POGSE01 "COVERED BY OTHER GROUP INS IN SEP01";
label variable POGOC01 "COVERED BY OTHER GROUP INS IN OCT01";
label variable POGNO01 "COVERED BY OTHER GROUP INS IN NOV01";
label variable POGDE01 "COVERED BY OTHER GROUP INS IN DEC01";
label variable PRSJA01 "COVERED BY SELF-EMP-1 INS IN JAN01";
label variable PRSFE01 "COVERED BY SELF-EMP-1 INS IN FEB01";
label variable PRSMA01 "COVERED BY SELF-EMP-1 INS IN MAR01";
label variable PRSAP01 "COVERED BY SELF-EMP-1 INS IN APR01";
label variable PRSMY01 "COVERED BY SELF-EMP-1 INS IN MAY01";
label variable PRSJU01 "COVERED BY SELF-EMP-1 INS IN JUN01";
label variable PRSJL01 "COVERED BY SELF-EMP-1 INS IN JUL01";
label variable PRSAU01 "COVERED BY SELF-EMP-1 INS IN AUG01";
label variable PRSSE01 "COVERED BY SELF-EMP-1 INS IN SEP01";
label variable PRSOC01 "COVERED BY SELF-EMP-1 INS IN OCT01";
label variable PRSNO01 "COVERED BY SELF-EMP-1 INS IN NOV01";
label variable PRSDE01 "COVERED BY SELF-EMP-1 INS IN DEC01";
label variable POUJA01 "COVERED BY HOLDER OUTSIDE OF RU IN JAN01";
label variable POUFE01 "COVERED BY HOLDER OUTSIDE OF RU IN FEB01";
label variable POUMA01 "COVERED BY HOLDER OUTSIDE OF RU IN MAR01";
label variable POUAP01 "COVERED BY HOLDER OUTSIDE OF RU IN APR01";
label variable POUMY01 "COVERED BY HOLDER OUTSIDE OF RU IN MAY01";
label variable POUJU01 "COVERED BY HOLDER OUTSIDE OF RU IN JUN01";
label variable POUJL01 "COVERED BY HOLDER OUTSIDE OF RU IN JUL01";
label variable POUAU01 "COVERED BY HOLDER OUTSIDE OF RU IN AUG01";
label variable POUSE01 "COVERED BY HOLDER OUTSIDE OF RU IN SEP01";
label variable POUOC01 "COVERED BY HOLDER OUTSIDE OF RU IN OCT01";
label variable POUNO01 "COVERED BY HOLDER OUTSIDE OF RU IN NOV01";
label variable POUDE01 "COVERED BY HOLDER OUTSIDE OF RU IN DEC01";
label variable PRIJA01 "COVERED BY PRIVATE INS IN JAN01";
label variable PRIFE01 "COVERED BY PRIVATE INS IN FEB01";
label variable PRIMA01 "COVERED BY PRIVATE INS IN MAR01";
label variable PRIAP01 "COVERED BY PRIVATE INS IN APR01";
label variable PRIMY01 "COVERED BY PRIVATE INS IN MAY01";
label variable PRIJU01 "COVERED BY PRIVATE INS IN JUN01";
label variable PRIJL01 "COVERED BY PRIVATE INS IN JUL01";
label variable PRIAU01 "COVERED BY PRIVATE INS IN AUG01";
label variable PRISE01 "COVERED BY PRIVATE INS IN SEP01";
label variable PRIOC01 "COVERED BY PRIVATE INS IN OCT01";
label variable PRINO01 "COVERED BY PRIVATE INS IN NOV01";
label variable PRIDE01 "COVERED BY PRIVATE INS IN DEC01";
label variable HPEJA01 "HOLDER OF EMPL UNION INS IN JAN01";
label variable HPEFE01 "HOLDER OF EMPL UNION INS IN FEB01";
label variable HPEMA01 "HOLDER OF EMPL UNION INS IN MAR01";
label variable HPEAP01 "HOLDER OF EMPL UNION INS IN APR01";
label variable HPEMY01 "HOLDER OF EMPL UNION INS IN MAY01";
label variable HPEJU01 "HOLDER OF EMPL UNION INS IN JUN01";
label variable HPEJL01 "HOLDER OF EMPL UNION INS IN JUL01";
label variable HPEAU01 "HOLDER OF EMPL UNION INS IN AUG01";
label variable HPESE01 "HOLDER OF EMPL UNION INS IN SEP01";
label variable HPEOC01 "HOLDER OF EMPL UNION INS IN OCT01";
label variable HPENO01 "HOLDER OF EMPL UNION INS IN NOV01";
label variable HPEDE01 "HOLDER OF EMPL UNION INS IN DEC01";
label variable HPDJA01 "HOLDER OF PRIV INS (SOURCE UNKNWN) JAN01";
label variable HPDFE01 "HOLDER OF PRIV INS (SOURCE UNKNWN) FEB01";
label variable HPDMA01 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAR01";
label variable HPDAP01 "HOLDER OF PRIV INS (SOURCE UNKNWN) APR01";
label variable HPDMY01 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAY01";
label variable HPDJU01 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUN01";
label variable HPDJL01 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUL01";
label variable HPDAU01 "HOLDER OF PRIV INS (SOURCE UNKNWN) AUG01";
label variable HPDSE01 "HOLDER OF PRIV INS (SOURCE UNKNWN) SEP01";
label variable HPDOC01 "HOLDER OF PRIV INS (SOURCE UNKNWN) OCT01";
label variable HPDNO01 "HOLDER OF PRIV INS (SOURCE UNKNWN) NOV01";
label variable HPDDE01 "HOLDER OF PRIV INS (SOURCE UNKNWN) DEC01";
label variable HPNJA01 "HOLDER OF NONGROUP INS IN JAN01";
label variable HPNFE01 "HOLDER OF NONGROUP INS IN FEB01";
label variable HPNMA01 "HOLDER OF NONGROUP INS IN MAR01";
label variable HPNAP01 "HOLDER OF NONGROUP INS IN APR01";
label variable HPNMY01 "HOLDER OF NONGROUP INS IN MAY01";
label variable HPNJU01 "HOLDER OF NONGROUP INS IN JUN01";
label variable HPNJL01 "HOLDER OF NONGROUP INS IN JUL01";
label variable HPNAU01 "HOLDER OF NONGROUP INS IN AUG01";
label variable HPNSE01 "HOLDER OF NONGROUP INS IN SEP01";
label variable HPNOC01 "HOLDER OF NONGROUP INS IN OCT01";
label variable HPNNO01 "HOLDER OF NONGROUP INS IN NOV01";
label variable HPNDE01 "HOLDER OF NONGROUP INS IN DEC01";
label variable HPOJA01 "HOLDER OF OTHER GROUP INS IN JAN01";
label variable HPOFE01 "HOLDER OF OTHER GROUP INS IN FEB01";
label variable HPOMA01 "HOLDER OF OTHER GROUP INS IN MAR01";
label variable HPOAP01 "HOLDER OF OTHER GROUP INS IN APR01";
label variable HPOMY01 "HOLDER OF OTHER GROUP INS IN MAY01";
label variable HPOJU01 "HOLDER OF OTHER GROUP INS IN JUN01";
label variable HPOJL01 "HOLDER OF OTHER GROUP INS IN JUL01";
label variable HPOAU01 "HOLDER OF OTHER GROUP INS IN AUG01";
label variable HPOSE01 "HOLDER OF OTHER GROUP INS IN SEP01";
label variable HPOOC01 "HOLDER OF OTHER GROUP INS IN OCT01";
label variable HPONO01 "HOLDER OF OTHER GROUP INS IN NOV01";
label variable HPODE01 "HOLDER OF OTHER GROUP INS IN DEC01";
label variable HPSJA01 "HOLDER OF SELF-EMP-1 INS IN JAN01";
label variable HPSFE01 "HOLDER OF SELF-EMP-1 INS IN FEB01";
label variable HPSMA01 "HOLDER OF SELF-EMP-1 INS IN MAR01";
label variable HPSAP01 "HOLDER OF SELF-EMP-1 INS IN APR01";
label variable HPSMY01 "HOLDER OF SELF-EMP-1 INS IN MAY01";
label variable HPSJU01 "HOLDER OF SELF-EMP-1 INS IN JUN01";
label variable HPSJL01 "HOLDER OF SELF-EMP-1 INS IN JUL01";
label variable HPSAU01 "HOLDER OF SELF-EMP-1 INS IN AUG01";
label variable HPSSE01 "HOLDER OF SELF-EMP-1 INS IN SEP01";
label variable HPSOC01 "HOLDER OF SELF-EMP-1 INS IN OCT01";
label variable HPSNO01 "HOLDER OF SELF-EMP-1 INS IN NOV01";
label variable HPSDE01 "HOLDER OF SELF-EMP-1 INS IN DEC01";
label variable HPRJA01 "HOLDER OF PRIVATE INSURANCE IN JAN01";
label variable HPRFE01 "HOLDER OF PRIVATE INSURANCE IN FEB01";
label variable HPRMA01 "HOLDER OF PRIVATE INSURANCE IN MAR01";
label variable HPRAP01 "HOLDER OF PRIVATE INSURANCE IN APR01";
label variable HPRMY01 "HOLDER OF PRIVATE INSURANCE IN MAY01";
label variable HPRJU01 "HOLDER OF PRIVATE INSURANCE IN JUN01";
label variable HPRJL01 "HOLDER OF PRIVATE INSURANCE IN JUL01";
label variable HPRAU01 "HOLDER OF PRIVATE INSURANCE IN AUG01";
label variable HPRSE01 "HOLDER OF PRIVATE INSURANCE IN SEP01";
label variable HPROC01 "HOLDER OF PRIVATE INSURANCE IN OCT01";
label variable HPRNO01 "HOLDER OF PRIVATE INSURANCE IN NOV01";
label variable HPRDE01 "HOLDER OF PRIVATE INSURANCE IN DEC01";
label variable INSJA01X "COVR BY HOSP/MED INS IN JAN01 (ED)";
label variable INSFE01X "COVR BY HOSP/MED INS IN FEB01 (ED)";
label variable INSMA01X "COVR BY HOSP/MED INS IN MAR01 (ED)";
label variable INSAP01X "COVR BY HOSP/MED INS IN APR01 (ED)";
label variable INSMY01X "COVR BY HOSP/MED INS IN MAY01 (ED)";
label variable INSJU01X "COVR BY HOSP/MED INS IN JUN01 (ED)";
label variable INSJL01X "COVR BY HOSP/MED INS IN JUL01 (ED)";
label variable INSAU01X "COVR BY HOSP/MED INS IN AUG01 (ED)";
label variable INSSE01X "COVR BY HOSP/MED INS IN SEP01 (ED)";
label variable INSOC01X "COVR BY HOSP/MED INS IN OCT01 (ED)";
label variable INSNO01X "COVR BY HOSP/MED INS IN NOV01 (ED)";
label variable INSDE01X "COVR BY HOSP/MED INS IN DEC01 (ED)";
label variable PRVEV01 "EVER HAVE PRIVATE INSURANCE DURING 01";
label variable TRIEV01 "EVER HAVE TIRCARE DURING 01";
label variable MCREV01 "EVER HAVE MEDICARE DURING 01";
label variable MCDEV01 "EVER HAVE MEDICAID OR SCHIP DURING 01";
label variable OPAEV01 "EVER HAVE OTHER PUBLIC A INS DURING 01";
label variable OPBEV01 "EVER HAVE OTHER PUBLIC B INS DURING 01";
label variable UNINS01 "UNINSURED ALL OF 01";
label variable INSCOV01 "HEALTH INSURANCE COVERAGE INDICATOR 01";
label variable MCDHMO31 "COVERED BY MEDICAID OR SCHIP HMO - R3/1";
label variable MCDHMO42 "COVERED BY MEDICAID OR SCHIP HMO - R4/2";
label variable MCDHMO01 "COVRED BY MEDICAID OR SCHIP HMO-12/31/01";
label variable MCDMC31 "COV BY MCAID/SCHIP GATEKEEPER PLAN-R3/1";
label variable MCDMC42 "COV BY MCAID/SCHIP GATEKEEPER PLAN-R4/2";
label variable MCDMC01 "COV BY MCAID/SCHIP GTKEEPR PLAN-12/31/01";
label variable PRVHMO31 "COVERED BY PRIVATE HMO - R3/1";
label variable PRVHMO42 "COVERED BY PRIVATE HMO - R4/2";
label variable PRVHMO01 "COVERED BY PRIVATE HMO - 12/31/01";
label variable PRVMNC31 "COVERED BY PRIVATE GATEKEEPER PLAN-R3/1";
label variable PRVMNC42 "COVERED BY PRIVATE GATEKEEPER PLAN-R4/2";
label variable PRVMNC01 "COVERED BY PRIV GATEKEEPER PLAN-12/31/01";
label variable PRVDRL31 "COV BY PRIV PLAN W/DOCTOR LIST - R3/1";
label variable PRVDRL42 "COV BY PRIV PLAN W/DOCTOR LIST - R4/2";
label variable PRVDRL01 "COV BY PRIV PLAN W/DOCTOR LIST-12/31/01";
label variable PHMONP31 "COV BY HMO-PAYS NON-PLAN DR VISITS-R3/1";
label variable PHMONP42 "COV BY HMO-PAYS NON-PLAN DR VISITS-R4/2";
label variable PHMONP01 "COV BY HMO-PAYS NON-PLAN DRS - 12/31/01";
label variable PMNCNP31 "COV BY GATEKPR-PAYS NON-PLAN DRS-R3/1";
label variable PMNCNP42 "COV BY GATEKPR-PAYS NON-PLAN DRS-R4/2";
label variable PMNCNP01 "COV BY GATEKP-PAYS NON-PLAN DRS-12/31/01";
label variable PRDRNP31 "COV BY DR LIST-PAYS NON-PLAN DRS-R3/1";
label variable PRDRNP42 "COV BY DR LIST-PAYS NON-PLAN DRS-R4/2";
label variable PRDRNP01 "COV BY DR LIST-PAYS NON-PLAN DR-12/31/01";
label variable PREVCOVR "PER COV BY INS IN PREV 2 YRS-PANL 6 ONLY";
label variable COVRMM "MONTH MOST RECENTLY COVERED-PANEL 6 ONLY";
label variable COVRYY "YEAR MOST RECENTLY COVERED-PANEL 6 ONLY";
label variable WASESTB "WAS PREV INS BY EMPL OR UNION-PNL 6 ONLY";
label variable WASMCARE "WAS PREV INS BY MEDICARE-PANEL 6 ONLY";
label variable WASMCAID "WAS PREV INS BY MCAID-PANEL 6 ONLY";
label variable WASCHAMP "WAS PREV INS CHAMPUS/CHAMPVA-PANL 6 ONLY";
label variable WASVA "WAS PREV INS VA/MILITAR CARE-PANL 6 ONLY";
label variable WASPRIV "WAS PREV INS GRP/ASSOC/INS CO-PNL 6 ONLY";
label variable WASOTGOV "WAS PREV INS BY OTH GOV PRG-PANEL 6 ONLY";
label variable WASAFDC "WAS PREV INS BY PUBLIC AFDC-PANEL 6 ONLY";
label variable WASSSI "WAS PREV INS BY SSI PROGRAM-PANEL 6 ONLY";
label variable WASSTAT1 "WAS PREV INS BY STAT PROG 1-PANEL 6 ONLY";
label variable WASSTAT2 "WAS PREV INS BY STAT PROG 2-PANEL 6 ONLY";
label variable WASOTHER "WAS PREV INS BY OTH SOURCE-PANEL 6 ONLY";
label variable NOINSBEF "EVR WOUT HLTH INSR PREV YR-PANEL 6 ONLY";
label variable NOINSTM "# WKS/MON WOUT HLTH INS PRV YR-PNL 6 ONL";
label variable NOINUNIT "UNIT OF TIME WOUT HLTH INS-PANEL 6 ONLY";
label variable MORECOVR "COV BY MOR COMPR PL PREV 2 YR-PNL 6 ONLY";
label variable INSENDMM "MONTH MOST RECENTLY COVD-PANEL 6 ONLY";
label variable INSENDYY "YEAR MOST RECENTLY COVD-PANEL 6 ONLY";
label variable DENYINSR "PERS EVER DENIED INSUR-PANEL 6 ONLY";
label variable DNYCANC "CANCER CAUSE INSR DENIAL-PANEL 6 ONLY";
label variable DNYHYPER "HYPERTNS CAUSE INSUR DENIAL-PANEL 6 ONLY";
label variable DNYDIAB "DIABETES CAUSE INSUR DENIAL-PANEL 6 ONLY";
label variable DNYCORON "CORNRY ART DIS CAUSE INSR DNL-PNL 6 ONLY";
label variable DENYOTH "OTH REASON CAUS INSR DENIAL-PANEL 6 ONLY";
label variable INSLOOK "PERS EVER LOOK FOR INSURNCE-PANEL 6 ONLY";
label variable INSLIMIT "ANY LIMIT/RESTRIC INSURANCE-PANEL 6 ONLY";
label variable LMTBACK "COND CAUSED LIMIT:BACK PROB-PANEL 6 ONLY";
label variable LIMITOT "COND CAUSED LIMIT: OTHER-PANEL 6 ONLY";
label variable TRICR31X "COV BY TRICARE - RD 3/1 INT (ED)";
label variable TRICR42X "COV BY TRICARE - RD 4/2 INT (ED)";
label variable TRICR53X "COV BY TRICARE - RD 5/3 INT (ED)";
label variable TRICR01X "COV BY TRICARE - 12/31/01 (ED)";
label variable TRIAT31X "ANY TIME COV TRICARE - R3/1";
label variable TRIAT42X "ANY TIME COV TRICARE - R4/2";
label variable TRIAT53X "ANY TIME COV TRICARE - R5/3";
label variable TRIAT01X "ANY TIME COV TRICARE - 12/31/01";
label variable MCAID31 "COV BY MCAID/SCHIP-RD 31 INT";
label variable MCAID42 "COV BY MCAID/SCHIP-RD 42 INT";
label variable MCAID53 "COV BY MCAID/SCHIP-RD 53 INT";
label variable MCAID01 "COV BY MCAID/SCHIP-12/31/01";
label variable MCAID31X "COV BY MCAID/SCHIP-RD 31 INT(ED)";
label variable MCAID42X "COV BY MCAID/SCHIP-RD 42 INT(ED)";
label variable MCAID53X "COV BY MCAID/SCHIP-RD 53 INT(ED)";
label variable MCAID01X "COV BY MCAID/SCHIP-12/31/01(ED)";
label variable MCARE31 "PID COV BY MEDICARE - RD 31 INT";
label variable MCARE42 "PID COV BY MEDICARE - RD 42 INT";
label variable MCARE53 "PID COV BY MEDICARE - RD 53 INT";
label variable MCARE01 "PID COV BY MEDICARE - 12/31/01";
label variable MCARE31X "PID COV BY MEDICARE - RD 31 INT(ED)";
label variable MCARE42X "PID COV BY MEDICARE - RD 42 INT(ED)";
label variable MCARE53X "PID COV BY MEDICARE - RD 53 INT(ED)";
label variable MCARE01X "PID COV BY MEDICARE - 12/31/01 (ED)";
label variable MCDAT31X "AT ANYTIME COVERAGE BY MCAID/SCHIP-RD 31";
label variable MCDAT42X "AT ANYTIME COVERAGE BY MCAID/SCHIP-RD 42";
label variable MCDAT53X "AT ANYTIME COVERAGE BY MCAID/SCHIP-RD 53";
label variable MCDAT01X "AT ANYTIME COVG BY MCAID/SCHIP-12/31/01";
label variable OTPAAT31 "ANY TIM COV BY/PAYS OTH GV MCD HMO-RD 31";
label variable OTPAAT42 "ANY TIM COV BY/PAYS OTH GV MCD HMO-RD 42";
label variable OTPAAT53 "ANY TIM COV BY/PAYS OTH GV MCD HMO-RD 53";
label variable OTPAAT01 "ANY TIM CV BY/PY OTH GV MCD HMO-12/31/01";
label variable OTPBAT31 "ANY TIM CV BY OTH GV NOT MCAID HMO-R31";
label variable OTPBAT42 "ANY TIM CV BY OTH GV NOT MCAID HMO-R42";
label variable OTPBAT53 "ANY TIM CV BY OTH GV NOT MCAID HMO-R53";
label variable OTPBAT01 "AN TM CV BY OT GV NOT MCAID HMO-12/31/01";
label variable OTPUBA31 "COV BY/PAYS OTH GOV MCAID HMO-RD 31 INT";
label variable OTPUBA42 "COV BY/PAYS OTH GOV MCAID HMO-RD 42 INT";
label variable OTPUBA53 "COV BY/PAYS OTH GOV MCAID HMO-RD 53 INT";
label variable OTPUBA01 "COV BY/PAYS OTH GOV MCAID HMO-12/31/01";
label variable OTPUBB31 "COV BY OTH GOV NOT MCAID HMO - RD 31 INT";
label variable OTPUBB42 "COV BY OTH GOV NOT MCAID HMO - RD 42 INT";
label variable OTPUBB53 "COV BY OTH GOV NOT MCAID HMO - RD 53 INT";
label variable OTPUBB01 "COV BY OTH GOV NOT MCAID HMO - 12/31/01";
label variable PRIDK31 "PID COV BY PRIV INS (DK PLAN)-RD 31 INT";
label variable PRIDK42 "PID COV BY PRIV INS (DK PLAN)-RD 42 INT";
label variable PRIDK53 "PID COV BY PRIV INS (DK PLAN)-RD 53 INT";
label variable PRIDK01 "PID COV BY PRIV INS (DK PLAN) - 12/31/01";
label variable PRIEU31 "PID COV BY EMPL/UNION GRP INS-RD 31 INT";
label variable PRIEU42 "PID COV BY EMPL/UNION GRP INS-RD 42 INT";
label variable PRIEU53 "PID COV BY EMPL/UNION GRP INS-RD 53 INT";
label variable PRIEU01 "PID COV BY EMPL/UNION GRP INS - 12/31/01";
label variable PRING31 "PID COV BY NON-GROUP INS - RD 31 INT";
label variable PRING42 "PID COV BY NON-GROUP INS - RD 42 INT";
label variable PRING53 "PID COV BY NON-GROUP INS - RD 53 INT";
label variable PRING01 "PID COV BY NON-GROUP INS - 12/31/01";
label variable PRIOG31 "PID COV BY OTHER GROUP INS -RD 31 INT";
label variable PRIOG42 "PID COV BY OTHER GROUP INS -RD 42 INT";
label variable PRIOG53 "PID COV BY OTHER GROUP INS -RD 53 INT";
label variable PRIOG01 "PID COV BY OTHER GROUP INS - 12/31/01";
label variable PRIS31 "PID COV BY SELF-EMP-1 INS - RD 31 INT";
label variable PRIS42 "PID COV BY SELF-EMP-1 INS - RD 42 INT";
label variable PRIS53 "PID COV BY SELF-EMP-1 INS - RD 53 INT";
label variable PRIS01 "PID COV BY SELF-EMP-1 INS - 12/31/01";
label variable PRIV31 "PID COV BY PRIV HLTH INS-RD 31 INT";
label variable PRIV42 "PID COV BY PRIV HLTH INS-RD 42 INT";
label variable PRIV53 "PID COV BY PRIV HLTH INS-RD 53 INT";
label variable PRIV01 "PID COV BY PRIV HLTH INS-12/31/01";
label variable PRIVAT31 "ANY TIME COV BY PRIVATE - RD 31";
label variable PRIVAT42 "ANY TIME COV BY PRIVATE - RD 42";
label variable PRIVAT53 "ANY TIME COV BY PRIVATE - RD 53";
label variable PRIVAT01 "ANY TIME COV BY PRIVATE - 12/31/01";
label variable PROUT31 "PID COV BY SOMEONE OUT OF RU-RD 31 INT";
label variable PROUT42 "PID COV BY SOMEONE OUT OF RU-RD 42 INT";
label variable PROUT53 "PID COV BY SOMEONE OUT OF RU-RD 53 INT";
label variable PROUT01 "PID COV BY SOMEONE OUT OF RU-12/31/01";
label variable PUB31X "PID COV BY PUBLIC INS-RD 31 INT(ED)";
label variable PUB42X "PID COV BY PUBLIC INS-RD 42 INT(ED)";
label variable PUB53X "PID COV BY PUBLIC INS-RD 53 INT(ED)";
label variable PUB01X "PID COV BY PUBLIC INS - 12/31/01 (ED)";
label variable PUBAT31X "AT ANY TIME COV BY PUBLIC - RD 31";
label variable PUBAT42X "AT ANY TIME COV BY PUBLIC - RD 42";
label variable PUBAT53X "AT ANY TIME COV BY PUBLIC - RD 53";
label variable PUBAT01X "AT ANY TIME COV BY PUBLIC - 12/31/01";
label variable INS31X "PID IS INSURED - RD 31 INT (ED)";
label variable INS42X "PID IS INSURED - RD 42 INT (ED)";
label variable INS53X "PID IS INSURED - RD 53 INT (ED)";
label variable INS01X "PID IS INSURED - 12/31/01 (ED)";
label variable INSAT31X "INSURED ANY TIME IN RD31";
label variable INSAT42X "INSURED ANY TIME IN RD42";
label variable INSAT53X "INSURED ANY TIME IN RD53";
label variable INSAT01X "INSURED ANY TIME 12/31/01/";
label variable STAPR31 "PID COV BY STATE-SPECIFIC PROG-RD 31 INT";
label variable STAPR42 "PID COV BY STATE-SPECIFIC PROG-RD 42 INT";
label variable STAPR53 "PID COV BY STATE-SPECIFIC PROG-RD 53 INT";
label variable STAPR01 "PID COV BY STATE-SPECIFIC PROG-12/31/01";
label variable STPRAT31 "AT ANY TIME COVERAGE BY STATE INS-RD 31";
label variable STPRAT42 "AT ANY TIME COVERAGE BY STATE INS-RD 42";
label variable STPRAT53 "AT ANY TIME COVERAGE BY STATE INS-RD 53";
label variable STPRAT01 "AT ANY TIME COV BY STATE INS - 12/31/01";
label variable DENTIN31 "DENTAL INSURANCE - RD 3/1";
label variable DENTIN42 "DENTAL INSURANCE - RD 4/2";
label variable DENTIN53 "DENTAL INSURANCE - RD 5/3";
label variable PMEDIN31 "PRESCRIPTION DRUG INSURANCE - RD 3/1";
label variable PMEDIN42 "PRESCRIPTION DRUG INSURANCE - RD 4/2";
label variable PMEDIN53 "PRESCRIPTION DRUG INSURANCE - RD 5/3";
label variable DDNWRK31 "# DAYS MISSED WORK DUE TO ILL/INJ (RD31)";
label variable DDNWRK42 "# DAYS MISSED WORK DUE TO ILL/INJ (RD42)";
label variable DDNWRK53 "# DAYS MISSED WORK DUE TO ILL/INJ (RD53)";
label variable WKINBD31 "# DAYS MISSED WORK STAYED IN BED (RD31)";
label variable WKINBD42 "# DAYS MISSED WORK STAYED IN BED (RD42)";
label variable WKINBD53 "# DAYS MISSED WORK STAYED IN BED (RD53)";
label variable DDNSCL31 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD31)";
label variable DDNSCL42 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD42)";
label variable DDNSCL53 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD53)";
label variable SCLNBD31 "# DAYS MISSED SCHOOL STAYD IN BED (RD31)";
label variable SCLNBD42 "# DAYS MISSED SCHOOL STAYD IN BED (RD42)";
label variable SCLNBD53 "# DAYS MISSED SCHOOL STAYD IN BED (RD53)";
label variable DDBDYS31 "# OTH DAY SPENT IN BED SINCE START(RD31)";
label variable DDBDYS42 "# OTH DAY SPENT IN BED SINCE START(RD42)";
label variable DDBDYS53 "# OTH DAY SPENT IN BED SINCE START(RD53)";
label variable OTHDYS31 "MISS ANY WRK/SCH DAY TO CAR FR OTH(RD31)";
label variable OTHDYS42 "MISS ANY WRK/SCH DAY TO CAR FR OTH(RD42)";
label variable OTHDYS53 "MISS ANY WRK/SCH DAY TO CAR FR OTH(RD53)";
label variable OTHNDD31 "# DAY MISSED WRK/SCH CARE FOR OTH(RD31)";
label variable OTHNDD42 "# DAY MISSED WRK/SCH CARE FOR OTH(RD42)";
label variable OTHNDD53 "# DAY MISSED WRK/SCH CARE FOR OTH(RD53)";
label variable ACCELI42 "PERS ELIGIBLE FOR ACCESS SUPPLEMENT";
label variable HAVEUS42 "AC01 DOES PERSON HAVE A USC PROVIDER?";
label variable YNOUSC42 "AC03 MAIN REASON PERS DOESN T HAVE A USC";
label variable NOREAS42 "AC04 OTH REAS NO USC: NO OTHER REASONS";
label variable SELDSI42 "AC04 OTH REAS NO USC: SELDOM OR NEV SICK";
label variable NEWARE42 "ACO4 OTH REAS NO USC: RECENTLY MOVED";
label variable DKWHRU42 "AC04 OTH REAS NO USC: DK WHERE TO GO";
label variable USCNOT42 "AC04 OTH REAS NO USC: USC NOT AVAILABLE";
label variable PERSLA42 "AC04 OTH REAS NO USC: LANGUAGE";
label variable DIFFPL42 "AC04 OTH REAS NO USC: DIFFERENT PLACES";
label variable INSRPL42 "AC04 OTH REAS NO USC: JUST CHANGED INSUR";
label variable MYSELF42 "AC04 OTH REAS NO USC: NO DOCS/TREAT SELF";
label variable CARECO42 "AC04 OTH REAS NO USC: COST OF MED CARE";
label variable OTHINS42 "AC04 OTH REAS NO USC: INS RELATED REASON";
label variable OTHREA42 "AC04 OTH REAS NO USC: OTHER REASON";
label variable TYPEPL42 "USC TYPE OF PLACE";
label variable PROVTY42 "PROVIDER TYPE";
label variable YGOTOU42 "AC08 MAIN REASON PERS GOES TO HOSP USC";
label variable NOREA942 "AC09 OTH REAS GO TO USC:NO OTHER REASONS";
label variable LIKESU42 "AC09 OTH REAS GO TO USC: PREFERS/LIKES";
label variable DKELSE42 "AC09 OTH REAS GO TO USC:DK WH ELSE TO GO";
label variable AFFORD42 "AC09 OTH REAS GO TO USC:CAN T AFFORD OTH";
label variable OFFICE42 "AC09 OTH REAS GO TO USC:DR OFFICE AT OPD";
label variable AVAILT42 "AC09 OTH REAS GO TO USC: AVAIL WHEN TIME";
label variable CONVEN42 "AC09 OTH REAS GO TO USC: CONVENIENCE";
label variable BSTPLA42 "AC09 OTH REAS GO TO USC: BEST FOR COND";
label variable INSREA42 "AC09 OTH REAS GO TO USC:INSURANCE-RELATD";
label variable OTHRE942 "AC09 OTH REAS GO TO USC: OTHER REASON";
label variable GETTOU42 "AC09A HOW DOES PERSN GET TO USC PROVIDER";
label variable TYPEPE42 "USC TYPE OF PROVIDER";
label variable LOCATI42 "USC LOCATION";
label variable MINORP42 "AC14 GOTO USC FOR NEW HEALTH PROBLEM";
label variable PREVEN42 "AC14 GOTO USC FOR PREVENTIVE HEALTH CARE";
label variable REFFRL42 "AC14 GOTO USC FOR REFERRALS";
label variable OFFHOU42 "AC15 USC HAS OFFICE HRS NIGHTS/WEEKENDS";
label variable APPTWL42 "AC16 WHEN SEE USC,HAVE APPT OR WALK IN";
label variable APPDIF42 "AC17 HOW DIFFICULT TO GET APPT WITH USC";
label variable WAITTI42 "AC18 WITH APPT, HOW LONG TIL SEEN BY USC";
label variable PHONED42 "AC19 HOW DIFFICULT CONTACT USC BY PHONE";
label variable PRLIST42 "AC19A DOES USC PROV LISTEN?";
label variable TREATM42 "AC19B PROV ASK ABOUT OTHER TREATMENTS";
label variable CONFID42 "AC19C CONFIDENT IN USC PROV S ABILITY?";
label variable PROVST42 "AC19D HOW SATISFIED WITH USC STAFF";
label variable USCQUA42 "AC19E SATISFIED WITH QUALITY OF CARE";
label variable CHNGUS42 "AC20 HAS ANYONE CHANGED USC IN LAST YEAR";
label variable YCHNGU42 "AC21 WHY DID PERSON(S) CHANGE USC";
label variable ANYUSC42 "AC22 HAS ANYONE HAD A USC IN LAST YEAR";
label variable YNOMOR42 "AC23 WHY DON T THEY HAVE A USC ANYMORE?";
label variable NOCARE42 "AC24 DID ANYONE GO W/OUT HEALTH CARE?";
label variable HCNEED42 "AC24A SATISFIED FAMILY CAN GET CARE";
label variable OBTAIN42 "AC25 ANYONE HAVE DIFFICLTY OBTAIN CARE";
label variable MAINPR42 "AC25A MAIN REASON EXPERIENCED DIFFICULTY";
label variable NOOTHP42 "AC26 DIFFICULTY: NO OTHER PROBLEMS";
label variable NOAFFO42 "AC26 DIFFICULTY: COULDN T AFFORD CARE";
label variable INSNOP42 "AC26 DIFFICULTY: INS COMPANY WON T PAY";
label variable PREEXC42 "AC26 DIFFICULTY: PRE-EXISTING CONDITION";
label variable INSRQR42 "AC26 DIFFICULTY: INS REQUIRED REFERRAL";
label variable REFUSI42 "AC26 DIFFICULTY: DR REFUSED INS PLAN";
label variable DISTAN42 "AC26 DIFFICULTY: DISTANCE";
label variable PUBTRA42 "AC26 DIFFICULTY: PUBLIC TRANSPORTATION";
label variable EXPENS42 "AC26 DIFFICULTY: TOO EXPENS TO GET THERE";
label variable HEARPR42 "AC26 DIFFICULTY: HEARING IMPAIR/LOSS";
label variable LANGBA42 "AC26 DIFFICULTY: LANGUAGE BARRIER";
label variable INTOBL42 "AC26 DIFFICULTY: HARD TO GET INTO BLDG";
label variable INSIDE42 "AC26 DIFFICULTY: HARD TO GET AROUND";
label variable EQUIPM42 "AC26 DIFFICULTY: NO APPROPRIATE EQUIP";
label variable OFFWOR42 "AC26 DIFFICULTY: COULDN T GET TIME OFF";
label variable DKWHER42 "AC26 DIFFICULTY: DK WHERE TO GO";
label variable REFUSE42 "AC26 DIFFICULTY: WAS REFUSED SERVICES";
label variable CHLDCA42 "AC26 DIFFICULTY: COULDN T GET CHILD CARE";
label variable NOTIME42 "AC26 DIFFICULTY: NO TIME/TOOK TOO LONG";
label variable OTHRPR42 "AC26 DIFFICULTY: OTHER";
label variable RTHLTH31 "PERCEIVED HEALTH STATUS - RD 3/1";
label variable RTHLTH42 "PERCEIVED HEALTH STATUS - RD 4/2";
label variable RTHLTH53 "PERCEIVED HEALTH STATUS - RD 5/3";
label variable RTPROX31 "SELF/PROXY RATING OF HEALTH - RD 3/1";
label variable RTPROX42 "SELF/PROXY RATING OF HEALTH - RD 4/2";
label variable RTPROX53 "SELF/PROXY RATING OF HEALTH - RD 5/3";
label variable MNHLTH31 "PERCEIVED MENTAL HEALTH STATUS - RD 3/1";
label variable MNHLTH42 "PERCEIVED MENTAL HEALTH STATUS - RD 4/2";
label variable MNHLTH53 "PERCEIVED MENTAL HEALTH STATUS - RD 5/3";
label variable MNPROX31 "SELF/PROXY RATING OF MENTAL HEALTH-R3/1";
label variable MNPROX42 "SELF/PROXY RATING OF MENTAL HEALTH-R4/2";
label variable MNPROX53 "SELF/PROXY RATING OF MENTAL HEALTH-R5/3";
label variable IADLHP31 "IADL SCREENER - RD 3/1";
label variable IADLHP42 "IADL SCREENER - RD 4/2";
label variable IADLHP53 "IADL SCREENER - RD 5/3";
label variable ADLHLP31 "ADL SCREENER - RD 3/1";
label variable ADLHLP42 "ADL SCREENER - RD 4/2";
label variable ADLHLP53 "ADL SCREENER - RD 5/3";
label variable AIDHLP31 "USED ASSISTIVE DEVICES - RD 3/1";
label variable AIDHLP53 "USED ASSISTIVE DEVICES - RD 5/3";
label variable WLKLIM31 "LIMITATION IN PHYSICAL FUNCTIONING-RD3/1";
label variable WLKLIM53 "LIMITATION IN PHYSICAL FUNCTIONING-RD5/3";
label variable LFTDIF31 "DIFFICULTY LIFTING 10 POUNDS - RD 3/1";
label variable LFTDIF53 "DIFFICULTY LIFTING 10 POUNDS - RD 5/3";
label variable STPDIF31 "DIFFICULTY WALKING UP 10 STEPS - RD 3/1";
label variable STPDIF53 "DIFFICULTY WALKING UP 10 STEPS - RD 5/3";
label variable WLKDIF31 "DIFFICULTY WALKING 3 BLOCKS - RD 3/1";
label variable WLKDIF53 "DIFFICULTY WALKING 3 BLOCKS - RD 5/3";
label variable MILDIF31 "DIFFICULTY WALKING A MILE - RD 3/1";
label variable MILDIF53 "DIFFICULTY WALKING A MILE - RD 5/3";
label variable STNDIF31 "DIFFICULTY STANDING 20 MINUTES - RD 3/1";
label variable STNDIF53 "DIFFICULTY STANDING 20 MINUTES - RD 5/3";
label variable BENDIF31 "DIFFICULTY BENDING/STOOPING - RD 3/1";
label variable BENDIF53 "DIFFICULTY BENDING/STOOPING - RD 5/3";
label variable RCHDIF31 "DIFFICULTY REACHING OVERHEAD - RD 3/1";
label variable RCHDIF53 "DIFFICULTY REACHING OVERHEAD - RD 5/3";
label variable FNGRDF31 "DIFFICULTY USING FINGERS TO GRASP-RD 3/1";
label variable FNGRDF53 "DIFFICULTY USING FINGERS TO GRASP-RD 5/3";
label variable ACTLIM31 "ANY LIMITATION WORK/HOUSEWRK/SCHL-RD 3/1";
label variable ACTLIM53 "ANY LIMITATION WORK/HOUSEWRK/SCHL-RD 5/3";
label variable WRKLIM31 "WORK LIMITATION - RD 3/1";
label variable WRKLIM53 "WORK LIMITATION - RD 5/3";
label variable HSELIM31 "HOUSEWORK LIMITATION - RD 3/1";
label variable HSELIM53 "HOUSEWORK LIMITATION - RD 5/3";
label variable SCHLIM31 "SCHOOL LIMITATION - RD 3/1";
label variable SCHLIM53 "SCHOOL LIMITATION - RD 5/3";
label variable UNABLE31 "COMPLETELY UNABLE TO DO ACTIVITY-RD 3/1";
label variable UNABLE53 "COMPLETELY UNABLE TO DO ACTIVITY-RD 5/3";
label variable SOCLIM31 "SOCIAL LIMITATIONS - RD 3/1";
label variable SOCLIM53 "SOCIAL LIMITATIONS - RD 5/3";
label variable COGLIM31 "COGNITIVE LIMITATIONS - RD 3/1";
label variable COGLIM53 "COGNITIVE LIMITATIONS - RD 5/3";
label variable WRGLAS42 "WEARS EYEGLASSES OR CONTACTS - RD 4/2";
label variable SEEDIF42 "DIFFCLTY SEEING W/GLASSES/CNTCTS-RD 4/2";
label variable BLIND42 "PERSON IS BLIND - RD 4/2";
label variable READNW42 "CAN READ NEWSPRNT W/GLASSES/CNTCTS-RD4/2";
label variable RECPEP42 "CAN RECGNZE PEOPLE W/GLASSES/CNTCTS-R4/2";
label variable VISION42 "VISION IMPAIRMENT (SUMMARY) - RD 4/2";
label variable HEARAD42 "PERSON WEARS HEARING AID - RD 4/2";
label variable HEARDI42 "ANY DIFFCLTY HEARING W/HEARING AID-RD4/2";
label variable DEAF42 "PERSON IS DEAF - RD 4/2";
label variable HEARMO42 "CAN HEAR MOST CONVERSATION - RD 4/2";
label variable HEARSM42 "CAN HEAR SOME CONVERSATION - RD 4/2";
label variable HEARNG42 "HEARING IMPAIRMENT (SUMMARY) - RD 4/2";
label variable ANYLIM01 "ANY LIMITATION IN P5R3,4,5/P6R1,2,3";
label variable LSHLTH42 "LESS HEALTHY THAN OTHR CHILD (0-17)-R4/2";
label variable NEVILL42 "NEVER BEEN SERIOUSLY ILL (0-17)-R4/2";
label variable SICEAS42 "CHILD GETS SICK EASILY (0-17)-R4/2";
label variable HLTHLF42 "CHILD WILL HAVE HEALTHY LIFE (0-17)-R4/2";
label variable WRHLTH42 "WORRY MORE ABOUT HEALTH (0-17)-R4/2";
label variable CHPMED42 "CSHCN:CHILD NEEDS PRESCRB MED(0-17)-R4/2";
label variable CHPMHB42 "CSHCN:PMED FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHPMCN42 "CSHCN:PMED COND LAST 12+ MOS (0-17)-R4/2";
label variable CHSERV42 "CSHCN:CHLD NEEDS MED&OTH SERV(0-17)-R4/2";
label variable CHSRHB42 "CSHCN:SERV FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHSRCN42 "CSHCN:SERV COND LAST 12+ MOS (0-17)-R4/2";
label variable CHLIMI42 "CSHCN:LIMITED IN ANY WAY (0-17)-R4/2";
label variable CHLIHB42 "CSHCN:LIMT FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHLICO42 "CSHCN:LIMIT COND LAST 12+MOS (0-17)-R4/2";
label variable CHTHER42 "CSHCN:CHLD NEEDS SPEC THERAPY(0-17)-R4/2";
label variable CHTHHB42 "CSHCN:SPEC THER FOR HLTH+COND(0-17)-R4/2";
label variable CHTHCO42 "CSHCN:THER COND LAST 12+ MOS (0-17)-R4/2";
label variable CHCOUN42 "CSHCN:CHILD NEEDS COUNSELING (0-17)-R4/2";
label variable CHEMPB42 "CSHCN:COUNS PROB LAST 12+MOS (0-17)-R4/2";
label variable CSHCN42 "CSHCN:CHLD WITH SPECIAL HLTH CARE NEEDS";
label variable MOMPRO42 "PROBLEM GETTING ALONG W/MOM (5-17)-R4/2";
label variable DADPRO42 "PROBLEM GETTING ALONG W/DAD (5-17)-R4/2";
label variable UNHAP42 "PROBLEM FEELING UNHAPPY/SAD (5-17)-R4/2";
label variable SCHLBH42 "PROBLEM BEHAVIOR AT SCHOOL (5-17)-R4/2";
label variable HAVFUN42 "PROBLEM HAVING FUN (5-17) - R4/2";
label variable ADUPRO42 "PRBLM GETTING ALONG W/ADULTS (5-17)-R4/2";
label variable NERVAF42 "PRBLM FEELING NERVOUS/AFRAID (5-17)-R4/2";
label variable SIBPRO42 "PRBLM GETTING ALONG W/SIBS (5-17)-R4/2";
label variable KIDPRO42 "PRBLM GETTING ALONG W/KIDS (5-17)-R4/2";
label variable SPRPRO42 "PROBLEM W/SPORTS/HOBBIES (5-17)-R4/2";
label variable SCHPRO42 "PROBLEM WITH SCHOOLWORK (5-17)-R4/2";
label variable HOMEBH42 "PROBLEM W/BEHAVIOR AT HOME (5-17)-R4/2";
label variable TRBLE42 "PRBLM STAY OUT OF TROUBLE (5-17)-R4/2";
label variable CHRTCR42 "CAHPS:12MOS:MAKE ROUT CARE APT(0-17)R4/2";
label variable CHRTWW42 "CAHPS:12MOS:ROUT APT WHN WNTD(0-17)-R4/2";
label variable CHILCR42 "CAHPS:12MOS:ILL/INJ NEED CARE(0-17)-R4/2";
label variable CHILWW42 "CAHPS:12MOS:ILL CARE WHN WNTD(0-17)-R4/2";
label variable CHAPPT42 "CAHPS:12MOS:# OF OFF/CLIN APTS(0-17)R4/2";
label variable CHNECR42 "CAHPS:12MOS:PROB GET NEC CARE(0-17)R4/2";
label variable CHLIST42 "CAHPS:12MOS:CHLD DR LSN TO YOU(0-17)R4/2";
label variable CHEXPL42 "CAHPS:12MOS:CHLD DR EXPL THNG(0-17)R4/2";
label variable CHRESP42 "CAHPS:12MOS:CHLD S DR SHW RESP(0-17)R4/2";
label variable CHPRTM42 "CAHPS:12MOS:CHILD DR ENGH TIME(0-17)R4/2";
label variable CHHECR42 "CAHPS:12MOS:RATE CHLD HLT CARE(0-17)R4/2";
label variable CHSPEC42 "CAHPS:12MOS:CHLD NEEDED SPEC(0-17)R4/2";
label variable CHPRRE42 "CAHPS:12MOS:PRB W/RFR TO SPEC(0-17)R4/2";
label variable MESHGT42 "DOCTOR EVER MEASURED HEIGHT (0-17)-R4/2";
label variable WHNHGT42 "WHEN DOCTOR MEASURED HEIGHT (0-17)-R4/2";
label variable MESWGT42 "DOCTOR EVER MEASURED WEIGHT (0-17)-R4/2";
label variable WHNWGT42 "WHEN DOCTOR MEASURED WEIGHT (0-17)-R4/2";
label variable CHBMIX42 "CHILD S BODY MASS INDEX (3-17) - R4/2";
label variable MESVIS42 "DOCTOR CHECKED CHILD S VISION (3-6)-R4/2";
label variable MESBPR42 "DR CHECKED BLOOD PRESSURE (2-17)-R4/2";
label variable WHNBPR42 "WHEN DR CHECKED BLOOD PRESS (2-17)-R4/2";
label variable DENTAL42 "DR ADVISE REG DENTAL CHECKUP (2-17)-R4/2";
label variable WHNDEN42 "WHEN DR ADVISE DENT CHECKUP (2-17)-R4/2";
label variable EATHLT42 "DR ADVISE EAT HEALTHY (2-17)-R4/2";
label variable WHNEAT42 "WHEN DR ADVISE EAT HEALTHY (2-17)-R4/2";
label variable PHYSCL42 "DR ADVISE EXERCISE (2-17)-R4/2";
label variable WHNPHY42 "WHEN DR ADVISE EXERCISE (2-17)-R4/2";
label variable SAFEST42 "DR ADVISE CHLD SAFETY SEAT (WT<=40)-R4/2";
label variable WHNSAF42 "WHEN DR ADVISE SAFETY SEAT (WT<=40)-R4/2";
label variable BOOST42 "DR ADVISE BOOSTER SEAT (40<WT<=80)-R4/2";
label variable WHNBST42 "WHN DR ADVISE BOOST SEAT(40<WT<=80)-R4/2";
label variable LAPBLT42 "DR ADVISE LAP/SHOULDER BELT (80<WT)-R4/2";
label variable WHNLAP42 "WHN DR ADVISE LAP/SHLDR BLT (80<WT)-R4/2";
label variable HELMET42 "DR ADVISE BIKE HELMET (2-17)-R4/2";
label variable WHNHEL42 "WHEN DR ADVISE BIKE HELMET (2-17)-R4/2";
label variable NOSMOK42 "DR ADVISE SMKG IN HOME IS BAD(0-17)-R4/2";
label variable WHNSMK42 "WHN DR ADVIS SMKG IN HOME BAD(0-17)-R4/2";
label variable TIMALN42 "DOCTOR SPEND ANY TIME ALONE (12-17)-R4/2";
label variable DENTCK53 "HOW OFTEN DENTAL CHECK-UP - RD 5/3";
label variable CHOLCK53 "HOW LNG CHOLEST LST CHCK (>17) - RD 5/3";
label variable CHECK53 "HOW LNG LST ROUTNE CHECKUP (>17)-RD 5/3";
label variable FLUSHT53 "HOW LNG LAST FLU SHT (>17) - RD 5/3";
label variable LSTETH53 "LOST ALL UPPR AND LOWR TEETH (>17)-RD5/3";
label variable PSA53 "HOW LONG SINCE LAST PSA (>39) - RD 5/3";
label variable HYSTER53 "HAD A HYSTERECTOMY (>17) - RD 5/3";
label variable PAPSMR53 "HOW LNG LST PAP SMEAR TST (>17) - RD 5/3";
label variable BRSTEX53 "HOW LNG SNCE LST BREAST EXAM (>17)-RD5/3";
label variable MAMOGR53 "HOW LNG SNCE LST MAMMOGRAM (>29) - RD5/3";
label variable STOOL53 "BLD STOOL TST KIT/CRDS HOME (>17)-RD5/3";
label variable WHENST53 "WHN LST BLD STOOL TST HME KIT (>17)-R5/3";
label variable BOWEL53 "SIGMOIDOSCOPY/COLONOSCOPY (>17) - RD 5/3";
label variable WHNBWL53 "LST SIGMOIDOSCOP/COLONOSCOP (>17)-RD 5/3";
label variable PHYACT53 "MOD/VIG PHYS ACTIV 3X WK (>17) - RD 5/3";
label variable BMINDX53 "ADULT BODY MASS INDEX (> 17) - RD 5/3";
label variable SEATBE53 "WEARS SEAT BELT (>15) - RD 5/3";
label variable SRTHRT53 "12MO: SERIOUS SORE THROAT(0-17)-RD 5/3";
label variable THSYMP53 "12MO:SORE THRT/OTH SYMPTMS(0-17)-RD 5/3";
label variable DRTHRT53 "12MO: SEE DR FOR SORE THRT(0-17)-RD 5/3";
label variable THANTB53 "12MO: DR PRES ANTBTC SRE THRT(0-17)RD5/3";
label variable THSWAB53 "12MO: DR GAVE THROAT SWAB(0-17)-RD 5/3";
label variable THSYMF53 "12MO:FAM SAME SRE THRT SYMP (0-17)RD5/3";
label variable THSWBF53 "12MO:DR GAVE FAM THRT SWAB(0-17)-RD5/3";
label variable THANTF53 "12MO:DR PRES FAM ATBTC SR THT(0-17)RD5/3";
label variable DIABDX53 "DIABETES DIAGNOSIS - RD 5/3";
label variable ASTHDX53 "ASTHMA DIAGNOSIS - RD 5/3";
label variable ASATAK53 "ASTHMA ATTACK LAST 12 MOS - RD 5/3";
label variable ASMED53 "TAKE MEDS FOR ASTHMA - RD 5/3";
label variable ASSTER53 "TAKE INHALED STEROIDS ASTHMA - RD 5/3";
label variable ASFLOW53 "HAVE PEAK FLOW METER AT HOME - RD 5/3";
label variable HIBPDX53 "HIGH BLOOD PRESSURE DIAG (>17) - RD 5/3";
label variable BPMLDX53 "MULT DIAG HIGH BLOOD PRESS (>17) - RD5/3";
label variable BPCHEK53 "TIME SNCE LST BLOOD PRES CHK (>17)-RD5/3";
label variable BPMONT53 "# MOS SNCE LST BLOOD PRES CHK (>17)-R5/3";
label variable CHDDX53 "CORONARY HRT DISEASE DIAG (>17) - RD 5/3";
label variable ANGIDX53 "ANGINA DIAGNOSIS (>17) - RD 5/3";
label variable MIDX53 "HEART ATTACK (MI) DIAG (>17) - RD 5/3";
label variable OHRTDX53 "OTHER HEART DISEASE DIAG (>17) - RD 5/3";
label variable STRKDX53 "STROKE DIAGNOSIS (>17) - RD 5/3";
label variable EMPHDX53 "EMPHYSEMA DIAGNOSIS (>17) - RD 5/3";
label variable NOFAT53 "RESTRICT HGH FAT/CHOLES FOOD (>17)-RD5/3";
label variable EXRCIS53 "ADVISED TO EXERCISE MORE (>17) - RD 5/3";
label variable ASPRIN53 "TKE ASPIRN EVERY (OTHR) DAY (>17)-RD 5/3";
label variable NOASPR53 "TAKING ASPIRIN UNSAFE (>17) - RD 5/3";
label variable STOMCH53 "TKE ASPRN UNSAFE B/C STOMCH (>17)-RD 5/3";
label variable JTPAIN53 "JOINT PAIN LAST 12 MONTHS (>17) - RD 5/3";
label variable ARTHDX53 "ARTHRITIS DIAGNOSIS (>17) - RD 5/3";
label variable ARTHTX53 "ARTHRITIS TREATMNT CURRENTLY (>17)RD5/3";
label variable SVERLANG "LANGUAGE OF ADMINISTRATION FOR SAQ";
label variable ADPRX42 "SAQ: RELATIONSHIP OF PROXY TO ADULT";
label variable ADRTCR42 "SAQ 12 MOS: MADE APPT ROUTINE MED CARE";
label variable ADRTWW42 "SAQ 12 MOS: GOT MED APPT WHEN WANTED";
label variable ADILCR42 "SAQ 12MOS: ILL/INJURY NEEDING IMMED CARE";
label variable ADILWW42 "SAQ 12 MOS: GOT CARE WHEN NEEDED ILL/INJ";
label variable ADAPPT42 "SAQ 12 MOS: # VISITS TO MED OFF FOR CARE";
label variable ADNECR42 "SAQ 12MOS: PROBS GETTING NEEDED MED CARE";
label variable ADLIST42 "SAQ 12 MOS: DOCTOR LISTENED TO YOU";
label variable ADEXPL42 "SAQ 12 MOS: DOC EXPLAINED SO UNDERSTOOD";
label variable ADRESP42 "SAQ 12 MOS: DR SHOWED RESPECT";
label variable ADPRTM42 "SAQ 12 MOS: DR SPENT ENUF TIME WITH YOU";
label variable ADHECR42 "SAQ 12 MOS: RATING OF HEALTH CARE";
label variable ADSMOK42 "SAQ: CURRENTLY SMOKE";
label variable ADDSMK42 "SAQ 12 MOS: DR ADVISED QUIT SMOKING";
label variable ADDRBP42 "SAQ 2 YRS: DR CHECKED BLOOD PRESSURE";
label variable ADSPEC42 "SAQ 12 MOS: NEEDED TO SEE SPECIALIST";
label variable ADPRRE42 "SAQ 12MOS: PROBLEM GETTING SPEC REFERRAL";
label variable ADGENH42 "SAQ: HEALTH IN GENERAL SF-12";
label variable ADDAYA42 "SAQ: HLTH LIMITS MOD ACTIVITIES SF-12";
label variable ADCLIM42 "SAQ: HLTH LIMITS CLIMBING STAIRS SF-12";
label variable ADPACC42 "SAQ 4 WKS: DID LESS B/C PHYS PROBS SF-12";
label variable ADPLMT42 "SAQ 4 WKS: LIMIT WK B/C PHYS PROBS SF-12";
label variable PCS42 "SAQ:PHYSICAL COMPNT SUMMARY SF12 IMPUTED";
label variable ADMACC42 "SAQ 4 WKS: DID LESS B/C MENT PROBS SF-12";
label variable ADMLMT42 "SAQ 4 WKS: LIM WK B/C MENT PROBS SF-12";
label variable MCS42 "SAQ:MENTAL COMPONET SUMMRY SF12 IMPUTED";
label variable SFFLAG42 "SAQ:PCS/MCS IMPUTATION FLAG SF-12";
label variable ADPAIN42 "SAQ 4 WKS: PAIN LIMITS NORMAL WORK SF-12";
label variable ADCALM42 "SAQ 4 WKS: FELT CALM/PEACEFUL SF-12";
label variable ADPEP42 "SAQ 4 WKS: HAD A LOT OF ENERGY SF-12";
label variable ADBLUE42 "SAQ 4 WKS: FELT DOWNHEARTED/BLUE SF-12";
label variable ADSOCA42 "SAQ 4 WKS: HLTH STOPPED SOC ACTIV SF-12";
label variable ADMOBI42 "SAQ HEALTH TODAY: MOBILITY EQ-5D";
label variable ADSELF42 "SAQ HEALTH TODAY: SELF-CARE EQ-5D";
label variable ADACTI42 "SAQ HEALTH TODAY: USUAL ACTIVITY EQ-5D";
label variable ADPAYN42 "SAQ HEALTH TODAY: PAIN/DISCOMFORT EQ-5D";
label variable ADDEPR42 "SAQ HLTH TODAY: ANXIETY/DEPRESSION EQ-5D";
label variable ADSCAL42 "SAQ SCALE: HEALTH STATE TODAY EQ-5D";
label variable EQU42 "SAQ: EQ-5D PREFERENCE BASED INDEX";
label variable ADINSA42 "SAQ: DO NOT NEED HEALTH INSURANCE";
label variable ADINSB42 "SAQ: HEALTH INSURANCE NOT WORTH COST";
label variable ADRISK42 "SAQ: MORE LIKELY TO TAKE RISKS";
label variable ADOVER42 "SAQ: CAN OVERCOME ILLS WITHOUT MED HELP";
label variable DSDIA53 "DCS: DIABETES DIAGNOSIS BY HEALTH PROF";
label variable DSA1C53 "DCS: TIMES TESTED FOR A-ONE-C - 2001";
label variable DSCKFT53 "DCS: TIMES FEET CHECKED FOR SORES - 2001";
label variable DSEYE53 "DCS: LAST EYE EXAM WITH PUPILS DILATED";
label variable DSKIDN53 "DCS: HAS DIABETES CAUSED KIDNEY PROBLEMS";
label variable DSEYPR53 "DCS: HAS DIABETES CAUSED EYE PROBS";
label variable DSDIET53 "DCS: TREAT DIABETES W/DIET MODIFICATION";
label variable DSMED53 "DCS: TREAT DIABETES W/MEDS BY MOUTH";
label variable DSINSU53 "DCS: TREAT DIABETES W/INSULIN INJECTIONS";
label variable DSPRX53 "DCS: WAS RESPONDENT A PROXY";
label variable TOTTCH01 "TOTAL HEALTH CARE CHARGES 01, EXCL RX";
label variable TOTEXP01 "TOTAL HEALTH CARE EXP 01";
label variable TOTSLF01 "TOTAL AMT PAID BY SELF/FAMILY 01";
label variable TOTMCR01 "TOTAL AMT PAID BY MEDICARE 01";
label variable TOTMCD01 "TOTAL AMT PAID BY MEDICAID 01";
label variable TOTPRV01 "TOTAL AMT PAID BY PRIVATE INS 01";
label variable TOTVA01 "TOTAL AMT PAID BY VA 01";
label variable TOTTRI01 "TOTAL AMT PAID BY TRICARE 01";
label variable TOTOFD01 "TOTAL AMT PAID BY OTHER FEDERAL 01";
label variable TOTSTL01 "TOTAL AMT PAID BY OTH ST/LOCAL 01";
label variable TOTWCP01 "TOTAL AMT PAID BY WORKERS COMP 01";
label variable TOTOPR01 "TOTAL AMT PAID BY OTHER PRIVATE 01";
label variable TOTOPU01 "TOTAL AMT PAID BY OTHER PUBLIC 01";
label variable TOTOSR01 "TOTAL AMT PAID BY OTHER SOURCES 01";
label variable OBTOTV01 "# OFFICE-BASED PROVIDER VISITS 01";
label variable OBVTCH01 "OFFICE-BASED PROVIDER VISIT CHARGES 01";
label variable OBVEXP01 "TOTAL OFFICE-BASED EXP 01";
label variable OBVSLF01 "ALL OFFICE VISITS -SELF/FAMILY AMT 01";
label variable OBVMCR01 "ALL OFFICE VISITS -MEDICARE AMT 01";
label variable OBVMCD01 "ALL OFFICE VISITS -MEDICAID AMT 01";
label variable OBVPRV01 "ALL OFFICE VISITS -PRIVATE INS AMT 01";
label variable OBVVA01 "ALL OFFICE VISITS-VA AMT 01";
label variable OBVTRI01 "ALL OFFICE VISITS-TRICARE AMT 01";
label variable OBVOFD01 "ALL OFFICE VISITS-OTHER FEDERAL AMT 01";
label variable OBVSTL01 "ALL OFFICE VISITS-OTH ST/LOCAL AMT 01";
label variable OBVWCP01 "ALL OFFICE VISITS -WORKERS COMP AMT 01";
label variable OBVOPR01 "ALL OFFICE VISITS - OTH PRIVATE AMT 01";
label variable OBVOPU01 "ALL OFFICE VISITS - OTH PUBLIC AMT 01";
label variable OBVOSR01 "ALL OFF VSTS - OTH UNCLASS SRCE AMT 01";
label variable OBDRV01 "# OFFICE-BASED PHYSICIAN VISITS 01";
label variable OBDTCH01 "OFFICE-BASED PHYSICIAN VISIT CHARGES 01";
label variable OBDEXP01 "TOTAL OFF-BASED DR EXP 01";
label variable OBDSLF01 "DR OFFICE VISITS -SELF/FAMILY AMT 01";
label variable OBDMCR01 "DR OFFICE VISITS -MEDICARE AMT 01";
label variable OBDMCD01 "DR OFFICE VISITS -MEDICAID AMT 01";
label variable OBDPRV01 "DR OFFICE VISITS -PRIVATE INS AMT 01";
label variable OBDVA01 "DR OFFICE VISITS -VA AMT 01";
label variable OBDTRI01 "DR OFFICE VISITS -TRICARE AMT 01";
label variable OBDOFD01 "DR OFFICE VISITS -OTHER FEDERAL AMT 01";
label variable OBDSTL01 "DR OFFICE VISITS -OTH ST/LOCAL AMT 01";
label variable OBDWCP01 "DR OFFICE VISITS -WORKERS COMP AMT 01";
label variable OBDOPR01 "DR OFFICE VISITS - OTH PRIVATE AMT 01";
label variable OBDOPU01 "DR OFFICE VISITS - OTH PUBLIC AMT 01";
label variable OBDOSR01 "DR OFF VSTS - OTH UNCLASS SRCE AMT 01";
label variable OBOTHV01 "# OFFICE-BASED NON-PHYSICAN VISITS 01";
label variable OBOTCH01 "OFFICE-BASED NON-DR VISIT CHARGES 01";
label variable OBOEXP01 "TOTAL OFF-BASED NON-DR EXP 01";
label variable OBOSLF01 "NON-DR OFF VISTS -SELF/FAMILY AMT 01";
label variable OBOMCR01 "NON-DR OFF VISTS -MEDICARE AMT 01";
label variable OBOMCD01 "NON-DR OFF VISTS -MEDICAID AMT 01";
label variable OBOPRV01 "NON-DR OFF VISTS -PRIVATE INS AMT 01";
label variable OBOVA01 "NON-DR OFF VISTS -VA AMT 01";
label variable OBOTRI01 "NON-DR OFF VISTS -TRICARE AMT 01";
label variable OBOOFD01 "NON-DR OFF VISTS -OTHER FEDERAL AMT 01";
label variable OBOSTL01 "NON-DR OFF VISTS -OTH ST/LOCAL AMT 01";
label variable OBOWCP01 "NON-DR OFF VISTS -WORKERS COMP AMT 01";
label variable OBOOPR01 "NON-DR OFF VISTS - OTH PRIVATE AMT 01";
label variable OBOOPU01 "NON-DR OFF VISTS - OTH PUBLIC AMT 01";
label variable OBOOSR01 "NON-DR OF VSTS - OTH UNCLASS SRCE AMT 01";
label variable OBCHIR01 "# OFFICE-BASED CHIROPRACTOR VISITS 01";
label variable OBCTCH01 "OFFICE-BASED CHIRO VISIT CHARGES 01";
label variable OBCEXP01 "TOTAL OFF-BASED CHIRO EXP 01";
label variable OBCSLF01 "CHIRO OFF VISITS -SELF/FAMILY AMT 01";
label variable OBCMCR01 "CHIRO OFF VISITS -MEDICARE AMT 01";
label variable OBCMCD01 "CHIRO OFF VISITS -MEDICAID AMT 01";
label variable OBCPRV01 "CHIRO OFF VISITS -PRIVATE INS AMT 01";
label variable OBCVA01 "CHIRO OFF VISITS -VA AMT 01";
label variable OBCTRI01 "CHIRO OFF VISITS -TRICARE AMT 01";
label variable OBCOFD01 "CHIRO OFF VISITS -OTHER FEDERAL AMT 01";
label variable OBCSTL01 "CHIRO OFF VISITS -OTH ST/LOCAL AMT 01";
label variable OBCWCP01 "CHIRO OFF VISITS -WORKERS COMP AMT 01";
label variable OBCOPR01 "CHIRO OFF VISTS - OTHR PRIVATE AMT 01";
label variable OBCOPU01 "CHIRO OFF VISTS - OTHR PUBLIC AMT 01";
label variable OBCOSR01 "CHIRO OF VSTS - OTHR UNCLASS SRCE AMT 01";
label variable OBNURS01 "# OFF-BASED NURSE/PRACTITIONER VISITS 01";
label variable OBNTCH01 "OFFICE-BASED NURSE/PRAC VISIT CHARGES 01";
label variable OBNEXP01 "TOTAL OFF-BASED NURSE/PRAC 01";
label variable OBNSLF01 "NURSE/PRAC OFF VISITS-SELF/FAMILY AMT 01";
label variable OBNMCR01 "NURSE/PRAC OFF VISITS -MEDICARE AMT 01";
label variable OBNMCD01 "NURSE/PRAC OFF VSTS -MEDICAID AMT 01";
label variable OBNPRV01 "NURSE/PRAC OFF VSTS -PRIVATE INS AMT 01";
label variable OBNVA01 "NURSE/PRAC OFF VSTS -VA AMT 01";
label variable OBNTRI01 "NURSE/PRAC OFF VSTS -TRICARE AMT 01";
label variable OBNOFD01 "NURSE/PRAC OFF VSTS-OTHER FEDERAL AMT 01";
label variable OBNSTL01 "NURSE/PRAC OFF VSTS -OTH ST/LOCAL AMT 01";
label variable OBNWCP01 "NURSE/PRAC OFF VSTS -WORKERS COMP AMT 01";
label variable OBNOPR01 "NURSE/PRAC OFF VSTS - OTH PRIVATE AMT 01";
label variable OBNOPU01 "NURSE/PRAC OFF VSTS - OTH PUBLIC AMT 01";
label variable OBNOSR01 "NRS/PR OF VSTS - OTH UNCLASS SRCE AMT 01";
label variable OBOPTO01 "# OFF-BASED OPTOMETRIST VISITS 01";
label variable OBETCH01 "OFFICE-BASED OPTOMTRIST VISIT CHARGES 01";
label variable OBEEXP01 "TOTAL OFF-BASED OPOTMETRIST EXP 01";
label variable OBESLF01 "OPTOMETRIST OFF VSTS -SELF/FAMILY AMT 01";
label variable OBEMCR01 "OPTOMETRIST OFF VSTS -MEDICARE AMT 01";
label variable OBEMCD01 "OPTOMETRIST OFF VSTS -MEDICAID AMT 01";
label variable OBEPRV01 "OPTOMETRIST OFF VSTS -PRIVATE INS AMT 01";
label variable OBEVA01 "OPTOMETRIST OFF VSTS -VA AMT 01";
label variable OBETRI01 "OPTOMETRIST OFF VSTS -TRICARE AMT 01";
label variable OBEOFD01 "OPTOMETRIST OFF VSTS-OTH FEDERAL AMT 01";
label variable OBESTL01 "OPTOMETRIST OFF VSTS -OTH ST/LOCL AMT 01";
label variable OBEWCP01 "OPTOMETRIST OFF VSTS-WORKERS COMP AMT 01";
label variable OBEOPR01 "OPTOMETRIST OFF VSTS -OTH PRIVATE AMT 01";
label variable OBEOPU01 "OPTOMETRIST OFF VSTS -OTH PUBLIC AMT 01";
label variable OBEOSR01 "OPTOM OF VSTS - OTH UNCLASS SRCE AMT 01";
label variable OBASST01 "# OFF-BASED PHYSICIAN ASSIST VISITS 01";
label variable OBATCH01 "OFFICE-BASED PHYS ASST VISIT CHARGES 01";
label variable OBAEXP01 "TOTAL OFF-BASED PHYS ASS T EXP 01";
label variable OBASLF01 "PHYS ASS T OFF VSTS -SELF/FAMILY AMT 01";
label variable OBAMCR01 "PHYS ASS T OFF VSTS -MEDICARE AMT 01";
label variable OBAMCD01 "PHYS ASS T OFF VSTS -MEDICAID AMT 01";
label variable OBAPRV01 "PHYS ASS T OFF VSTS -PRIVATE INS AMT 01";
label variable OBAVA01 "PHYS ASS T OFF VSTS -VA AMT 01";
label variable OBATRI01 "PHYS ASS T OFF VSTS -TRICARE AMT 01";
label variable OBAOFD01 "PHYS ASS T OFF VSTS -OTHER FED AMT 01";
label variable OBASTL01 "PHYS ASS T OFF VSTS -OTH ST/LOCL AMT 01";
label variable OBAWCP01 "PHYS ASS T OFF VSTS-WORKERS COMP AMT 01";
label variable OBAOPR01 "PHYS ASS T OFF VSTS - OTH PRIVATE AMT 01";
label variable OBAOPU01 "PHYS ASS T OFF VSTS - OTH PUBLIC AMT 01";
label variable OBAOSR01 "P A OFF VSTS - OTH UNCLASS SRCE AMT 01";
label variable OBTHER01 "# OFF-BASED PT/OT VISITS 01";
label variable OBTTCH01 "OFFICE-BASED PT/OC VISIT CHARGES 01";
label variable OBTEXP01 "TOT OFF-BASED PT EXP 01";
label variable OBTSLF01 "PT/OT OFF VISITS -SELF/FAMILY AMT 01";
label variable OBTMCR01 "PT/OT OFF VISITS -MEDICARE AMT 01";
label variable OBTMCD01 "PT/OT OFF VISITS -MEDICAID AMT 01";
label variable OBTPRV01 "PT/OT OFF VISITS -PRIVATE INS AMT 01";
label variable OBTVA01 "PT/OT OFF VISITS -VA AMT 01";
label variable OBTTRI01 "PT/OT OFF VISITS -TRICARE AMT 01";
label variable OBTOFD01 "PT/OT OFF VISITS -OTHER FED AMT 01";
label variable OBTSTL01 "PT/OT OFF VISITS -OTH ST/LOCL AMT 01";
label variable OBTWCP01 "PT/OT OFF VISITS -WORKERS COMP AMT 01";
label variable OBTOPR01 "PT/OT OFF VISITS - OTH PRIVATE AMT 01";
label variable OBTOPU01 "PT/OT OFF VISITS - OTH PUBLIC AMT 01";
label variable OBTOSR01 "PT/OT OF VSTS-OTH UNCLASS SRCE AMT 01";
label variable OPTOTV01 "# OUTPATIENT DEPT PROVIDER VISITS 01";
label variable OPFTCH01 "OPD PROVIDER VISIT CHARGES - FAC 01";
label variable OPFEXP01 "TOTAL OUTPATIENT FACILITY EXP 01";
label variable OPFSLF01 "ALL OPD VISITS-SELF/FAMILY AMT-FAC 01";
label variable OPFMCR01 "ALL OPD VISITS-MEDICARE AMT-FAC 01";
label variable OPFMCD01 "ALL OPD VISITS-MEDICAID AMT-FAC 01";
label variable OPFPRV01 "ALL OPD VISITS-PRIV INS AMT-FAC 01";
label variable OPFVA01 "ALL OPD VISITS-VA AMT-FAC 01";
label variable OPFTRI01 "ALL OPD VISITS-TRICARE AMT-FAC 01";
label variable OPFOFD01 "ALL OPD VISITS-OTHER FED AMT-FAC 01";
label variable OPFSTL01 "ALL OPD VISITS-OTH ST/LOCAL AMT-FAC 01";
label variable OPFWCP01 "ALL OPD VISITS-WORKERS COMP AMT-FAC 01";
label variable OPFOPR01 "ALL OPD VISITS - OTH PRIVATE AMT-FAC 01";
label variable OPFOPU01 "ALL OPD VISITS - OTH PUBLIC AMT-FAC 01";
label variable OPFOSR01 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-FAC 01";
label variable OPDEXP01 "TOTAL OUTPATIENT PROVIDER EXP 01";
label variable OPDTCH01 "OPD PROVIDER VISIT CHARGES - DR 01";
label variable OPDSLF01 "ALL OPD VISITS-SELF/FAMILY AMT-DR 01";
label variable OPDMCR01 "ALL OPD VISITS-MEDICARE AMT -DR 01";
label variable OPDMCD01 "ALL OPD VISITS-MEDICAID AMT -DR 01";
label variable OPDPRV01 "ALL OPD VISITS-PRIV INS AMT-DR 01";
label variable OPDVA01 "ALL OPD VISITS-VA AMT-DR 01";
label variable OPDTRI01 "ALL OPD VISITS-TRICARE AMT-DR 01";
label variable OPDOFD01 "ALL OPD VISITS-OTHER FED AMT-DR 01";
label variable OPDSTL01 "ALL OPD VISITS-OTH ST/LOCAL AMT-DR 01";
label variable OPDWCP01 "ALL OPD VISITS-WORKERS COMP AMT-DR 01";
label variable OPDOPR01 "ALL OPD VISITS - OTH PRIVATE AMT-DR 01";
label variable OPDOPU01 "ALL OPD VISITS-OTH PUBLIC AMT-DR 01";
label variable OPDOSR01 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-DR 01";
label variable OPDRV01 "# OUTPATIENT DEPT PHYSICIAN VISITS 01";
label variable OPVTCH01 "OPD PHYSICIAN VISIT CHARGES - FAC 01";
label variable OPVEXP01 "TOTAL OUTPATIENT PHYSICIAN - FAC EXP 01";
label variable OPVSLF01 "OPD DR VISITS-SELF/FAMILY AMT-FAC 01";
label variable OPVMCR01 "OPD DR VISITS-MEDICARE AMT-FAC 01";
label variable OPVMCD01 "OPD DR VISITS-MEDICAID AMT-FAC 01";
label variable OPVPRV01 "OPD DR VISITS-PRIV INS AMT-FAC 01";
label variable OPVVA01 "OPD DR VISITS-VA AMT-FAC 01";
label variable OPVTRI01 "OPD DR VISITS-TRICARE AMT-FAC 01";
label variable OPVOFD01 "OPD DR VISITS-OTHER FED AMT-FAC 01";
label variable OPVSTL01 "OPD DR VISITS-OTH ST/LOCAL AMT-FAC 01";
label variable OPVWCP01 "OPD DR VISITS-WORKERS COMP AMT-FAC 01";
label variable OPVOPR01 "OPD DR VISITS - OTH PRIVATE AMT-FAC 01";
label variable OPVOPU01 "OPD DR VISITS-OTH PUBLIC AMT-FAC 01";
label variable OPVOSR01 "OPD DR VSTS-OTH UNCLASS SRCE AMT-FAC 01";
label variable OPSEXP01 "TOTAL OUTPATIENT PHYSICIAN - DR EXP 01";
label variable OPSTCH01 "OPD PHYSICIAN VISIT CHARGES - DR 01";
label variable OPSSLF01 "OPD DR VISITS-SELF/FAMILY AMT-DR 01";
label variable OPSMCR01 "OPD DR VISITS-MEDICARE AMT-DR 01";
label variable OPSMCD01 "OPD DR VISITS-MEDICAID AMT-DR 01";
label variable OPSPRV01 "OPD DR VISITS-PRIV INS AMT-DR 01";
label variable OPSVA01 "OPD DR VISITS-VA AMT-DR 01";
label variable OPSTRI01 "OPD DR VISITS-TRICARE AMT-DR 01";
label variable OPSOFD01 "OPD DR VISITS-OTHER FED AMT-DR 01";
label variable OPSSTL01 "OPD DR VISITS-OTH ST/LOCAL AMT-DR 01";
label variable OPSWCP01 "OPD DR VISITS-WORKERS COMP AMT-DR 01";
label variable OPSOPR01 "OPD DR VISITS - OTH PRIVATE AMT-DR 01";
label variable OPSOPU01 "OPD DR VISITS-OTH PUBLIC AMT-DR 01";
label variable OPSOSR01 "OPD DR VSTS-OTH UNCLASS SRCE AMT-DR 01";
label variable OPOTHV01 "# OUTPATIENT DEPT NON-DR VISITS 01";
label variable OPOTCH01 "OPD NON-PHYS VISIT CHARGES - FAC 01";
label variable OPOEXP01 "TOTAL OUTPATIENT NON-DR - FAC EXP 01";
label variable OPOSLF01 "OPD NON-DR VISITS-SELF/FAM AMT-FAC 01";
label variable OPOMCR01 "OPD NON-DR VISITS-MEDICARE AMT-FAC 01";
label variable OPOMCD01 "OPD NON-DR VISITS-MEDICAID AMT-FAC 01";
label variable OPOPRV01 "OPD NON-DR VISITS-PRIV INS AMT-FAC 01";
label variable OPOVA01 "OPD NON-DR VISITS-VA AMT-FAC 01";
label variable OPOTRI01 "OPD NON-DR VISITS-TRICARE AMT-FAC 01";
label variable OPOOFD01 "OPD NON-DR VISITS-OTHER FED AMT-FAC 01";
label variable OPOSTL01 "OPD NON-DR VISITS-OTH ST/LOC AMT-FAC 01";
label variable OPOWCP01 "OPD NON-DR VISITS-WRKRS COMP AMT-FAC 01";
label variable OPOOPR01 "OPD NON-DR VISITS-OTH PRIVATE AMT-FAC 01";
label variable OPOOPU01 "OPD NON-DR VISITS-OTH PUBLIC AMT-FAC 01";
label variable OPOOSR01 "OPD NON-DR VSTS-OT UNCLAS SRC AMT-FAC 01";
label variable OPPEXP01 "TOTAL OUTPATIENT NON-DR - DR EXP 01";
label variable OPPTCH01 "OPD NON-PHYS VISIT CHARGES - DR 01";
label variable OPPSLF01 "OPD NON-DR VISITS-SELF/FAM AMT-DR 01";
label variable OPPMCR01 "OPD NON-DR VISITS-MEDICARE AMT-DR 01";
label variable OPPMCD01 "OPD NON-DR VISITS-MEDICAID AMT-DR 01";
label variable OPPPRV01 "OPD NON-DR VISITS-PRIV INS AMT-DR 01";
label variable OPPVA01 "OPD NON-DR VISITS-VA AMT-DR 01";
label variable OPPTRI01 "OPD NON-DR VISITS-TRICARE AMT-DR 01";
label variable OPPOFD01 "OPD NON-DR VISITS-OTHER FED AMT-DR 01";
label variable OPPSTL01 "OPD NON-DR VISITS-OTH ST/LOC AMT-DR 01";
label variable OPPWCP01 "OPD NON-DR VISITS-WRKRS COMP AMT-DR 01";
label variable OPPOPR01 "OPD NON-DR VISITS-OTH PRIVATE AMT-DR 01";
label variable OPPOPU01 "OPD NON-DR VISITS-OTH PUBLIC AMT-DR 01";
label variable OPPOSR01 "OPD NON-DR VSTS-OT UNCLAS SRC AMT-DR 01";
label variable AMCHIR01 "# CHIROPRACTR VSTS (OFF+OUTPAT), 2001";
label variable AMCTCH01 "CHIRO AMBULATORY VISIT CHARGES 01";
label variable AMCEXP01 "TOTL AMBULTRY (OB+OP) CHIRO EXP 01";
label variable AMCSLF01 "CHIRO AMB VISITS -SELF/FAMILY AMT 01";
label variable AMCMCR01 "CHIRO AMB VISITS -MEDICARE AMT 01";
label variable AMCMCD01 "CHIRO AMB VISITS -MEDICAID AMT 01";
label variable AMCPRV01 "CHIRO AMB VISITS -PRIVATE INS AMT 01";
label variable AMCVA01 "CHIRO AMB VISITS -VA AMT 01";
label variable AMCTRI01 "CHIRO AMB VISITS-TRICARE AMT 01";
label variable AMCOFD01 "CHIRO AMB VISITS -OTHER FEDERAL AMT 01";
label variable AMCSTL01 "CHIRO AMB VISITS -OTH ST/LOCAL AMT 01";
label variable AMCWCP01 "CHIRO AMB VISITS-WORKERS COMP AMT 01";
label variable AMCOPR01 "CHIRO AMB VISITS - OTH PRIVATE AMT 01";
label variable AMCOPU01 "CHIRO AMB VISITS - OTH PUBLIC AMT 01";
label variable AMCOSR01 "CHIR AMB VSTS - OTH UNCLASS SRCE AMT 01";
label variable AMNURS01 "# AMB NURSE/PRCTITIONR VSTS(OB+OP) 01";
label variable AMNTCH01 "NRS/PRAC AMBULATORY VISIT CHARGES 01";
label variable AMNEXP01 "TOTL AMBULTRY (OB+OP) NURSE/PRAC EXP 01";
label variable AMNSLF01 "NRS/PRAC AMB VSTS -SELF/FAMILY AMT 01";
label variable AMNMCR01 "NRS/PRAC AMB VSTS -MEDICARE AMT 01";
label variable AMNMCD01 "NRS/PRAC AMB VSTS -MEDICAID AMT 01";
label variable AMNPRV01 "NRS/PRAC AMB VSTS -PRIV INS AMT 01";
label variable AMNVA01 "NRS/PRAC AMB VSTS-VA AMT 01";
label variable AMNTRI01 "NRS/PRAC AMB VSTS-TRICARE AMT 01";
label variable AMNOFD01 "NRS/PRAC AMB VSTS-OTHER FEDERAL AMT 01";
label variable AMNSTL01 "NRS/PRAC AMB VSTS-OTH ST/LOCAL AMT 01";
label variable AMNWCP01 "NRS/PRAC AMB VSTS-WORKERS COMP AMT 01";
label variable AMNOPR01 "NRS/PRAC AMB VSTS - OTH PRIVATE AMT 01";
label variable AMNOPU01 "NRS/PRAC AMB VSTS - OTH PUBLIC AMT 01";
label variable AMNOSR01 "NRS/PR AMB VSTS - OTH UNCLAS SRCE AMT 01";
label variable AMOPTO01 "# AMB OPTOMETRIST VSTS (OB+OP) 01";
label variable AMETCH01 "OPTOMETRIST AMBULATORY VISIT CHARGES 01";
label variable AMEEXP01 "TOTL AMBULTRY (OB+OP) OPTOMETRIST EXP 01";
label variable AMESLF01 "OPTMTRIST AMB VSTS -SELF/FAMILY AMT 01";
label variable AMEMCR01 "OPTMTRIST AMB VSTS -MEDICARE AMT 01";
label variable AMEMCD01 "OPTMTRIST AMB VSTS -MEDICAID AMT 01";
label variable AMEPRV01 "OPTMTRIST AMB VSTS -PRIVATE INS AMT 01";
label variable AMEVA01 "OPTMTRIST AMB VSTS-VA AMT 01";
label variable AMETRI01 "OPTMTRIST AMB VSTS-TRICARE AMT 01";
label variable AMEOFD01 "OPTMTRIST AMB VSTS-OTHER FED AMT 01";
label variable AMESTL01 "OPTMTRIST AMB VSTS-OTH ST/LOCAL AMT 01";
label variable AMEWCP01 "OPTMTRIST AMB VSTS-WORKERS COMP AMT 01";
label variable AMEOPR01 "OPTMTRIST AMB VSTS - OTH PRIVATE AMT 01";
label variable AMEOPU01 "OPTMTRIST AMB VSTS - OTH PUBLIC AMT 01";
label variable AMEOSR01 "OPTOM AMB VSTS - OTH UNCLAS SRCE AMT 01";
label variable AMASST01 "# PHYSICIAN ASS T VSTS (OFF+OUPAT), 2001";
label variable AMATCH01 "PHYS ASS T AMBULATORY VISIT CHARGES 01";
label variable AMAEXP01 "TOTL AMBULTRY (OB+OP) PHYS ASS T EXP 01";
label variable AMASLF01 "PHYS ASS T AMB VSTS-SELF/FAMILY AMT 01";
label variable AMAMCR01 "PHYS ASS T AMB VSTS-MEDICARE AMT 01";
label variable AMAMCD01 "PHYS ASS T AMB VSTS-MEDICAID AMT 01";
label variable AMAPRV01 "PHYS ASS T AMB VSTS-PRIVATE INS AMT 01";
label variable AMAVA01 "PHYS ASS T AMB VSTS-VA AMT 01";
label variable AMATRI01 "PHYS ASS T AMB VSTS-TRICARE AMT 01";
label variable AMAOFD01 "PHYS ASS T AMB VSTS -OTHER FED AMT 01";
label variable AMASTL01 "PHYS ASS T AMB VSTS-OTH ST/LOCL AMT 01";
label variable AMAWCP01 "PHYS ASS T AMB VSTS-WRKERS COMP AMT 01";
label variable AMAOPR01 "PHYS ASS T AMB VSTS - OTH PRIVATE AMT 01";
label variable AMAOPU01 "PHYS ASS T AMB VSTS - OTH PUBLIC AMT 01";
label variable AMAOSR01 "P A AMB VSTS- OTH UNCLASS SRCE AMT 01";
label variable AMTHER01 "# AMB PT/OT THRPY VISITS (OB+OP) 01";
label variable AMTTCH01 "PT/OC AMBULATORY VISIT CHARGES 01";
label variable AMTEXP01 "TOTL AMBULTRY (OB+OP) PT/OT EXP 01";
label variable AMTSLF01 "PT/OT AMB VISITS-SELF/FAMILY AMT 01";
label variable AMTMCR01 "PT/OT AMB VISITS-MEDICARE AMT 01";
label variable AMTMCD01 "PT/OT AMB VISITS-MEDICAID AMT 01";
label variable AMTPRV01 "PT/OT AMB VISITS-PRIVATE INS AMT 01";
label variable AMTVA01 "PT/OT AMB VISITS-VA AMT 01";
label variable AMTTRI01 "PT/OT AMB VISITS-TRICARE AMT 01";
label variable AMTOFD01 "PT/OT AMB VISITS -OTHER FED AMT 01";
label variable AMTSTL01 "PT/OT AMB VISITS-OTH ST/LOCL AMT 01";
label variable AMTWCP01 "PT/OT AMB VISITS-WORKERS COMP AMT 01";
label variable AMTOPR01 "PT/OT AMB VISITS - OTH PRIVATE AMT 01";
label variable AMTOPU01 "PT/OT AMB VISITS-OTH PUBLIC AMT 01";
label variable AMTOSR01 "PT/OT AMB VSTS-OTH UNCLAS SRCE AMT 01";
label variable AMTOTC01 "# CALLS W/OFFICE & OUPAT DEPTS, 2001";
label variable AMDRC01 "# CALLS W/OFF & OUTPAT PHYSICIANS, 2001";
label variable ERTOT01 "# EMERGENCY ROOM VISITS 01";
label variable ERFTCH01 "ER FACILITY VISIT CHARGES 01";
label variable ERFEXP01 "TOTAL ER FACILITY EXP 01";
label variable ERFSLF01 "ER-SELF/FAMILY AMT - FAC 01";
label variable ERFMCR01 "ER-MEDICARE AMT - FAC 01";
label variable ERFMCD01 "ER-MEDICAID AMT - FAC 01";
label variable ERFPRV01 "ER-PRIVATE INS AMT - FAC 01";
label variable ERFVA01 "ER-VA AMT - FAC 01";
label variable ERFTRI01 "ER-TRICARE AMT - FAC 01";
label variable ERFOFD01 "ER-OTHER FEDERAL AMT - FAC 01";
label variable ERFSTL01 "ER-OTH ST/LOCAL AMT - FAC 01";
label variable ERFWCP01 "ER-WORKERS COMP AMT - FAC 01";
label variable ERFOPR01 "ER-OTHER PRIVATE AMT - FAC 01";
label variable ERFOPU01 "ER-OTHER PUBLIC AMT - FAC 01";
label variable ERFOSR01 "ER-OTH UNCLASS SRCE AMT - FAC 01";
label variable ERDEXP01 "TOTAL EMERGENCY ROOM DR EXP 01";
label variable ERDTCH01 "ER DOCTOR VISIT CHARGES 01";
label variable ERDSLF01 "ER-SELF/FAMILY AMT - DR 01";
label variable ERDMCR01 "ER-MEDICARE AMT - DR 01";
label variable ERDMCD01 "ER-MEDICAID AMT - DR 01";
label variable ERDPRV01 "ER-PRIVATE INS AMT - DR 01";
label variable ERDVA01 "ER-VA AMT - DR 01";
label variable ERDTRI01 "ER-TRICARE AMT - DR 01";
label variable ERDOFD01 "ER-OTHER FED AMT - DR 01";
label variable ERDSTL01 "ER-OTH ST/LOCAL AMT - DR 01";
label variable ERDWCP01 "ER-WORKERS COMP AMT - DR 01";
label variable ERDOPR01 "ER - OTHER PRIVATE AMT - DR 01";
label variable ERDOPU01 "ER - OTHER PUBLIC AMT - DR 01";
label variable ERDOSR01 "ER-OTH UNCLASS SRCE AMT - DR 01";
label variable IPZERO01 "# ZERO-NIGHT HOSPITAL STAYS 01";
label variable ZIFTCH01 "ZERO-NITE IP STAY CHARGES - FAC 01";
label variable ZIFEXP01 "TOTAL ZERO-NITE STAYS FAC EXP 01";
label variable ZIFSLF01 "ZERO-NITE IP STAZ -SELF/FAM AMT-FAC 01";
label variable ZIFMCR01 "ZERO-NITE IP STAZ-MEDICARE AMT-FAC 01";
label variable ZIFMCD01 "ZERO-NITE IP STAZ-MEDICAID AMT-FAC 01";
label variable ZIFPRV01 "ZERO-NITE IP STAZ-PRIV INS AMT-FAC 01";
label variable ZIFVA01 "ZERO-NITE IP STAZ-VA AMT-FAC 01";
label variable ZIFTRI01 "ZERO-NITE IP STAZ-TRICARE AMT-FAC 01";
label variable ZIFOFD01 "ZERO-NITE IP STAZ-OTHER FED AMT-FAC 01";
label variable ZIFSTL01 "ZERO-NITE IP STAZ-OTH ST/LOC AMT-FAC 01";
label variable ZIFWCP01 "ZERO-NITE IP STAZ-WRKERS COMP AMT-FAC 01";
label variable ZIFOPR01 "ZERO-NITE IP STAZ-OTH PRIVATE AMT-FAC 01";
label variable ZIFOPU01 "ZERO-NITE IP STAZ-OTH PUBLIC AMT-FAC 01";
label variable ZIFOSR01 "ZERO-NITE IP STAZ-UNCLAS SRCE AMT-FAC 01";
label variable ZIDEXP01 "TOTAL ZERO-NITE STAZ DR 01";
label variable ZIDTCH01 "ZERO-NITE IP STAY CHARGES - DR 01";
label variable ZIDSLF01 "ZERO-NITE IP STAZ-SELF/FAM AMT-DR 01";
label variable ZIDMCR01 "ZERO-NITE IP STAZ-MEDICARE AMT-DR 01";
label variable ZIDMCD01 "ZERO-NITE IP STAZ-MEDICAID AMT-DR 01";
label variable ZIDPRV01 "ZERO-NITE IP STAZ-PRIV INS AMT-DR 01";
label variable ZIDVA01 "ZERO-NITE IP STAZ-VA AMT-DR 01";
label variable ZIDTRI01 "ZERO-NITE IP STAZ-TRICARE AMT-DR 01";
label variable ZIDOFD01 "ZERO-NITE IP STAZ-OTHER FED AMT-DR 01";
label variable ZIDSTL01 "ZERO-NITE IP STAZ-OTH ST/LOC AMT-DR 01";
label variable ZIDWCP01 "ZERO-NITE IP STAZ-WRKERS COMP AMT-DR 01";
label variable ZIDOPR01 "ZERO-NITE IP STAZ-OTH PRIVATE AMT-DR 01";
label variable ZIDOPU01 "ZERO-NITE IP STAZ-OTH PUBLIC AMT-DR 01";
label variable ZIDOSR01 "ZERO-NITE IP STAZ-UNCLAS SRCE AMT-DR 01";
label variable IPDIS01 "# HOSPITAL DISCHARGES, 2001";
label variable IPFEXP01 "TOT HOSP IP FACILITY EXP-INC 0 NITES 01";
label variable IPFTCH01 "IP HOSP STAY CHARGES - FAC 01";
label variable IPFSLF01 "IP HOSP STAZ-SELF/FAMILY AMT-FAC 01";
label variable IPFMCR01 "IP HOSP STAZ-MEDICARE AMT-FAC 01";
label variable IPFMCD01 "IP HOSP STAZ-MEDICAID AMT-FAC 01";
label variable IPFPRV01 "IP HOSP STAZ-PRIV INS AMT-FAC 01";
label variable IPFVA01 "IP HOSP STAZ-VA AMT-FAC 01";
label variable IPFTRI01 "IP HOSP STAZ-TRICARE AMT-FAC 01";
label variable IPFOFD01 "IP HOSP STAZ-OTHER FED AMT-FAC 01";
label variable IPFSTL01 "IP HOSP STAZ-OTH ST/LOCAL AMT-FAC 01";
label variable IPFWCP01 "IP HOSP STAZ-WORKERS COMP AMT-FAC 01";
label variable IPFOPR01 "IP HOSP STAZ - OTH PRIVATE AMT-FAC 01";
label variable IPFOPU01 "IP HOSP STAZ - OTH PUBLIC AMT-FAC 01";
label variable IPFOSR01 "IP HOSP STAZ-OT UNCLASS SRCE AMT-FAC 01";
label variable IPDEXP01 "TOTL HOSP STAZ DR EXP 01";
label variable IPDTCH01 "IP HOSP STAY CHARGES - DR 01";
label variable IPDSLF01 "IP HOSP STAZ-SELF/FAMILY AMT-DR 01";
label variable IPDMCR01 "IP HOSP STAZ-MEDICARE AMT- DR 01";
label variable IPDMCD01 "IP HOSP STAZ-MEDICAID AMT-DR 01";
label variable IPDPRV01 "IP HOSP STAZ-PRIV INS AMT- DR 01";
label variable IPDVA01 "IP HOSP STAZ-VA AMT-DR 01";
label variable IPDTRI01 "IP HOSP STAZ-TRICARE AMT-DR 01";
label variable IPDOFD01 "IP HOSP STAZ-OTHER FED AMT-DR 01";
label variable IPDSTL01 "IP HOSP STAZ-OTH ST/LOCAL AMT-DR 01";
label variable IPDWCP01 "IP HOSP STAZ-WORKERS COMP AMT-DR 01";
label variable IPDOPR01 "IP HOSP STAZ - OTH PRIVATE AMT-DR 01";
label variable IPDOPU01 "IP HOSP STAZ - OTH PUBLIC AMT-DR 01";
label variable IPDOSR01 "IP HOSP STAZ-OT UNCLASS SORCE AMT-DR 01";
label variable IPNGTD01 "# NIGHTS IN HOSP FOR DISCHARGES, 2001";
label variable DVTOT01 "# DENTAL CARE VISITS 01";
label variable DVTTCH01 "TOTAL DENTAL CARE VISIT CHARGES 01";
label variable DVTEXP01 "TOTAL DENTAL CARE EXP 01";
label variable DVTSLF01 "ALL DENTAL CARE -SELF/FAMILY AMT 01";
label variable DVTMCR01 "ALL DENTAL CARE -MEDICARE AMT 01";
label variable DVTMCD01 "ALL DENTAL CARE -MEDICAID AMT 01";
label variable DVTPRV01 "ALL DENTAL CARE -PRIVATE INS AMT 01";
label variable DVTVA01 "ALL DENTAL CARE -VA AMT 01";
label variable DVTTRI01 "ALL DENTAL CARE -TRICARE AMT 01";
label variable DVTOFD01 "ALL DENTAL CARE -OTHER FEDRL AMT 01";
label variable DVTSTL01 "ALL DENTAL CARE -OTH ST/LOCAL AMT 01";
label variable DVTWCP01 "ALL DENTAL CARE -WORKERS COMP AMT 01";
label variable DVTOPR01 "ALL DENTAL CARE - OTH PRIVATE AMT 01";
label variable DVTOPU01 "ALL DENTAL CARE - OTH PUBLIC AMT 01";
label variable DVTOSR01 "ALL DENT CARE-OT UNCLASS SRCE AMT 01";
label variable DVGEN01 "# GENERAL DENTIST VISITS 01";
label variable DVGTCH01 "GENERAL DENTAL CARE VISIT CHARGES 01";
label variable DVGEXP01 "TOTAL GENERAL DENTIST EXP 01";
label variable DVGSLF01 "GNRL DENTAL VISITS -SELF/FAM AMT 01";
label variable DVGMCR01 "GNRL DENTAL VISITS -MEDICARE AMT 01";
label variable DVGMCD01 "GNRL DENTAL VISITS -MEDICAID AMT 01";
label variable DVGPRV01 "GNRL DENTAL VISITS -PRIVATE INS AMT 01";
label variable DVGVA01 "GNRL DENTAL VISITS -VA AMT 01";
label variable DVGTRI01 "GNRL DENTAL VISITS-TRICARE AMT 01";
label variable DVGOFD01 "GNRL DENTAL VISITS- OTHER FED AMT 01";
label variable DVGSTL01 "GNRL DENTAL VISITS - OTH ST/LOCAL AMT 01";
label variable DVGWCP01 "GNRL DENTAL VISITS - WORKERS COMP AMT 01";
label variable DVGOPR01 "GNRL DENTAL VISITS - OTH PRIVATE AMT 01";
label variable DVGOPU01 "GNRL DENTAL VISITS - OTH PUBLIC AMT 01";
label variable DVGOSR01 "GNRL DENT VSTS - OT UNCLASS SRCE AMT 01";
label variable DVORTH01 "# ORTHODONTIST VISITS 01";
label variable DVOTCH01 "ORTHODONTIST VISIT CHARGES 01";
label variable DVOEXP01 "TOTAL ORTHODONTIST EXP 01";
label variable DVOSLF01 "ORTHODONTIST VISITS -SELF/FAMILY AMT 01";
label variable DVOMCR01 "ORTHODONTIST VISITS -MEDICARE AMT 01";
label variable DVOMCD01 "ORTHODONTIST VISITS -MEDICAID AMT 01";
label variable DVOPRV01 "ORTHODONTIST VISITS -PRIVATE INS AMT 01";
label variable DVOVA01 "ORTHODONTIST VISITS-VA AMT 01";
label variable DVOTRI01 "ORTHODONTIST VISITS-TRICARE AMT 01";
label variable DVOOFD01 "ORTHODONTIST VISITS-OTHR FED AMT 01";
label variable DVOSTL01 "ORTHODONTIST VISITS-OTHR ST/LOCAL AMT 01";
label variable DVOWCP01 "ORTHODONTIST VISITS-WORKERS COMP AMT 01";
label variable DVOOPR01 "ORTHODONTIST VISITS-OTHR PRIVATE AMT 01";
label variable DVOOPU01 "ORTHODONTIST VISITS-OTHR PUBLIC AMT 01";
label variable DVOOSR01 "ORTHODONT VSTS - OT UNCLASS SRCE AMT 01";
label variable HHTOTD01 "# HOME HEALTH PROVIDER DAYS, 2001";
label variable HHAGD01 "# AGENCY HOME HEALTH PROVIDER DAYS 01";
label variable HHATCH01 "HOME HEALTH AGENCY VISIT CHARGES 01";
label variable HHAEXP01 "TOTAL HOME HEALTH AGENCY EXP 01";
label variable HHASLF01 "HOME HLTH AGENCY -SELF/FAMILY AMT 01";
label variable HHAMCR01 "HOME HLTH AGENCY -MEDICARE AMT 01";
label variable HHAMCD01 "HOME HLTH AGENCY -MEDICAID AMT 01";
label variable HHAPRV01 "HOME HLTH AGENCY -PRIVATE INS AMT 01";
label variable HHAVA01 "HOME HLTH AGENCY-VA AMT 01";
label variable HHATRI01 "HOME HLTH AGENCY-TRICARE AMT 01";
label variable HHAOFD01 "HOME HLTH AGENCY-OTHER FED AMT 01";
label variable HHASTL01 "HOME HLTH AGENCY-OTHR ST/LOCAL AMT 01";
label variable HHAWCP01 "HOME HLTH AGENCY- WORKERS COMP AMT 01";
label variable HHAOPR01 "HOME HLTH AGENCY - OTH PRIVATE AMT 01";
label variable HHAOPU01 "HOME HLTH AGENCY - OTH PUBLIC AMT 01";
label variable HHAOSR01 "H HLTH AGENCY - OT UNCLASS SRCE AMT 01";
label variable HHINDD01 "# NON-AGENCY HOME HEALTH PROVIDR DAYS 01";
label variable HHNTCH01 "HOME HEALTH NON-AGENCY VISIT CHARGES 01";
label variable HHNEXP01 "TOTAL HOME HEALTH NON-AGNCY EXP 01";
label variable HHNSLF01 "HOME HLTH NON-AGNCY -SELF/FAM AMT 01";
label variable HHNMCR01 "HOME HLTH NON-AGNCY -MEDICARE AMT 01";
label variable HHNMCD01 "HOME HLTH NON-AGNCY -MEDICAID AMT 01";
label variable HHNPRV01 "HOME HLTH NON-AGNCY -PRIV INS AMT 01";
label variable HHNVA01 "HOME HLTH NON-AGNCY-VA AMT 01";
label variable HHNTRI01 "HOME HLTH NON-AGNCY-TRICARE AMT 01";
label variable HHNOFD01 "HOME HLTH NON-AGNCY-OTHR FED AMT 01";
label variable HHNSTL01 "HOME HLTH NON-AGNCY-OTHR ST/LOCL AMT 01";
label variable HHNWCP01 "HOME HLTH NON-AGNCY-WORKERS COMP AMT 01";
label variable HHNOPR01 "HOME HLTH NON-AGNCY-OTH PRIVATE AMT 01";
label variable HHNOPU01 "HOME HLTH NON-AGNCY-OTH PUBLIC AMT 01";
label variable HHNOSR01 "H HLTH NON-AGNCY-OT UNCLASS SRCE AMT 01";
label variable HHINFD01 "# INFORMAL HOME HEALTH PROVIDER DAYS 01";
label variable VISEXP01 "TOTAL GLASSES/CONTACT LENS EXP 01";
label variable VISTCH01 "GLASSES/CONTACT LENSES CHARGES 01";
label variable VISSLF01 "GLASSES/CNTCT LENSES -SELF/FAM AMT 01";
label variable VISMCR01 "GLASSES/CNTCT LENSES-MEDICARE AMT 01";
label variable VISMCD01 "GLASSES/CNTCT LENSES-MEDICAID AMT 01";
label variable VISPRV01 "GLASSES/CNTCT LENSES-PRIV INS AMT 01";
label variable VISVA01 "GLASSES/CNTCT LENSES-VA AMT 01";
label variable VISTRI01 "GLASSES/LENSES-TRICARE AMT 01";
label variable VISOFD01 "GLASSES/CNTCT LENSES-OTHR FED AMT 01";
label variable VISSTL01 "GLASSES/CNTCT LENSES-OTH ST/LOCL AMT 01";
label variable VISWCP01 "GLASSES/CNTCT LENSES-WORKERS COMP AMT 01";
label variable VISOPR01 "GLASSES/CNTCT LENSES-OTH PRIVATE AMT 01";
label variable VISOPU01 "GLASSES/CNTCT LENSES-OTH PUBLIC AMT 01";
label variable VISOSR01 "GLASES/CNTCT LENSE-OT UNCLAS SRCE AMT 01";
label variable OTHTCH01 "OTHER EQUP/SUPPLIES CHARGES 01";
label variable OTHEXP01 "TOT OTHER EQUIP/SPLY (EXCL DIAB) EXP 01";
label variable OTHSLF01 "OTHER EQUP/SUPPLIES -SELF/FAM AMT 01";
label variable OTHMCR01 "OTHER EQUP/SUPPLIES-MEDICARE AMT 01";
label variable OTHMCD01 "OTHER EQUP/SUPPLIES-MEDICAID AMT 01";
label variable OTHPRV01 "OTHER EQUP/SUPPLIES-PRIV INS AMT 01";
label variable OTHVA01 "OTHER EQUP/SUPPLY-VA AMT 01";
label variable OTHTRI01 "OTHER EQUP/SUPPLY-TRICARE AMT 01";
label variable OTHOFD01 "OTHER EQUP/SUPPLIES-OTHR FEDRL AMT 01";
label variable OTHSTL01 "OTHER EQUP/SUPPLY-OTHR ST/LOCAL AMT 01";
label variable OTHWCP01 "OTHER EQUP/SUPPLY -WORKERS COMP AMT 01";
label variable OTHOPR01 "OTHER EQUP/SUPPLY-OTH PRIVATE AMT 01";
label variable OTHOPU01 "OTHER EQUP/SUPPLY -OTH PUBLIC AMT 01";
label variable OTHOSR01 "OTH EQUP/SUPLY -OT UNCLASS SRCE AMT 01";
label variable RXTOT01 "# PRESC MEDS INCL REFILLS 01";
label variable RXEXP01 "TOTAL RX-EXP 01";
label variable RXSLF01 "TOTAL RX-SELF/FAMILY AMT 01";
label variable RXMCR01 "TOTAL RX--MEDICARE AMT 01";
label variable RXMCD01 "TOTAL RX-MEDICAID AMT 01";
label variable RXPRV01 "TOTAL RX-PRIVATE INS AMT 01";
label variable RXVA01 "TOTAL RX-VA AMT 01";
label variable RXTRI01 "TOTAL RX-TRICARE AMT 01";
label variable RXOFD01 "TOTAL RX-OTHER FED AMT 01";
label variable RXSTL01 "TOTAL RX-OTHER ST/LOCAL AMT 01";
label variable RXWCP01 "TOTAL RX-WORKERS COMP AMT 01";
label variable RXOPR01 "TOTAL RX - OTH PRIVATE AMT 01";
label variable RXOPU01 "TOTAL RX - OTH PUBLIC AMT 01";
label variable RXOSR01 "TOT RX-OTH UNCLASS SRCE AMT 01";
label variable PERWT01F "EXPENDITURE FILE PERSON WEIGHT 2001";
label variable FAMWT01F "EXPENDITURE FILE FAMILY WEIGHT 2001";
label variable FAMWT01C "EXPEND FILE FAMILY WGT-CPS FAM 12/31/01";
label variable SAQWT01F "EXPENDITURE FILE SAQ WEIGHT 2001";
label variable DIABW01F "EXPEND FILE DIABETES CARE SUPP WGT 2001";
label variable VARSTR01 "VARIANCE ESTIMATION STRATUM - 2001";
label variable VARPSU01 "VARIANCE ESTIMATION PSU - 2001";


*DEFINE VALUE LABELS FOR REPORTS;
label define H600001X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         1 "1 YES"
         2 "2 NO" ;

label define H600002X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H600003X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H600004X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H600005X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600006X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600007X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HAVE NO PROBLEMS"
         2 "2 HAVE SOME PROBLEMS"
         3 "3 UNABLE TO PERFORM ACTIVITIES" ;

label define H600008X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE"
         1 "1 1"
         2 "2 2"
         3 "3 3"
         4 "4 4"
         5 "5 5 TO 9"
         6 "6 10 OR MORE" ;

label define H600009X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 GOOD BIT OF TIME"
         4 "4 SOME OF THE TIME"
         5 "5 LITTLE OF THE TIME"
         6 "6 NONE OF THE TIME" ;

label define H600010X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 GOOD BIT OF TIME"
         4 "4 SOME OF THE TIME"
         5 "5 LITTLE OF THE TIME"
         6 "6 NONE OF THE TIME" ;

label define H600011X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LIMITED A LOT"
         2 "2 LIMITED A LITTLE"
         3 "3 NOT LIMITED" ;

label define H600012X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LIMITED A LOT"
         2 "2 LIMITED A LITTLE"
         3 "3 NOT LIMITED" ;

label define H600013X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NOT ANXIOUS/DEPRESSED"
         2 "2 MODERATELY ANXIOUS/DEPRESSED"
         3 "3 EXTREMELY ANXIOUS/DEPRESSED" ;

label define H600014X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600015X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600016X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H600017X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H600018X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 WORST HEALTH CARE POSSIBLE"
         10 "10 BEST HEALTH CARE POSSIBLE" ;

label define H600019X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600020X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H600021X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H600022X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H600023X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600024X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600025X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600026X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H600027X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600028X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600029X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HAVE NO PROBLEMS"
         2 "2 HAVE SOME PROBLEMS"
         3 "3 CONFINED TO BED" ;

label define H600030X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 BIG PROBLEM"
         2 "2 SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H600031X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H600032X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600033X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NOT AT ALL"
         2 "2 A LITTLE BIT"
         3 "3 MODERATELY"
         4 "4 QUITE A BIT"
         5 "5 EXTREMELY" ;

label define H600034X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HAVE NO PAIN"
         2 "2 HAVE MODERATE PAIN"
         3 "3 HAVE EXTREME PAIN" ;

label define H600035X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 GOOD BIT OF TIME"
         4 "4 SOME OF THE TIME"
         5 "5 LITTLE OF THE TIME"
         6 "6 NONE OF THE TIME" ;

label define H600036X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600037X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 BIG PROBLEM"
         2 "2 SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H600038X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H600039X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF-ADMINISTERED"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         100 "100 INTERVIEWER ADMINISTERED"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP - /HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 PARTNER'S DAUGHTER"
         33 "33 PARTNER'S SON"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP - /HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         47 "47 PARENT"
         49 "49 NOT PERSON ON SAQ LABEL RELATIONSHIP UNK"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H600040X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H600041X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H600042X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600043X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H600044X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 WORST HEALTH"
         100 "100 BEST HEALTH" ;

label define H600045X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HAVE NO PROBLEMS"
         2 "2 HAVE SOME PROBLEMS"
         3 "3 UNABLE TO WASH/DRESS" ;

label define H600046X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600047X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H600048X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600049X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO PROBLEM"
         1 "1 LITTLE PROBLEM"
         2 "2 SOME PROBLEM"
         3 "3 BIG PROBLEM"
         4 "4 A VERY BIG PROBLEM"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H600050X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 AFDC"
         2 "2 NOT AFDC" ;

label define H600051X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600052X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600053X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600054X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H600055X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600056X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600057X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600058X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600059X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600060X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600061X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600062X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600063X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600064X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600065X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600066X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600067X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600068X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600069X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600070X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600071X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600072X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600073X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600074X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600075X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1279 "$1279" ;

label define H600076X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600077X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600078X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600079X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600080X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600081X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600082X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600083X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600084X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600085X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600086X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600087X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600088X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600089X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600090X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600091X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600092X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600093X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600094X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600095X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600096X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         254 "$254" ;

label define H600097X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600098X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600099X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600100X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600101X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600102X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600103X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600104X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600105X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600106X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600107X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600108X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600109X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600110X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600111X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600112X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600113X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600114X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600115X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600116X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600117X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600118X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600119X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600120X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600121X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600122X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600123X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600124X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600125X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600126X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600127X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600128X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600129X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600130X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600131X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600132X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600133X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600134X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600135X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600136X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H600137X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HAVE APPOINTMENT"
         2 "2 JUST WALKS IN"
         3 "3 SOMETIMES APPOINTM,SOMETIMES WALKS IN" ;

label define H600138X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600139X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT APPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600140X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600141X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600142X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600143X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600144X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600145X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600146X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600147X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H600148X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H600149X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H600150X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H600151X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H600152X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H600153X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2000 "2000 YEAR"
         2001 "2001 YEAR" ;

label define H600154X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2000 "2000 YEAR"
         2001 "2001 YEAR" ;

label define H600155X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2000 "2000 YEAR"
         2001 "2001 YEAR"
         2002 "2002 YEAR" ;

label define H600156X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H600157X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H600158X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600159X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H600160X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600161X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600162X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H600163X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600164X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H600165X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H600166X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H600167X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H600168X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H600169X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600170X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H600171X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600172X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600173X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600174X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE"
         1 "1 1"
         2 "2 2"
         3 "3 3"
         4 "4 4"
         5 "5 5 TO 9"
         6 "6 10 OR MORE" ;

label define H600175X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H600176X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600177X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600178X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H600179X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600180X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H600181X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H600182X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H600183X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 WORST HEALTH CARE POSSIBLE"
         10 "10 BEST HEALTH CARE POSSIBLE" ;

label define H600184X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600185X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H600186X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600187X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600188X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600189X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600190X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600191X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H600192X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H600193X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 BIG PROBLEM"
         2 "2 SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H600194X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600195X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600196X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600197X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600198X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H600199X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600200X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600201X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600202X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H600203X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H600204X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H600205X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600206X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H600207X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600208X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600209X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600210X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600211X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600212X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600213X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600214X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 AGRICULTURE, FORESTRY, FISHERIES"
         10 "10 ENTERTAINMENT AND RECREATION"
         11 "11 PROFESSIONAL SERVICES"
         12 "12 PUBLIC ADMINISTRATION"
         13 "13 UNCLASSIFIABLE INDUSTRY"
         14 "14 ACTIVE MILITARY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 TRANSPORTATION, COMMUNICATION, UTILITIES"
         6 "6 SALES"
         7 "7 FINANCE, INSURANCE, REAL ESTATE"
         8 "8 REPAIR SERVICES"
         9 "9 PERSONAL SERVICES" ;

label define H600215X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 AGRICULTURE, FORESTRY, FISHERIES"
         10 "10 ENTERTAINMENT AND RECREATION"
         11 "11 PROFESSIONAL SERVICES"
         12 "12 PUBLIC ADMINISTRATION"
         13 "13 UNCLASSIFIABLE INDUSTRY"
         14 "14 ACTIVE MILITARY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 TRANSPORTATION, COMMUNICATION, UTILITIES"
         6 "6 SALES"
         7 "7 FINANCE, INSURANCE, REAL ESTATE"
         8 "8 REPAIR SERVICES"
         9 "9 PERSONAL SERVICES" ;

label define H600216X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 AGRICULTURE, FORESTRY, FISHERIES"
         10 "10 ENTERTAINMENT AND RECREATION"
         11 "11 PROFESSIONAL SERVICES"
         12 "12 PUBLIC ADMINISTRATION"
         13 "13 UNCLASSIFIABLE INDUSTRY"
         14 "14 ACTIVE MILITARY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 TRANSPORTATION, COMMUNICATION, UTILITIES"
         6 "6 SALES"
         7 "7 FINANCE, INSURANCE, REAL ESTATE"
         8 "8 REPAIR SERVICES"
         9 "9 PERSONAL SERVICES" ;

label define H600217X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600218X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H600219X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PROFESSIONAL, TECHNICAL AND KINDRED"
         10 "10 FARM OWNERS AND MANAGERS"
         11 "11 FARM LABORERS AND FOREMEN"
         12 "12 UNCLASSIFIABLE OCCUPATION"
         13 "13 ACTIVE MILITARY"
         14 "14 LAST WORKED PRIOR TO 1984"
         2 "2 MANAGERIAL AND ADMINISTRATIVE"
         3 "3 SALES WORKERS"
         4 "4 CLERICAL AND KINDRED WORKERS"
         5 "5 CRAFTSMEN AND FOREMEN"
         6 "6 OPERATIVES"
         7 "7 TRANSPORT OPERATIVES"
         8 "8 SERVICE WORKERS"
         9 "9 LABORERS, NOT FARMING" ;

label define H600220X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PROFESSIONAL, TECHNICAL AND KINDRED"
         10 "10 FARM OWNERS AND MANAGERS"
         11 "11 FARM LABORERS AND FOREMEN"
         12 "12 UNCLASSIFIABLE OCCUPATION"
         13 "13 ACTIVE MILITARY"
         14 "14 LAST WORKED PRIOR TO 1984"
         2 "2 MANAGERIAL AND ADMINISTRATIVE"
         3 "3 SALES WORKERS"
         4 "4 CLERICAL AND KINDRED WORKERS"
         5 "5 CRAFTSMEN AND FOREMEN"
         6 "6 OPERATIVES"
         7 "7 TRANSPORT OPERATIVES"
         8 "8 SERVICE WORKERS"
         9 "9 LABORERS, NOT FARMING" ;

label define H600221X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PROFESSIONAL, TECHNICAL AND KINDRED"
         10 "10 FARM OWNERS AND MANAGERS"
         11 "11 FARM LABORERS AND FOREMEN"
         12 "12 UNCLASSIFIABLE OCCUPATION"
         13 "13 ACTIVE MILITARY"
         14 "14 LAST WORKED PRIOR TO 1984"
         2 "2 MANAGERIAL AND ADMINISTRATIVE"
         3 "3 SALES WORKERS"
         4 "4 CLERICAL AND KINDRED WORKERS"
         5 "5 CRAFTSMEN AND FOREMEN"
         6 "6 OPERATIVES"
         7 "7 TRANSPORT OPERATIVES"
         8 "8 SERVICE WORKERS"
         9 "9 LABORERS, NOT FARMING" ;

label define H600222X
         -1 "-1 INAPPLICABLE"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H600223X
         -1 "-1 INAPPLICABLE"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H600224X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600225X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600226X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H600227X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H600228X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 UNKNOWN" ;

label define H600229X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H600230X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO PROBLEM"
         1 "1 LITTLE PROBLEM"
         2 "2 SOME PROBLEM"
         3 "3 BIG PROBLEM"
         4 "4 A VERY BIG PROBLEM"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H600231X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H600232X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H600233X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H600234X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         995 "995 NONE" ;

label define H600235X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         995 "995 NONE" ;

label define H600236X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         995 "995 NONE" ;

label define H600237X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         995 "995 NONE"
         996 "996 DOES NOT ATT SCHL" ;

label define H600238X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         995 "995 NONE"
         996 "996 DOES NOT ATT SCHL" ;

label define H600239X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         995 "995 NONE"
         996 "996 DOES NOT ATT SCHL" ;

label define H600240X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         995 "995 NONE"
         996 "996 DOES NOT WORK" ;

label define H600241X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         995 "995 NONE"
         996 "996 DOES NOT WORK" ;

label define H600242X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         995 "995 NONE"
         996 "996 DOES NOT WORK" ;

label define H600243X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600244X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ITEMIZED DEDUCTIONS"
         2 "2 STANDARD DEDUCTIONS" ;

label define H600245X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600246X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 TWICE A YEAR OR MORE"
         2 "2 ONCE A YEAR"
         3 "3 LESS THAN ONCE A YEAR"
         4 "4 NEVER GO TO DENTIST" ;

label define H600247X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600248X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600249X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600250X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600251X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600252X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES" ;

label define H600253X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600254X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H600255X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600256X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600257X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H600258X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H600259X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H600260X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600261X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED(WAGEIMP ONLY)"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK"
         7 "7 EDITED USING NHIS DATA" ;

label define H600262X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600263X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600264X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600265X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600266X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600267X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600268X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600269X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H600270X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H600271X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEPS IN RU"
         2 "2 DEPS IN AND OUT OF RU"
         3 "3 DEPS OUT OF RU" ;

label define H600272X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO DEPENDENTS OUTSIDE RU"
         1 "1 ONE DEPENDENT OUTSIDE RU"
         2 "2 TWO DEPENDENTS OUTSIDE RU"
         3 "3 THREE DEPENDENTS OUTSIDE RU" ;

label define H600273X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600274X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NUMBER OF TIMES" ;

label define H600275X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NUMBER OF TIMES" ;

label define H600276X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600277X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600278X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DURING 2002"
         2 "2 DURING 2001"
         3 "3 DURING 2000"
         4 "4 BEFORE 2000"
         5 "5 NEVER" ;

label define H600279X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600280X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600281X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600282X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600283X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600284X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600285X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600286X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600287X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600288X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600289X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600290X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600291X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600292X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600293X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600294X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600295X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600296X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600297X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600298X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600299X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600300X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600301X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600302X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600303X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600304X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600305X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600306X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600307X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600308X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600309X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600310X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600311X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600312X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         5799 "$5799" ;

label define H600313X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600314X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600315X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600316X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600317X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600318X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600319X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600320X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600321X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600322X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600323X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600324X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600325X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600326X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600327X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600328X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600329X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO SCHOOL/KINDERGARTEN ONLY"
         12 "12 GRADE 12"
         13 "13 1 YEAR COLLEGE"
         14 "14 2 YEARS COLLEGE"
         15 "15 3 YEARS COLLEGE"
         16 "16 4 YEARS COLLEGE"
         17 "17 5+ YEARS COLLEGE" ;

label define H600330X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H600331X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H600332X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H600333X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H600334X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H600335X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H600336X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 NOT ELIG/NOT LINKED TO RESPONDING RU" ;

label define H600337X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600338X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 3/1 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 3/1 INT DATE"
         3 "3 JOB DURING RD 3/1 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 3/1" ;

label define H600339X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 4/2 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 4/2 INT DATE"
         3 "3 JOB DURING RD 4/2 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 4/2" ;

label define H600340X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 5/3 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 5/3 INT DATE"
         3 "3 JOB DURING RD 5/3 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 5/3" ;

label define H600341X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H600342X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H600343X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H600344X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H600345X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H600346X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H600347X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H600348X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H600349X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2000 "2000 YEAR"
         2001 "2001 YEAR"
         2002 "2002 YEAR" ;

label define H600350X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2000 "2000 YEAR"
         2001 "2001 YEAR"
         2002 "2002 YEAR" ;

label define H600351X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2001 "2001 YEAR"
         2002 "2002 YEAR" ;

label define H600352X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2000 "2000 YEAR"
         2001 "2001 YEAR"
         2002 "2002 YEAR" ;

label define H600353X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H600354X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600355X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600356X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600357X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600358X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         43 "$43" ;

label define H600359X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600360X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600361X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600362X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600363X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600364X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600365X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600366X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600367X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600368X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600369X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600370X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600371X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600372X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600373X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600374X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600375X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600376X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600377X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600378X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600379X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600380X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600381X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600382X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600383X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600384X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600385X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600386X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600387X
         -1 "-1 INAPPLICABLE"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H600388X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H600389X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H600390X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H600391X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H600392X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H600393X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600394X
         -1 "-1 INAPP, NOT MEM OF 12/31 FAMILY"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H600395X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600396X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIMARY FILER"
         2 "2 SECONDARY FILER" ;

label define H600397X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SINGLE"
         2 "2 MARRIED FILING JOINT RETURN"
         3 "3 MARRIED FILING SEPARATELY"
         4 "4 HEAD OF HOUSEHOLD W/ QUALIFYING PERSON"
         5 "5 QUALIFYING WIDOWER W/ DEPENDENT" ;

label define H600398X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H600399X
         -1 "-1 INAPPLICABLE"
         0 "0 NONRESPONDING 12/31 FAMILY"
         1 "1 RESPONDING 12/31 FAMILY" ;

label define H600400X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H600401X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H600402X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600403X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600404X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600405X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600406X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H600407X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H600408X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H600409X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H600410X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DRIVE/IS DRIVEN"
         2 "2 TAXI,BUS,TRAIN,OTHER PUBLIC TRANSPORT"
         3 "3 WALKS"
         91 "91 OTHER WAY" ;

label define H600411X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600412X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO PROBLEM"
         1 "1 LITTLE PROBLEM"
         2 "2 SOME PROBLEM"
         3 "3 BIG PROBLEM"
         4 "4 A VERY BIG PROBLEM"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H600413X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY SATISFIED"
         2 "2 SOMEWHAT SATISFIED"
         3 "3 NOT TOO SATISFIED"
         4 "4 NOT AT ALL SATISFIED" ;

label define H600414X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600415X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600416X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600417X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SLIGHT IMPAIRMENT"
         3 "3 MODERATE IMPAIRMENT"
         4 "4 MAJOR IMPAIRMENT"
         5 "5 DEAF" ;

label define H600418X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600419X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600420X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600421X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600422X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600423X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600424X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600425X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600426X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600427X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600428X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600429X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600430X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600431X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600432X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600433X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600434X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600435X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600436X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600437X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600438X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600439X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600440X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600441X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600442X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600443X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600444X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600445X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         3180 "$3180" ;

label define H600446X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600447X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         750 "$750" ;

label define H600448X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600449X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600450X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         921 "$921" ;

label define H600451X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600452X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600453X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600454X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600455X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600456X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600457X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DEGREE"
         2 "2 GED"
         3 "3 HIGH SCHOOL DIPLOMA"
         4 "4 BACHELOR'S DEGREE"
         5 "5 MASTER'S DEGREE"
         6 "6 DOCTORATE DEGREE"
         7 "7 OTHER DEGREE"
         8 "8 UNDER 16-INAPPLICABLE" ;

label define H600458X
         1 "1 HISPANIC"
         2 "2 NOT HISPANIC" ;

label define H600459X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PUERTO RICAN"
         2 "2 CUBAN"
         3 "3 MEXICAN/MEXICAN AMERI/MEXICANO/CHICANO"
         4 "4 OTHER LATIN AMERICAN/OTHER SPANISH"
         5 "5 NON-HISPANIC"
         91 "91 OTHER HISPANIC/LATINO" ;

label define H600460X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H600461X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO PROBLEM"
         1 "1 LITTLE PROBLEM"
         2 "2 SOME PROBLEM"
         3 "3 BIG PROBLEM"
         4 "4 A VERY BIG PROBLEM"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H600462X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H600463X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H600464X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H600465X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600466X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600467X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600468X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600469X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600470X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600471X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600472X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600473X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600474X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600475X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600476X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600477X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600478X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600479X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600480X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600481X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600482X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600483X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600484X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600485X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600486X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600487X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600488X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600489X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600490X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600491X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600492X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600493X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600494X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600495X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600496X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600497X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600498X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600499X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600500X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600501X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600502X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600503X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600504X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600505X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600506X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600507X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600508X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600509X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600510X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600511X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600512X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600513X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600514X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600515X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600516X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600517X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600518X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600519X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600520X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600521X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600522X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600523X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600524X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600525X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600526X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600527X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600528X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600529X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600530X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600531X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600532X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600533X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600534X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600535X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600536X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600537X
         -1 "-1 INAPPLICABLE"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H600538X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H600539X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H600540X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $62.50"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H600541X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $62.50"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H600542X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $62.50"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H600543X
         0 "0 NO"
         1 "1 YES" ;

label define H600544X
         0 "0 NO"
         1 "1 YES" ;

label define H600545X
         0 "0 NO"
         1 "1 YES" ;

label define H600546X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600547X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600548X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600549X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600550X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600551X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600552X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600553X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600554X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600555X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600556X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600557X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600558X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600559X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600560X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600561X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600562X
         0 "0 NOT IN-SCOPE - NOT RESP/NOT IN AN RU"
         1 "1 IN-SCOPE ON 12/31/2001"
         2 "2 NOT IN-SCOPE ON 12/31/2001" ;

label define H600563X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/01"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H600564X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/01"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H600565X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/01"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H600566X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/01"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H600567X
         0 "0 NOT RECORDED AS BEING INSCOPE"
         1 "1 INSCOPE AT SOME TIME DURING 2001"
         2 "2 OUT-OF-SCOPE FOR ALL OF 2001" ;

label define H600568X
         1 "1 ANY PRIVATE"
         2 "2 PUBLIC ONLY"
         3 "3 UNINSURED" ;

label define H600569X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600570X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H600571X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H600572X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600573X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600574X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600575X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600576X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600577X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600578X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600579X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600580X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600581X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600582X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600583X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600584X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600585X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600586X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600587X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600588X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED(WAGEIMP ONLY)"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK"
         7 "7 EDITED USING NHIS DATA" ;

label define H600589X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600590X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600591X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600592X
         -1 "-1 INAPPLICABLE"
         1 "1 ENGLISH"
         2 "2 SPANISH"
         3 "3 ENGLISH & SPANISH"
         91 "91 OTHER" ;

label define H600593X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600594X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600595X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600596X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600597X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         50 "$50" ;

label define H600598X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600599X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600600X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         130 "$130 - $130" ;

label define H600601X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600602X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600603X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600604X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600605X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600606X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600607X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600608X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600609X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600610X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600611X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600612X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600613X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600614X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600615X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600616X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600617X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600618X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600619X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600620X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600621X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600622X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600623X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H600624X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600625X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600626X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600627X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600628X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H600629X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H600630X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H600631X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600632X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600633X
         -1 "-1 INAPPLICABLE"
         1 "1 KEY"
         2 "2 NOT KEY" ;

label define H600634X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO PROBLEM"
         1 "1 LITTLE PROBLEM"
         2 "2 SOME PROBLEM"
         3 "3 BIG PROBLEM"
         4 "4 A VERY BIG PROBLEM"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H600635X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600636X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600637X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H600638X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H600639X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600640X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600641X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600642X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 OFFICE"
         2 "2 HOSP, NOT ER"
         3 "3 HOSP, ER" ;

label define H600643X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H600644X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600645X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DIFFERENT LANGUAGE"
         11 "11 HARD TO GET INTO BUILDING"
         13 "13 NO APPROPRIATE EQUIPMENT IN OFFICE"
         14 "14 COULD NOT GET TIME OFF WORK"
         15 "15 DK WHERE TO GO TO GET CARE"
         16 "16 WAS REFUSED SERVICES"
         17 "17 COULDN'T GET CHILD CARE"
         18 "18 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 PRE-EXISTING CONDITION"
         4 "4 INS CO REQUIRED REFERRL-COULD NOT GET"
         5 "5 DOCTOR REFUSED FAMILY INS PLAN"
         6 "6 MEDICAL CARE TOO FAR AWAY"
         7 "7 CAN NOT DRIVE/NO CAR/NO PUBLIC TRANSP"
         8 "8 TOO EXPENSIVE TO GET THERE"
         9 "9 HEARING IMPAIRMENT OR LOSS"
         91 "91 OTHER" ;

label define H600646X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H600647X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE" ;

label define H600648X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H600649X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H600650X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H600651X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600652X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600653X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600654X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600655X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600656X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600657X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600658X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600659X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600660X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600661X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600662X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600663X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600664X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600665X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600666X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600667X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600668X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600669X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600670X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600671X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600672X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600673X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600674X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600675X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600676X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600677X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600678X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600679X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600680X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H600681X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H600682X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H600683X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600684X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600685X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600686X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600687X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600688X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600689X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600690X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600691X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H600692X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H600693X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H600694X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600695X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600696X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600697X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600698X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600699X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600700X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600701X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600702X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600703X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600704X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600705X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600706X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600707X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600708X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600709X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600710X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600711X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600712X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600713X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600714X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600715X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600716X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600717X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600718X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600719X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600720X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600721X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600722X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600723X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600724X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600725X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600726X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600727X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600728X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 TRIED, BUT PERSON WAS UNCOOPERATIVE" ;

label define H600729X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600730X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 TRIED, BUT PERSON WAS UNCOOPERATIVE" ;

label define H600731X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600732X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600733X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600734X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H600735X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H600736X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600737X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H600738X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H600739X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H600740X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELF"
         2 "2 PROXY" ;

label define H600741X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELF"
         2 "2 PROXY" ;

label define H600742X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELF"
         2 "2 PROXY" ;

label define H600743X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO PROBLEM"
         1 "1 LITTLE PROBLEM"
         2 "2 SOME PROBLEM"
         3 "3 BIG PROBLEM"
         4 "4 A VERY BIG PROBLEM"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H600744X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H600745X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H600746X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H600747X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600748X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600749X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600750X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600751X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H600752X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H600753X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H600754X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H600755X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H600756X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H600757X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H600758X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600759X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO PROBLEM"
         1 "1 LITTLE PROBLEM"
         2 "2 SOME PROBLEM"
         3 "3 BIG PROBLEM"
         4 "4 A VERY BIG PROBLEM"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H600760X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H600761X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600762X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600763X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600764X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600765X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600766X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600767X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600768X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WEEKS"
         2 "2 MONTHS" ;

label define H600769X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600770X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600771X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600772X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600773X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600774X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600775X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H600776X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H600777X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H600778X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H600779X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H600780X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H600781X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600782X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600783X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600784X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600785X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600786X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600787X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600788X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600789X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600790X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600791X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600792X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600793X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600794X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600795X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600796X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600797X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600798X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600799X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600800X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600801X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600802X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600803X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600804X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600805X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600806X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600807X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600808X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600809X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600810X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600811X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600812X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600813X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600814X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600815X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600816X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600817X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600818X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600819X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600820X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600821X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600822X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600823X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600824X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600825X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600826X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600827X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600828X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600829X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600830X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600831X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600832X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600833X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600834X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600835X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         254 "$254" ;

label define H600836X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600837X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600838X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600839X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600840X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600841X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600842X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600843X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600844X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600845X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600846X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600847X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600848X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600849X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600850X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600851X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600852X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600853X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600854X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600855X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600856X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600857X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600858X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600859X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600860X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600861X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600862X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600863X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600864X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600865X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600866X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600867X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600868X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600869X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600870X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600871X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600872X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600873X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600874X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600875X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600876X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600877X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600878X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         143 "$143" ;

label define H600879X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600880X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600881X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600882X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600883X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600884X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600885X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600886X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600887X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600888X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600889X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600890X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600891X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600892X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600893X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600894X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600895X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600896X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600897X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600898X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600899X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600900X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600901X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600902X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600903X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600904X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600905X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600906X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600907X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600908X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600909X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600910X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600911X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600912X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600913X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600914X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600915X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600916X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600917X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600918X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600919X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600920X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600921X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600922X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600923X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600924X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600925X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H600926X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600927X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600928X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600929X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600930X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600931X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600932X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600933X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600934X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H600935X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600936X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600937X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600938X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600939X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600940X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600941X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600942X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600943X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600944X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600945X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600946X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600947X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600948X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600949X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600950X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600951X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600952X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600953X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600954X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600955X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600956X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600957X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600958X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600959X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600960X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600961X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600962X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600963X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600964X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600965X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600966X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600967X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600968X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600969X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600970X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600971X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600972X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600973X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600974X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600975X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600976X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600977X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600978X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600979X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600980X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600981X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600982X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600983X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600984X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600985X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         150 "$150" ;

label define H600986X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600987X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600988X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600989X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600990X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600991X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600992X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600993X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600994X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600995X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600996X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600997X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600998X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H600999X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601000X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601001X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601002X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601003X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601004X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601005X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601006X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601007X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601008X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601009X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601010X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601011X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601012X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601013X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601014X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601015X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601016X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601017X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601018X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601019X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601020X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601021X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601022X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "1 YES"
         2 "2 NO" ;

label define H601023X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "1 YES"
         2 "2 NO" ;

label define H601024X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "1 YES"
         2 "2 NO" ;

label define H601025X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601026X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H601027X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601028X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601029X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601030X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601031X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601032X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601033X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601034X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601035X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601036X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601037X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601038X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601039X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601040X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601041X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601042X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601043X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1710 "$1710" ;

label define H601044X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601045X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601046X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601047X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601048X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601049X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601050X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601051X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601052X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601053X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601054X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601055X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601056X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601057X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601058X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601059X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601060X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601061X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601062X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601063X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601064X
         5 "5 PANEL 5"
         6 "6 PANEL 6" ;

label define H601065X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H601066X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601067X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601068X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601069X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601070X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601071X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601072X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601073X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601074X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601075X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601076X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601077X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601078X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601079X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601080X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601081X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601082X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601083X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601084X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601085X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601086X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601087X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601088X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601089X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601090X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601091X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601092X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601093X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601094X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601095X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601096X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601097X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED(WAGEIMP ONLY)"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK"
         7 "7 EDITED USING NHIS DATA" ;

label define H601098X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601099X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601100X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY HMO-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY HMO - NON-PLAN DRS COVERED"
         2 "2 COV BY HMO - NON-PLAN DRS NOT COVERED" ;

label define H601101X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY HMO-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY HMO - NON-PLAN DRS COVERED"
         2 "2 COV BY HMO - NON-PLAN DRS NOT COVERED" ;

label define H601102X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY HMO-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY HMO - NON-PLAN DRS COVERED"
         2 "2 COV BY HMO - NON-PLAN DRS NOT COVERED" ;

label define H601103X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H601104X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT APPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601105X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601106X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601107X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601108X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601109X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV GATEKPR-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY GATEKPR - NON-PLAN DRS COVERED"
         2 "2 COV BY GATEKPR-NON-PLAN DRS NOT COVERED" ;

label define H601110X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV GATEKPR-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY GATEKPR - NON-PLAN DRS COVERED"
         2 "2 COV BY GATEKPR-NON-PLAN DRS NOT COVERED" ;

label define H601111X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV GATEKPR-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY GATEKPR - NON-PLAN DRS COVERED"
         2 "2 COV BY GATEKPR-NON-PLAN DRS NOT COVERED" ;

label define H601112X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601113X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601114X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601115X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601116X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601117X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601118X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601119X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601120X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601121X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601122X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601123X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601124X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601125X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601126X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601127X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601128X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601129X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601130X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601131X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601132X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601133X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601134X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601135X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601136X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601137X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601138X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601139X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601140X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601141X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601142X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601143X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601144X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601145X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601146X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601147X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601148X
         1 "1 POOR/NEGATIVE"
         2 "2 NEAR POOR"
         3 "3 LOW INCOME"
         4 "4 MIDDLE INCOME"
         5 "5 HIGH INCOME" ;

label define H601149X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV DR LIST-NON-PLAN DRS NOT ASCERTD"
         1 "1 COV BY DR LIST-NON-PLAN DRS COVERED"
         2 "2 COV BY DR LIST-NON-PLAN DRS NOT COVRD" ;

label define H601150X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV DR LIST-NON-PLAN DRS NOT ASCERTD"
         1 "1 COV BY DR LIST - NON-PLAN DRS COVERED"
         2 "2 COV BY DR LIST-NON-PLAN DRS NOT COVRD" ;

label define H601151X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV DR LIST-NON-PLAN DRS NOT ASCERTD"
         1 "1 COV BY DR LIST - NON-PLAN DRS COVERED"
         2 "2 COV BY DR LIST-NON-PLAN DRS NOT COVRD" ;

label define H601152X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601153X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601154X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601155X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601156X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601157X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601158X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601159X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601160X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601161X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601162X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601163X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601164X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601165X
         -1 "-1 NOT APPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601166X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601167X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601168X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601169X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601170X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601171X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601172X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601173X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601174X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601175X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601176X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601177X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601178X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601179X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601180X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601181X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601182X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601183X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601184X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601185X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601186X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601187X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601188X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601189X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601190X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601191X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601192X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601193X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601194X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601195X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601196X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601197X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601198X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601199X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601200X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY SATISFIED"
         2 "2 SOMEWHAT SATISFIED"
         3 "3 NOT TOO SATISFIED"
         4 "4 NOT AT ALL SATISFIED" ;

label define H601201X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FACILITY"
         2 "2 PERSON"
         3 "3 PERSON IN FACILITY PROV" ;

label define H601202X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H601203X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H601204X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H601205X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H601206X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601207X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601208X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601209X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601210X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601211X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601212X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601213X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601214X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601215X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601216X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601217X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601218X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-DR LIST NOT ASCERTAINED"
         1 "1 COV BY PRIVATE PLAN W/DOCTOR LIST"
         2 "2 COV BY PRIV PLAN WITHOUT DR LIST"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H601219X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-DR LIST NOT ASCERTAINED"
         1 "1 COV BY PRIVATE PLAN W/DOCTOR LIST"
         2 "2 COV BY PRIV PLAN WITHOUT DR LIST"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H601220X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-DR LIST NOT ASCERTAINED"
         1 "1 COV BY PRIVATE PLAN W/DOCTOR LIST"
         2 "2 COV BY PRIV PLAN WITHOUT DR LIST"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H601221X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601222X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H601223X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H601224X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H601225X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-GATEKPR NOT ASCERTAINED"
         1 "1 COV BY PRIVATE GATEKEEPER PLAN"
         2 "2 COV BY PRIVATE INS - NOT GATEKEEPER"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H601226X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-GATEKPR NOT ASCERTAINED"
         1 "1 COV BY PRIVATE GATEKEEPER PLAN"
         2 "2 COV BY PRIVATE INS - NOT GATEKEEPER"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H601227X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-GATEKPR NOT ASCERTAINED"
         1 "1 COV BY PRIVATE GATEKEEPER PLAN"
         2 "2 COV BY PRIVATE INS - NOT GATEKEEPER"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H601228X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H601229X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU, NOT FT MIL"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R1 ONLY"
         62 "62 INSTITUT PRIOR TO REF PER-R1 ONLY"
         63 "63 LEFT U.S. PRIOR TO REF PER-R1 ONLY"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H601230X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU, NOT FT MIL"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R1 ONLY"
         62 "62 INSTITUT PRIOR TO REF PER-R1 ONLY"
         63 "63 LEFT U.S. PRIOR TO REF PER-R1 ONLY"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H601231X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU, NOT FT MIL"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R1 ONLY"
         62 "62 INSTITUT PRIOR TO REF PER-R1 ONLY"
         63 "63 LEFT U.S. PRIOR TO REF PER-R1 ONLY"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H601232X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601233X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601234X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601235X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601236X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601237X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601238X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601239X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601240X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601241X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601242X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601243X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601244X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H601245X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601246X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601247X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601248X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601249X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601250X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601251X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601252X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601253X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601254X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601255X
         1 "1 PERSON IS HISPANIC"
         2 "2 PERSON IS BLACK/NOT HISPANIC"
         3 "3 OTHER" ;

label define H601256X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 AMERICAN INDIAN"
         2 "2 ALEUT, ESKIMO"
         3 "3 ASIAN OR PACIFIC ISLANDER"
         4 "4 BLACK"
         5 "5 WHITE"
         91 "91 OTHER" ;

label define H601257X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H601258X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H601259X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601260X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601261X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601262X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601263X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H601264X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601265X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601266X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H601267X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H601268X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H601269X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H601270X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H601271X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H601272X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H601273X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H601274X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601275X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601276X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601277X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H601278X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H601279X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H601280X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H601281X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ROUND 1"
         2 "2 ROUND 2"
         3 "3 ROUND 3" ;

label define H601282X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H601283X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H601284X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H601285X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELF"
         2 "2 PROXY" ;

label define H601286X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELF"
         2 "2 PROXY" ;

label define H601287X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELF"
         2 "2 PROXY" ;

label define H601288X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H601289X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H601290X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H601291X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H601292X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H601293X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H601294X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H601295X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H601296X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601297X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601298X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601299X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601300X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601301X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601302X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601303X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601304X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601305X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601306X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601307X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601308X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601309X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601310X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601311X
         -1 "-1 INAPPLICABLE"
         0 "0" ;

label define H601312X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H601313X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO PROBLEM"
         1 "1 LITTLE PROBLEM"
         2 "2 SOME PROBLEM"
         3 "3 BIG PROBLEM"
         4 "4 A VERY BIG PROBLEM"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H601314X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601315X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601316X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO PROBLEM"
         1 "1 LITTLE PROBLEM"
         2 "2 SOME PROBLEM"
         3 "3 BIG PROBLEM"
         4 "4 A VERY BIG PROBLEM"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H601317X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601318X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601319X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601320X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALWAYS"
         2 "2 NEARLY ALWAYS"
         3 "3 SOMETIMES"
         4 "4 SELDOM"
         5 "5 NEVER"
         6 "6 NEVER DRIVES/RIDES IN A CAR" ;

label define H601321X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601322X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601323X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601324X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601325X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601326X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MALE"
         2 "2 FEMALE" ;

label define H601327X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO"
         1 "1 YES" ;

label define H601328X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO PROBLEM"
         1 "1 LITTLE PROBLEM"
         2 "2 SOME PROBLEM"
         3 "3 BIG PROBLEM"
         4 "4 A VERY BIG PROBLEM"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H601329X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H601330X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601331X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601332X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601333X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601334X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601335X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H601336X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H601337X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H601338X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H601339X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H601340X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H601341X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H601342X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H601343X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO PROBLEM"
         1 "1 LITTLE PROBLEM"
         2 "2 SOME PROBLEM"
         3 "3 BIG PROBLEM"
         4 "4 A VERY BIG PROBLEM"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H601344X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601345X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED(WAGEIMP ONLY)"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK"
         7 "7 EDITED USING NHIS DATA" ;

label define H601346X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601347X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601348X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISABLILITY"
         2 "2 SOME OTHER REASON" ;

label define H601349X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H601350X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601351X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H601352X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H601353X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H601354X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601355X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601356X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601357X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601358X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601359X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601360X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601361X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601362X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601363X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601364X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601365X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601366X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601367X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601368X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601369X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601370X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H601371X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H601372X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H601373X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H601374X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H601375X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H601376X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H601377X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H601378X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H601379X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H601380X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H601381X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601382X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601383X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO"
         5 "5 COMPLETELY UNABLE TO WALK" ;

label define H601384X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO"
         5 "5 COMPLETELY UNABLE TO WALK" ;

label define H601385X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601386X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601387X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601388X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601389X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601390X
         -1 "-1 INAPPLICABLE"
         1 "1 ENGLISH VERSION SAQ WAS ADMINISTERED"
         2 "2 SPANISH VERSION OF SAQ WAS ADMINISTERED" ;

label define H601391X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LONG TERM 1040"
         2 "2 SHORT FORM 1040A"
         3 "3 SHORT FORM 1040EZ"
         91 "91 OTHER" ;

label define H601392X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H601393X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H601394X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H601395X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601396X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601397X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601398X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601399X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601400X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SORE THROAT"
         2 "2 OTHER SYMPTOMS" ;

label define H601401X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601402X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601403X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601404X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601405X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601406X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601407X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601408X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601409X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601410X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601411X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601412X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601413X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601414X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601415X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601416X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601417X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO PROBLEM"
         1 "1 LITTLE PROBLEM"
         2 "2 SOME PROBLEM"
         3 "3 BIG PROBLEM"
         4 "4 A VERY BIG PROBLEM"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H601418X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601419X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601420X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601421X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601422X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601423X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601424X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601425X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601426X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601427X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601428X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601429X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601430X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601431X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601432X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601433X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601434X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601435X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601436X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601437X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601438X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601439X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H601440X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601441X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H601442X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601443X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MD-GEN/FAM PRACTICE"
         10 "10 OTHER NON-MD PROVIDR"
         11 "11 UNKNOWN"
         2 "2 MD-INTERNAL MEDICINE"
         3 "3 MD-PEDIATRICS"
         4 "4 MD-OB/GYN"
         5 "5 MD-SURGERY"
         6 "6 MD-OTHER"
         7 "7 CHIROPRACTOR"
         8 "8 NURSE/NURSE PRACTNR"
         9 "9 PHYSICIAN'S ASST" ;

label define H601444X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HOSP CLINIC/OUTPUT DEPT"
         2 "2 PRIV OFF IN HOSP"
         3 "3 HOSP ER"
         4 "4 NON-HOSP" ;

label define H601445X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601446X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601447X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H601448X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601449X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601450X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO PROBLEM"
         1 "1 LITTLE PROBLEM"
         2 "2 SOME PROBLEM"
         3 "3 BIG PROBLEM"
         4 "4 A VERY BIG PROBLEM"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H601451X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601452X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601453X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601454X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601455X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601456X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY SATISFIED"
         2 "2 SOMEWHAT SATISFIED"
         3 "3 NOT TOO SATISFIED"
         4 "4 NOT AT ALL SATISFIED" ;

label define H601457X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H601458X
         1 "1 ORIGINAL RESPONSE USED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H601459X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H601460X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H601461X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601462X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H601463X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H601464X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601465X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 IMPAIRED NEAR, BUT NOT FAR"
         4 "4 IMPAIRED BOTH NEAR AND FAR"
         5 "5 BLIND" ;

label define H601466X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601467X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601468X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601469X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601470X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601471X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601472X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601473X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601474X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601475X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601476X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601477X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601478X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601479X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601480X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H601481X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN 5 MIN"
         2 "2 5 TO 15 MINUTES"
         3 "3 16 TO 30 MINUTES"
         4 "4 31 TO 59 MINUTES"
         5 "5 1 TO 2 HOURS"
         6 "6 MORE THAN 2 HOURS" ;

label define H601482X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601483X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601484X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601485X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601486X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601487X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601488X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601489X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601490X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601491X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601492X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601493X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601494X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601495X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H601496X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS" ;

label define H601497X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H601498X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H601499X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H601500X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H601501X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H601502X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H601503X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H601504X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H601505X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H601506X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H601507X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H601508X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H601509X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601510X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601511X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601512X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601513X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H601514X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H601515X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601516X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601517X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601518X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H601519X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601520X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H601521X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE ANOTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISSOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H601522X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE OTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISSOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H601523X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         1 "1 FAM/PERS CHNGD INS PLAN"
         10 "10 JOB RELATED REASON"
         11 "11 NEW DOC REF/RECOM"
         12 "12 OTH COMPLNT OLD DOC"
         13 "13 TRANSPORTATION"
         2 "2 INSUR PLAN CHNG DOCS"
         3 "3 DISSATIS W/QUAL CARE"
         4 "4 HEALTH CARE NEEDS CHNGD"
         5 "5 TOO FAR AWAY"
         6 "6 MOVED TO NEW AREA"
         7 "7 OLD PROV NOT AVAIL"
         8 "8 COST-RELATED REASON"
         9 "9 OTHER INSUR-RELATED REASON"
         91 "91 OTHER REASON" ;

label define H601524X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PREFERS/LIKES THIS USC"
         10 "10 INSURANCE RELATED REASON"
         2 "2 DK WHERE ELSE TO GO"
         3 "3 CANT AFFORD GO ELSEWHERE"
         4 "4 OWN DOC HAS OFFICE HERE"
         5 "5 ONLY CARE AVAIL WHEN TIME"
         6 "6 CONVENIENCE"
         7 "7 BEST FOR MY CONDITION"
         8 "8 MILITARY/VA"
         91 "91 OTHER REASON" ;

label define H601525X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         1 "1 FAM/PERS CHNGD INSUR PLAN"
         10 "10 OTH INSUR-RELATED REASON"
         2 "2 INSURANCE PLAN CHANGED DOCTORS IT COVERS"
         3 "3 DISSATIS W/ QUAL CARE"
         4 "4 HEALTH CARE NEEDS CHANGED"
         5 "5 TOO FAR AWAY"
         6 "6 MOVED TO NEW AREA"
         7 "7 OLD PROV NOT AVAIL"
         8 "8 COST-RELATED REASON"
         9 "9 SELDOM SICK/NO NEED"
         91 "91 OTHER REASON" ;

label define H601526X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 SELDOM OR NEVER SICK"
         10 "10 OTHER INSUR-RELATED REAS"
         2 "2 RECENTLY MOVED TO AREA"
         3 "3 DONT KNOW WHERE TO GO"
         4 "4 USC IN AREA NOT AVAILABLE"
         6 "6 GOES DIFF PL FOR DIFF NEEDS"
         7 "7 JUST CHANGED INSUR PLANS"
         8 "8 DONT USE DOCS/TREAT SELF"
         9 "9 COST OF MEDICAL CARE"
         91 "91 OTHER REASON" ;

label define H601527X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601528X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601529X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601530X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601531X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601532X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         133 "$133" ;

label define H601533X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601534X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601535X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601536X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601537X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601538X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601539X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601540X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         311 "$311" ;

label define H601541X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601542X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601543X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601544X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601545X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601546X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601547X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601548X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601549X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601550X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601551X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601552X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H601553X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1541 "$1541" ;

label define H601554X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

* ASSOCIATE VARIABLES WITH VALUE LABEL DEFINITIONS;
label value ACCELI42 H600001X;
label value ACTDTY31 H600002X;
label value ACTDTY42 H600003X;
label value ACTDTY53 H600004X;
label value ACTLIM31 H600005X;
label value ACTLIM53 H600006X;
label value ADACTI42 H600007X;
label value ADAPPT42 H600008X;
label value ADBLUE42 H600009X;
label value ADCALM42 H600010X;
label value ADCLIM42 H600011X;
label value ADDAYA42 H600012X;
label value ADDEPR42 H600013X;
label value ADDRBP42 H600014X;
label value ADDSMK42 H600015X;
label value ADEXPL42 H600016X;
label value ADGENH42 H600017X;
label value ADHECR42 H600018X;
label value ADILCR42 H600019X;
label value ADILWW42 H600020X;
label value ADINSA42 H600021X;
label value ADINSB42 H600022X;
label value ADLHLP31 H600023X;
label value ADLHLP42 H600024X;
label value ADLHLP53 H600025X;
label value ADLIST42 H600026X;
label value ADMACC42 H600027X;
label value ADMLMT42 H600028X;
label value ADMOBI42 H600029X;
label value ADNECR42 H600030X;
label value ADOVER42 H600031X;
label value ADPACC42 H600032X;
label value ADPAIN42 H600033X;
label value ADPAYN42 H600034X;
label value ADPEP42 H600035X;
label value ADPLMT42 H600036X;
label value ADPRRE42 H600037X;
label value ADPRTM42 H600038X;
label value ADPRX42 H600039X;
label value ADRESP42 H600040X;
label value ADRISK42 H600041X;
label value ADRTCR42 H600042X;
label value ADRTWW42 H600043X;
label value ADSCAL42 H600044X;
label value ADSELF42 H600045X;
label value ADSMOK42 H600046X;
label value ADSOCA42 H600047X;
label value ADSPEC42 H600048X;
label value ADUPRO42 H600049X;
label value AFDC01 H600050X;
label value AFFORD42 H600051X;
label value AIDHLP31 H600052X;
label value AIDHLP53 H600053X;
label value ALIIMP01 H600054X;
label value ALIMP01X H600055X;
label value AMAEXP01 H600056X;
label value AMAMCD01 H600057X;
label value AMAMCR01 H600058X;
label value AMAOFD01 H600059X;
label value AMAOPR01 H600060X;
label value AMAOPU01 H600061X;
label value AMAOSR01 H600062X;
label value AMAPRV01 H600063X;
label value AMASLF01 H600064X;
label value AMASST01 H600065X;
label value AMASTL01 H600066X;
label value AMATCH01 H600067X;
label value AMATRI01 H600068X;
label value AMAVA01 H600069X;
label value AMAWCP01 H600070X;
label value AMCEXP01 H600071X;
label value AMCHIR01 H600072X;
label value AMCMCD01 H600073X;
label value AMCMCR01 H600074X;
label value AMCOFD01 H600075X;
label value AMCOPR01 H600076X;
label value AMCOPU01 H600077X;
label value AMCOSR01 H600078X;
label value AMCPRV01 H600079X;
label value AMCSLF01 H600080X;
label value AMCSTL01 H600081X;
label value AMCTCH01 H600082X;
label value AMCTRI01 H600083X;
label value AMCVA01 H600084X;
label value AMCWCP01 H600085X;
label value AMDRC01 H600086X;
label value AMEEXP01 H600087X;
label value AMEMCD01 H600088X;
label value AMEMCR01 H600089X;
label value AMEOFD01 H600090X;
label value AMEOPR01 H600091X;
label value AMEOPU01 H600092X;
label value AMEOSR01 H600093X;
label value AMEPRV01 H600094X;
label value AMESLF01 H600095X;
label value AMESTL01 H600096X;
label value AMETCH01 H600097X;
label value AMETRI01 H600098X;
label value AMEVA01 H600099X;
label value AMEWCP01 H600100X;
label value AMNEXP01 H600101X;
label value AMNMCD01 H600102X;
label value AMNMCR01 H600103X;
label value AMNOFD01 H600104X;
label value AMNOPR01 H600105X;
label value AMNOPU01 H600106X;
label value AMNOSR01 H600107X;
label value AMNPRV01 H600108X;
label value AMNSLF01 H600109X;
label value AMNSTL01 H600110X;
label value AMNTCH01 H600111X;
label value AMNTRI01 H600112X;
label value AMNURS01 H600113X;
label value AMNVA01 H600114X;
label value AMNWCP01 H600115X;
label value AMOPTO01 H600116X;
label value AMTEXP01 H600117X;
label value AMTHER01 H600118X;
label value AMTMCD01 H600119X;
label value AMTMCR01 H600120X;
label value AMTOFD01 H600121X;
label value AMTOPR01 H600122X;
label value AMTOPU01 H600123X;
label value AMTOSR01 H600124X;
label value AMTOTC01 H600125X;
label value AMTPRV01 H600126X;
label value AMTSLF01 H600127X;
label value AMTSTL01 H600128X;
label value AMTTCH01 H600129X;
label value AMTTRI01 H600130X;
label value AMTVA01 H600131X;
label value AMTWCP01 H600132X;
label value ANGIDX53 H600133X;
label value ANYLIM01 H600134X;
label value ANYUSC42 H600135X;
label value APPDIF42 H600136X;
label value APPTWL42 H600137X;
label value ARTHDX53 H600138X;
label value ARTHTX53 H600139X;
label value ASATAK53 H600140X;
label value ASFLOW53 H600141X;
label value ASMED53 H600142X;
label value ASPRIN53 H600143X;
label value ASSTER53 H600144X;
label value ASTHDX53 H600145X;
label value AVAILT42 H600146X;
label value BEGRFD31 H600147X;
label value BEGRFD42 H600148X;
label value BEGRFD53 H600149X;
label value BEGRFM31 H600150X;
label value BEGRFM42 H600151X;
label value BEGRFM53 H600152X;
label value BEGRFY31 H600153X;
label value BEGRFY42 H600154X;
label value BEGRFY53 H600155X;
label value BENDIF31 H600156X;
label value BENDIF53 H600157X;
label value BLIND42 H600158X;
label value BMINDX53 H600159X;
label value BOOST42 H600160X;
label value BOWEL53 H600161X;
label value BPCHEK53 H600162X;
label value BPMLDX53 H600163X;
label value BPMONT53 H600164X;
label value BRSTEX53 H600165X;
label value BSNTY31 H600166X;
label value BSNTY42 H600167X;
label value BSNTY53 H600168X;
label value BSTPLA42 H600169X;
label value BUSIMP01 H600170X;
label value BUSNP01X H600171X;
label value CARECO42 H600172X;
label value CASHP01X H600173X;
label value CHAPPT42 H600174X;
label value CHBMIX42 H600175X;
label value CHCOUN42 H600176X;
label value CHDDX53 H600177X;
label value CHECK53 H600178X;
label value CHEMPB42 H600179X;
label value CHEXPL42 H600180X;
label value CHGJ3142 H600181X;
label value CHGJ4253 H600182X;
label value CHHECR42 H600183X;
label value CHILCR42 H600184X;
label value CHILWW42 H600185X;
label value CHLDCA42 H600186X;
label value CHLDP01X H600187X;
label value CHLICO42 H600188X;
label value CHLIHB42 H600189X;
label value CHLIMI42 H600190X;
label value CHLIMP01 H600191X;
label value CHLIST42 H600192X;
label value CHNECR42 H600193X;
label value CHNGUS42 H600194X;
label value CHOIC31 H600195X;
label value CHOIC42 H600196X;
label value CHOIC53 H600197X;
label value CHOLCK53 H600198X;
label value CHPMCN42 H600199X;
label value CHPMED42 H600200X;
label value CHPMHB42 H600201X;
label value CHPRRE42 H600202X;
label value CHPRTM42 H600203X;
label value CHRESP42 H600204X;
label value CHRTCR42 H600205X;
label value CHRTWW42 H600206X;
label value CHSERV42 H600207X;
label value CHSPEC42 H600208X;
label value CHSRCN42 H600209X;
label value CHSRHB42 H600210X;
label value CHTHCO42 H600211X;
label value CHTHER42 H600212X;
label value CHTHHB42 H600213X;
label value CIND31 H600214X;
label value CIND42 H600215X;
label value CIND53 H600216X;
label value CLMDEP01 H600217X;
label value CLMHIP01 H600218X;
label value COCCP31 H600219X;
label value COCCP42 H600220X;
label value COCCP53 H600221X;
label value COGLIM31 H600222X;
label value COGLIM53 H600223X;
label value CONFID42 H600224X;
label value CONVEN42 H600225X;
label value COVRMM H600226X;
label value COVRYY H600227X;
label value CSHCN42 H600228X;
label value CSHIMP01 H600229X;
label value DADPRO42 H600230X;
label value DAPID31X H600231X;
label value DAPID42X H600232X;
label value DAPID53X H600233X;
label value DDBDYS31 H600234X;
label value DDBDYS42 H600235X;
label value DDBDYS53 H600236X;
label value DDNSCL31 H600237X;
label value DDNSCL42 H600238X;
label value DDNSCL53 H600239X;
label value DDNWRK31 H600240X;
label value DDNWRK42 H600241X;
label value DDNWRK53 H600242X;
label value DEAF42 H600243X;
label value DEDUCT01 H600244X;
label value DENTAL42 H600245X;
label value DENTCK53 H600246X;
label value DENTIN31 H600247X;
label value DENTIN42 H600248X;
label value DENTIN53 H600249X;
label value DENYINSR H600250X;
label value DENYOTH H600251X;
label value DEPDNT01 H600252X;
label value DIABDX53 H600253X;
label value DIDSERVE H600254X;
label value DIFFPL42 H600255X;
label value DISTAN42 H600256X;
label value DISVW31X H600257X;
label value DISVW42X H600258X;
label value DISVW53X H600259X;
label value DIVDP01X H600260X;
label value DIVIMP01 H600261X;
label value DKELSE42 H600262X;
label value DKWHER42 H600263X;
label value DKWHRU42 H600264X;
label value DNYCANC H600265X;
label value DNYCORON H600266X;
label value DNYDIAB H600267X;
label value DNYHYPER H600268X;
label value DOBMM H600269X;
label value DOBYY H600270X;
label value DPINRU01 H600271X;
label value DPOTSD01 H600272X;
label value DRTHRT53 H600273X;
label value DSA1C53 H600274X;
label value DSCKFT53 H600275X;
label value DSDIA53 H600276X;
label value DSDIET53 H600277X;
label value DSEYE53 H600278X;
label value DSEYPR53 H600279X;
label value DSINSU53 H600280X;
label value DSKIDN53 H600281X;
label value DSMED53 H600282X;
label value DSPRX53 H600283X;
label value DVGEN01 H600284X;
label value DVGEXP01 H600285X;
label value DVGMCD01 H600286X;
label value DVGMCR01 H600287X;
label value DVGOFD01 H600288X;
label value DVGOPR01 H600289X;
label value DVGOPU01 H600290X;
label value DVGOSR01 H600291X;
label value DVGPRV01 H600292X;
label value DVGSLF01 H600293X;
label value DVGSTL01 H600294X;
label value DVGTCH01 H600295X;
label value DVGTRI01 H600296X;
label value DVGVA01 H600297X;
label value DVGWCP01 H600298X;
label value DVOEXP01 H600299X;
label value DVOMCD01 H600300X;
label value DVOMCR01 H600301X;
label value DVOOFD01 H600302X;
label value DVOOPR01 H600303X;
label value DVOOPU01 H600304X;
label value DVOOSR01 H600305X;
label value DVOPRV01 H600306X;
label value DVORTH01 H600307X;
label value DVOSLF01 H600308X;
label value DVOSTL01 H600309X;
label value DVOTCH01 H600310X;
label value DVOTRI01 H600311X;
label value DVOVA01 H600312X;
label value DVOWCP01 H600313X;
label value DVTEXP01 H600314X;
label value DVTMCD01 H600315X;
label value DVTMCR01 H600316X;
label value DVTOFD01 H600317X;
label value DVTOPR01 H600318X;
label value DVTOPU01 H600319X;
label value DVTOSR01 H600320X;
label value DVTPRV01 H600321X;
label value DVTSLF01 H600322X;
label value DVTSTL01 H600323X;
label value DVTTCH01 H600324X;
label value DVTTRI01 H600325X;
label value DVTVA01 H600326X;
label value DVTWCP01 H600327X;
label value EATHLT42 H600328X;
label value EDUCYEAR H600329X;
label value EICRDT01 H600330X;
label value ELDISC01 H600331X;
label value ELGRND01 H600332X;
label value ELGRND31 H600333X;
label value ELGRND42 H600334X;
label value ELGRND53 H600335X;
label value ELIGIBLE H600336X;
label value EMPHDX53 H600337X;
label value EMPST31 H600338X;
label value EMPST42 H600339X;
label value EMPST53 H600340X;
label value ENDRFD01 H600341X;
label value ENDRFD31 H600342X;
label value ENDRFD42 H600343X;
label value ENDRFD53 H600344X;
label value ENDRFM01 H600345X;
label value ENDRFM31 H600346X;
label value ENDRFM42 H600347X;
label value ENDRFM53 H600348X;
label value ENDRFY01 H600349X;
label value ENDRFY31 H600350X;
label value ENDRFY42 H600351X;
label value ENDRFY53 H600352X;
label value EQU42 H600353X;
label value EQUIPM42 H600354X;
label value ERDEXP01 H600355X;
label value ERDMCD01 H600356X;
label value ERDMCR01 H600357X;
label value ERDOFD01 H600358X;
label value ERDOPR01 H600359X;
label value ERDOPU01 H600360X;
label value ERDOSR01 H600361X;
label value ERDPRV01 H600362X;
label value ERDSLF01 H600363X;
label value ERDSTL01 H600364X;
label value ERDTCH01 H600365X;
label value ERDTRI01 H600366X;
label value ERDVA01 H600367X;
label value ERDWCP01 H600368X;
label value ERFEXP01 H600369X;
label value ERFMCD01 H600370X;
label value ERFMCR01 H600371X;
label value ERFOFD01 H600372X;
label value ERFOPR01 H600373X;
label value ERFOPU01 H600374X;
label value ERFOSR01 H600375X;
label value ERFPRV01 H600376X;
label value ERFSLF01 H600377X;
label value ERFSTL01 H600378X;
label value ERFTCH01 H600379X;
label value ERFTRI01 H600380X;
label value ERFVA01 H600381X;
label value ERFWCP01 H600382X;
label value EVRETIRE H600383X;
label value EVRWRK H600384X;
label value EXPENS42 H600385X;
label value EXRCIS53 H600386X;
label value FAMRFPYR H600387X;
label value FAMSZE01 H600388X;
label value FAMSZE31 H600389X;
label value FAMSZE42 H600390X;
label value FAMSZE53 H600391X;
label value FARIMP01 H600392X;
label value FARMP01X H600393X;
label value FCRP1231 H600394X;
label value FILEDR01 H600395X;
label value FILER01 H600396X;
label value FLSTAT01 H600397X;
label value FLUSHT53 H600398X;
label value FMRS1231 H600399X;
label value FNGRDF31 H600400X;
label value FNGRDF53 H600401X;
label value FOODCT01 H600402X;
label value FOODMN01 H600403X;
label value FOODST01 H600404X;
label value FOODVL01 H600405X;
label value FTSTU01X H600406X;
label value FTSTU31X H600407X;
label value FTSTU42X H600408X;
label value FTSTU53X H600409X;
label value GETTOU42 H600410X;
label value HAVEUS42 H600411X;
label value HAVFUN42 H600412X;
label value HCNEED42 H600413X;
label value HEARAD42 H600414X;
label value HEARDI42 H600415X;
label value HEARMO42 H600416X;
label value HEARNG42 H600417X;
label value HEARPR42 H600418X;
label value HEARSM42 H600419X;
label value HELD31X H600420X;
label value HELD42X H600421X;
label value HELD53X H600422X;
label value HELMET42 H600423X;
label value HHAEXP01 H600424X;
label value HHAGD01 H600425X;
label value HHAMCD01 H600426X;
label value HHAMCR01 H600427X;
label value HHAOFD01 H600428X;
label value HHAOPR01 H600429X;
label value HHAOPU01 H600430X;
label value HHAOSR01 H600431X;
label value HHAPRV01 H600432X;
label value HHASLF01 H600433X;
label value HHASTL01 H600434X;
label value HHATCH01 H600435X;
label value HHATRI01 H600436X;
label value HHAVA01 H600437X;
label value HHAWCP01 H600438X;
label value HHINDD01 H600439X;
label value HHINFD01 H600440X;
label value HHNEXP01 H600441X;
label value HHNMCD01 H600442X;
label value HHNMCR01 H600443X;
label value HHNOFD01 H600444X;
label value HHNOPR01 H600445X;
label value HHNOPU01 H600446X;
label value HHNOSR01 H600447X;
label value HHNPRV01 H600448X;
label value HHNSLF01 H600449X;
label value HHNSTL01 H600450X;
label value HHNTCH01 H600451X;
label value HHNTRI01 H600452X;
label value HHNVA01 H600453X;
label value HHNWCP01 H600454X;
label value HHTOTD01 H600455X;
label value HIBPDX53 H600456X;
label value HIDEGYR H600457X;
label value HISPANX H600458X;
label value HISPCAT H600459X;
label value HLTHLF42 H600460X;
label value HOMEBH42 H600461X;
label value HOUR31 H600462X;
label value HOUR42 H600463X;
label value HOUR53 H600464X;
label value HPDAP01 H600465X;
label value HPDAU01 H600466X;
label value HPDDE01 H600467X;
label value HPDFE01 H600468X;
label value HPDJA01 H600469X;
label value HPDJL01 H600470X;
label value HPDJU01 H600471X;
label value HPDMA01 H600472X;
label value HPDMY01 H600473X;
label value HPDNO01 H600474X;
label value HPDOC01 H600475X;
label value HPDSE01 H600476X;
label value HPEAP01 H600477X;
label value HPEAU01 H600478X;
label value HPEDE01 H600479X;
label value HPEFE01 H600480X;
label value HPEJA01 H600481X;
label value HPEJL01 H600482X;
label value HPEJU01 H600483X;
label value HPEMA01 H600484X;
label value HPEMY01 H600485X;
label value HPENO01 H600486X;
label value HPEOC01 H600487X;
label value HPESE01 H600488X;
label value HPNAP01 H600489X;
label value HPNAU01 H600490X;
label value HPNDE01 H600491X;
label value HPNFE01 H600492X;
label value HPNJA01 H600493X;
label value HPNJL01 H600494X;
label value HPNJU01 H600495X;
label value HPNMA01 H600496X;
label value HPNMY01 H600497X;
label value HPNNO01 H600498X;
label value HPNOC01 H600499X;
label value HPNSE01 H600500X;
label value HPOAP01 H600501X;
label value HPOAU01 H600502X;
label value HPODE01 H600503X;
label value HPOFE01 H600504X;
label value HPOJA01 H600505X;
label value HPOJL01 H600506X;
label value HPOJU01 H600507X;
label value HPOMA01 H600508X;
label value HPOMY01 H600509X;
label value HPONO01 H600510X;
label value HPOOC01 H600511X;
label value HPOSE01 H600512X;
label value HPRAP01 H600513X;
label value HPRAU01 H600514X;
label value HPRDE01 H600515X;
label value HPRFE01 H600516X;
label value HPRJA01 H600517X;
label value HPRJL01 H600518X;
label value HPRJU01 H600519X;
label value HPRMA01 H600520X;
label value HPRMY01 H600521X;
label value HPRNO01 H600522X;
label value HPROC01 H600523X;
label value HPRSE01 H600524X;
label value HPSAP01 H600525X;
label value HPSAU01 H600526X;
label value HPSDE01 H600527X;
label value HPSFE01 H600528X;
label value HPSJA01 H600529X;
label value HPSJL01 H600530X;
label value HPSJU01 H600531X;
label value HPSMA01 H600532X;
label value HPSMY01 H600533X;
label value HPSNO01 H600534X;
label value HPSOC01 H600535X;
label value HPSSE01 H600536X;
label value HRHOW31 H600537X;
label value HRHOW42 H600538X;
label value HRHOW53 H600539X;
label value HRWG31X H600540X;
label value HRWG42X H600541X;
label value HRWG53X H600542X;
label value HRWGIM31 H600543X;
label value HRWGIM42 H600544X;
label value HRWGIM53 H600545X;
label value HSELIM31 H600546X;
label value HSELIM53 H600547X;
label value HYSTER53 H600548X;
label value IADLHP31 H600549X;
label value IADLHP42 H600550X;
label value IADLHP53 H600551X;
label value INS01X H600552X;
label value INS31X H600553X;
label value INS42X H600554X;
label value INS53X H600555X;
label value INSAP01X H600556X;
label value INSAT01X H600557X;
label value INSAT31X H600558X;
label value INSAT42X H600559X;
label value INSAT53X H600560X;
label value INSAU01X H600561X;
label value INSC1231 H600562X;
label value INSCOP01 H600563X;
label value INSCOP31 H600564X;
label value INSCOP42 H600565X;
label value INSCOP53 H600566X;
label value INSCOPE H600567X;
label value INSCOV01 H600568X;
label value INSDE01X H600569X;
label value INSENDMM H600570X;
label value INSENDYY H600571X;
label value INSFE01X H600572X;
label value INSIDE42 H600573X;
label value INSJA01X H600574X;
label value INSJL01X H600575X;
label value INSJU01X H600576X;
label value INSLIMIT H600577X;
label value INSLOOK H600578X;
label value INSMA01X H600579X;
label value INSMY01X H600580X;
label value INSNO01X H600581X;
label value INSNOP42 H600582X;
label value INSOC01X H600583X;
label value INSREA42 H600584X;
label value INSRPL42 H600585X;
label value INSRQR42 H600586X;
label value INSSE01X H600587X;
label value INTIMP01 H600588X;
label value INTOBL42 H600589X;
label value INTRP01X H600590X;
label value INTRTX01 H600591X;
label value INTVLANG H600592X;
label value IPDEXP01 H600593X;
label value IPDIS01 H600594X;
label value IPDMCD01 H600595X;
label value IPDMCR01 H600596X;
label value IPDOFD01 H600597X;
label value IPDOPR01 H600598X;
label value IPDOPU01 H600599X;
label value IPDOSR01 H600600X;
label value IPDPRV01 H600601X;
label value IPDSLF01 H600602X;
label value IPDSTL01 H600603X;
label value IPDTCH01 H600604X;
label value IPDTRI01 H600605X;
label value IPDVA01 H600606X;
label value IPDWCP01 H600607X;
label value IPFEXP01 H600608X;
label value IPFMCD01 H600609X;
label value IPFMCR01 H600610X;
label value IPFOFD01 H600611X;
label value IPFOPR01 H600612X;
label value IPFOPU01 H600613X;
label value IPFOSR01 H600614X;
label value IPFPRV01 H600615X;
label value IPFSLF01 H600616X;
label value IPFSTL01 H600617X;
label value IPFTCH01 H600618X;
label value IPFTRI01 H600619X;
label value IPFVA01 H600620X;
label value IPFWCP01 H600621X;
label value IPNGTD01 H600622X;
label value IRAIMP01 H600623X;
label value IRASP01X H600624X;
label value IRATAX01 H600625X;
label value ITMEXP01 H600626X;
label value JNTPID01 H600627X;
label value JOBORG31 H600628X;
label value JOBORG42 H600629X;
label value JOBORG53 H600630X;
label value JTINRU01 H600631X;
label value JTPAIN53 H600632X;
label value KEYNESS H600633X;
label value KIDPRO42 H600634X;
label value LANGBA42 H600635X;
label value LAPBLT42 H600636X;
label value LFTDIF31 H600637X;
label value LFTDIF53 H600638X;
label value LIKESU42 H600639X;
label value LIMITOT H600640X;
label value LMTBACK H600641X;
label value LOCATI42 H600642X;
label value LSHLTH42 H600643X;
label value LSTETH53 H600644X;
label value MAINPR42 H600645X;
label value MAMOGR53 H600646X;
label value MARRY01X H600647X;
label value MARRY31X H600648X;
label value MARRY42X H600649X;
label value MARRY53X H600650X;
label value MCAID01 H600651X;
label value MCAID01X H600652X;
label value MCAID31 H600653X;
label value MCAID31X H600654X;
label value MCAID42 H600655X;
label value MCAID42X H600656X;
label value MCAID53 H600657X;
label value MCAID53X H600658X;
label value MCARE01 H600659X;
label value MCARE01X H600660X;
label value MCARE31 H600661X;
label value MCARE31X H600662X;
label value MCARE42 H600663X;
label value MCARE42X H600664X;
label value MCARE53 H600665X;
label value MCARE53X H600666X;
label value MCDAP01 H600667X;
label value MCDAP01X H600668X;
label value MCDAT01X H600669X;
label value MCDAT31X H600670X;
label value MCDAT42X H600671X;
label value MCDAT53X H600672X;
label value MCDAU01 H600673X;
label value MCDAU01X H600674X;
label value MCDDE01 H600675X;
label value MCDDE01X H600676X;
label value MCDEV01 H600677X;
label value MCDFE01 H600678X;
label value MCDFE01X H600679X;
label value MCDHMO01 H600680X;
label value MCDHMO31 H600681X;
label value MCDHMO42 H600682X;
label value MCDJA01 H600683X;
label value MCDJA01X H600684X;
label value MCDJL01 H600685X;
label value MCDJL01X H600686X;
label value MCDJU01 H600687X;
label value MCDJU01X H600688X;
label value MCDMA01 H600689X;
label value MCDMA01X H600690X;
label value MCDMC01 H600691X;
label value MCDMC31 H600692X;
label value MCDMC42 H600693X;
label value MCDMY01 H600694X;
label value MCDMY01X H600695X;
label value MCDNO01 H600696X;
label value MCDNO01X H600697X;
label value MCDOC01 H600698X;
label value MCDOC01X H600699X;
label value MCDSE01 H600700X;
label value MCDSE01X H600701X;
label value MCRAP01 H600702X;
label value MCRAP01X H600703X;
label value MCRAU01 H600704X;
label value MCRAU01X H600705X;
label value MCRDE01 H600706X;
label value MCRDE01X H600707X;
label value MCREV01 H600708X;
label value MCRFE01 H600709X;
label value MCRFE01X H600710X;
label value MCRJA01 H600711X;
label value MCRJA01X H600712X;
label value MCRJL01 H600713X;
label value MCRJL01X H600714X;
label value MCRJU01 H600715X;
label value MCRJU01X H600716X;
label value MCRMA01 H600717X;
label value MCRMA01X H600718X;
label value MCRMY01 H600719X;
label value MCRMY01X H600720X;
label value MCRNO01 H600721X;
label value MCRNO01X H600722X;
label value MCROC01 H600723X;
label value MCROC01X H600724X;
label value MCRSE01 H600725X;
label value MCRSE01X H600726X;
label value MCS42 H600727X;
label value MESBPR42 H600728X;
label value MESHGT42 H600729X;
label value MESVIS42 H600730X;
label value MESWGT42 H600731X;
label value MEXAMT01 H600732X;
label value MIDX53 H600733X;
label value MILDIF31 H600734X;
label value MILDIF53 H600735X;
label value MINORP42 H600736X;
label value MNHLTH31 H600737X;
label value MNHLTH42 H600738X;
label value MNHLTH53 H600739X;
label value MNPROX31 H600740X;
label value MNPROX42 H600741X;
label value MNPROX53 H600742X;
label value MOMPRO42 H600743X;
label value MOPID31X H600744X;
label value MOPID42X H600745X;
label value MOPID53X H600746X;
label value MORE31 H600747X;
label value MORE42 H600748X;
label value MORE53 H600749X;
label value MORECOVR H600750X;
label value MORJOB31 H600751X;
label value MORJOB42 H600752X;
label value MORJOB53 H600753X;
label value MSA01 H600754X;
label value MSA31 H600755X;
label value MSA42 H600756X;
label value MSA53 H600757X;
label value MYSELF42 H600758X;
label value NERVAF42 H600759X;
label value NEVILL42 H600760X;
label value NEWARE42 H600761X;
label value NOAFFO42 H600762X;
label value NOASPR53 H600763X;
label value NOCARE42 H600764X;
label value NOFAT53 H600765X;
label value NOINSBEF H600766X;
label value NOINSTM H600767X;
label value NOINUNIT H600768X;
label value NOOTHP42 H600769X;
label value NOREA942 H600770X;
label value NOREAS42 H600771X;
label value NOSMOK42 H600772X;
label value NOTIME42 H600773X;
label value NTMDED01 H600774X;
label value NUMEMP31 H600775X;
label value NUMEMP42 H600776X;
label value NUMEMP53 H600777X;
label value NWK31 H600778X;
label value NWK42 H600779X;
label value NWK53 H600780X;
label value OBAEXP01 H600781X;
label value OBAMCD01 H600782X;
label value OBAMCR01 H600783X;
label value OBAOFD01 H600784X;
label value OBAOPR01 H600785X;
label value OBAOPU01 H600786X;
label value OBAOSR01 H600787X;
label value OBAPRV01 H600788X;
label value OBASLF01 H600789X;
label value OBASST01 H600790X;
label value OBASTL01 H600791X;
label value OBATCH01 H600792X;
label value OBATRI01 H600793X;
label value OBAVA01 H600794X;
label value OBAWCP01 H600795X;
label value OBCEXP01 H600796X;
label value OBCHIR01 H600797X;
label value OBCMCD01 H600798X;
label value OBCMCR01 H600799X;
label value OBCOFD01 H600800X;
label value OBCOPR01 H600801X;
label value OBCOPU01 H600802X;
label value OBCOSR01 H600803X;
label value OBCPRV01 H600804X;
label value OBCSLF01 H600805X;
label value OBCSTL01 H600806X;
label value OBCTCH01 H600807X;
label value OBCTRI01 H600808X;
label value OBCVA01 H600809X;
label value OBCWCP01 H600810X;
label value OBDEXP01 H600811X;
label value OBDMCD01 H600812X;
label value OBDMCR01 H600813X;
label value OBDOFD01 H600814X;
label value OBDOPR01 H600815X;
label value OBDOPU01 H600816X;
label value OBDOSR01 H600817X;
label value OBDPRV01 H600818X;
label value OBDRV01 H600819X;
label value OBDSLF01 H600820X;
label value OBDSTL01 H600821X;
label value OBDTCH01 H600822X;
label value OBDTRI01 H600823X;
label value OBDVA01 H600824X;
label value OBDWCP01 H600825X;
label value OBEEXP01 H600826X;
label value OBEMCD01 H600827X;
label value OBEMCR01 H600828X;
label value OBEOFD01 H600829X;
label value OBEOPR01 H600830X;
label value OBEOPU01 H600831X;
label value OBEOSR01 H600832X;
label value OBEPRV01 H600833X;
label value OBESLF01 H600834X;
label value OBESTL01 H600835X;
label value OBETCH01 H600836X;
label value OBETRI01 H600837X;
label value OBEVA01 H600838X;
label value OBEWCP01 H600839X;
label value OBNEXP01 H600840X;
label value OBNMCD01 H600841X;
label value OBNMCR01 H600842X;
label value OBNOFD01 H600843X;
label value OBNOPR01 H600844X;
label value OBNOPU01 H600845X;
label value OBNOSR01 H600846X;
label value OBNPRV01 H600847X;
label value OBNSLF01 H600848X;
label value OBNSTL01 H600849X;
label value OBNTCH01 H600850X;
label value OBNTRI01 H600851X;
label value OBNURS01 H600852X;
label value OBNVA01 H600853X;
label value OBNWCP01 H600854X;
label value OBOEXP01 H600855X;
label value OBOMCD01 H600856X;
label value OBOMCR01 H600857X;
label value OBOOFD01 H600858X;
label value OBOOPR01 H600859X;
label value OBOOPU01 H600860X;
label value OBOOSR01 H600861X;
label value OBOPRV01 H600862X;
label value OBOPTO01 H600863X;
label value OBOSLF01 H600864X;
label value OBOSTL01 H600865X;
label value OBOTCH01 H600866X;
label value OBOTHV01 H600867X;
label value OBOTRI01 H600868X;
label value OBOVA01 H600869X;
label value OBOWCP01 H600870X;
label value OBTAIN42 H600871X;
label value OBTEXP01 H600872X;
label value OBTHER01 H600873X;
label value OBTMCD01 H600874X;
label value OBTMCR01 H600875X;
label value OBTOFD01 H600876X;
label value OBTOPR01 H600877X;
label value OBTOPU01 H600878X;
label value OBTOSR01 H600879X;
label value OBTOTV01 H600880X;
label value OBTPRV01 H600881X;
label value OBTSLF01 H600882X;
label value OBTSTL01 H600883X;
label value OBTTCH01 H600884X;
label value OBTTRI01 H600885X;
label value OBTVA01 H600886X;
label value OBTWCP01 H600887X;
label value OBVEXP01 H600888X;
label value OBVMCD01 H600889X;
label value OBVMCR01 H600890X;
label value OBVOFD01 H600891X;
label value OBVOPR01 H600892X;
label value OBVOPU01 H600893X;
label value OBVOSR01 H600894X;
label value OBVPRV01 H600895X;
label value OBVSLF01 H600896X;
label value OBVSTL01 H600897X;
label value OBVTCH01 H600898X;
label value OBVTRI01 H600899X;
label value OBVVA01 H600900X;
label value OBVWCP01 H600901X;
label value OFFER31X H600902X;
label value OFFER42X H600903X;
label value OFFER53X H600904X;
label value OFFHOU42 H600905X;
label value OFFICE42 H600906X;
label value OFFWOR42 H600907X;
label value OHRTDX53 H600908X;
label value OPAAP01 H600909X;
label value OPAAU01 H600910X;
label value OPADE01 H600911X;
label value OPAEV01 H600912X;
label value OPAFE01 H600913X;
label value OPAJA01 H600914X;
label value OPAJL01 H600915X;
label value OPAJU01 H600916X;
label value OPAMA01 H600917X;
label value OPAMY01 H600918X;
label value OPANO01 H600919X;
label value OPAOC01 H600920X;
label value OPASE01 H600921X;
label value OPBAP01 H600922X;
label value OPBAU01 H600923X;
label value OPBDE01 H600924X;
label value OPBEV01 H600925X;
label value OPBFE01 H600926X;
label value OPBJA01 H600927X;
label value OPBJL01 H600928X;
label value OPBJU01 H600929X;
label value OPBMA01 H600930X;
label value OPBMY01 H600931X;
label value OPBNO01 H600932X;
label value OPBOC01 H600933X;
label value OPBSE01 H600934X;
label value OPDEXP01 H600935X;
label value OPDMCD01 H600936X;
label value OPDMCR01 H600937X;
label value OPDOFD01 H600938X;
label value OPDOPR01 H600939X;
label value OPDOPU01 H600940X;
label value OPDOSR01 H600941X;
label value OPDPRV01 H600942X;
label value OPDRV01 H600943X;
label value OPDSLF01 H600944X;
label value OPDSTL01 H600945X;
label value OPDTCH01 H600946X;
label value OPDTRI01 H600947X;
label value OPDVA01 H600948X;
label value OPDWCP01 H600949X;
label value OPFEXP01 H600950X;
label value OPFMCD01 H600951X;
label value OPFMCR01 H600952X;
label value OPFOFD01 H600953X;
label value OPFOPR01 H600954X;
label value OPFOPU01 H600955X;
label value OPFOSR01 H600956X;
label value OPFPRV01 H600957X;
label value OPFSLF01 H600958X;
label value OPFSTL01 H600959X;
label value OPFTCH01 H600960X;
label value OPFTRI01 H600961X;
label value OPFVA01 H600962X;
label value OPFWCP01 H600963X;
label value OPOEXP01 H600964X;
label value OPOMCD01 H600965X;
label value OPOMCR01 H600966X;
label value OPOOFD01 H600967X;
label value OPOOPR01 H600968X;
label value OPOOPU01 H600969X;
label value OPOOSR01 H600970X;
label value OPOPRV01 H600971X;
label value OPOSLF01 H600972X;
label value OPOSTL01 H600973X;
label value OPOTCH01 H600974X;
label value OPOTHV01 H600975X;
label value OPOTRI01 H600976X;
label value OPOVA01 H600977X;
label value OPOWCP01 H600978X;
label value OPPEXP01 H600979X;
label value OPPMCD01 H600980X;
label value OPPMCR01 H600981X;
label value OPPOFD01 H600982X;
label value OPPOPR01 H600983X;
label value OPPOPU01 H600984X;
label value OPPOSR01 H600985X;
label value OPPPRV01 H600986X;
label value OPPSLF01 H600987X;
label value OPPSTL01 H600988X;
label value OPPTCH01 H600989X;
label value OPPTRI01 H600990X;
label value OPPVA01 H600991X;
label value OPPWCP01 H600992X;
label value OPSEXP01 H600993X;
label value OPSMCD01 H600994X;
label value OPSMCR01 H600995X;
label value OPSOFD01 H600996X;
label value OPSOPR01 H600997X;
label value OPSOPU01 H600998X;
label value OPSOSR01 H600999X;
label value OPSPRV01 H601000X;
label value OPSSLF01 H601001X;
label value OPSSTL01 H601002X;
label value OPSTCH01 H601003X;
label value OPSTRI01 H601004X;
label value OPSVA01 H601005X;
label value OPSWCP01 H601006X;
label value OPTOTV01 H601007X;
label value OPVEXP01 H601008X;
label value OPVMCD01 H601009X;
label value OPVMCR01 H601010X;
label value OPVOFD01 H601011X;
label value OPVOPR01 H601012X;
label value OPVOPU01 H601013X;
label value OPVOSR01 H601014X;
label value OPVPRV01 H601015X;
label value OPVSLF01 H601016X;
label value OPVSTL01 H601017X;
label value OPVTCH01 H601018X;
label value OPVTRI01 H601019X;
label value OPVVA01 H601020X;
label value OPVWCP01 H601021X;
label value OTHDYS31 H601022X;
label value OTHDYS42 H601023X;
label value OTHDYS53 H601024X;
label value OTHEXP01 H601025X;
label value OTHIMP01 H601026X;
label value OTHINS42 H601027X;
label value OTHMCD01 H601028X;
label value OTHMCR01 H601029X;
label value OTHNDD31 H601030X;
label value OTHNDD42 H601031X;
label value OTHNDD53 H601032X;
label value OTHOFD01 H601033X;
label value OTHOPR01 H601034X;
label value OTHOPU01 H601035X;
label value OTHOSR01 H601036X;
label value OTHPRV01 H601037X;
label value OTHRE942 H601038X;
label value OTHREA42 H601039X;
label value OTHRP01X H601040X;
label value OTHRPR42 H601041X;
label value OTHSLF01 H601042X;
label value OTHSTL01 H601043X;
label value OTHTCH01 H601044X;
label value OTHTRI01 H601045X;
label value OTHVA01 H601046X;
label value OTHWCP01 H601047X;
label value OTPAAT01 H601048X;
label value OTPAAT31 H601049X;
label value OTPAAT42 H601050X;
label value OTPAAT53 H601051X;
label value OTPBAT01 H601052X;
label value OTPBAT31 H601053X;
label value OTPBAT42 H601054X;
label value OTPBAT53 H601055X;
label value OTPUBA01 H601056X;
label value OTPUBA31 H601057X;
label value OTPUBA42 H601058X;
label value OTPUBA53 H601059X;
label value OTPUBB01 H601060X;
label value OTPUBB31 H601061X;
label value OTPUBB42 H601062X;
label value OTPUBB53 H601063X;
label value PANEL01 H601064X;
label value PAPSMR53 H601065X;
label value PAYDR31 H601066X;
label value PAYDR42 H601067X;
label value PAYDR53 H601068X;
label value PAYVAC31 H601069X;
label value PAYVAC42 H601070X;
label value PAYVAC53 H601071X;
label value PCS42 H601072X;
label value PDKAP01 H601073X;
label value PDKAU01 H601074X;
label value PDKDE01 H601075X;
label value PDKFE01 H601076X;
label value PDKJA01 H601077X;
label value PDKJL01 H601078X;
label value PDKJU01 H601079X;
label value PDKMA01 H601080X;
label value PDKMY01 H601081X;
label value PDKNO01 H601082X;
label value PDKOC01 H601083X;
label value PDKSE01 H601084X;
label value PEGAP01 H601085X;
label value PEGAU01 H601086X;
label value PEGDE01 H601087X;
label value PEGFE01 H601088X;
label value PEGJA01 H601089X;
label value PEGJL01 H601090X;
label value PEGJU01 H601091X;
label value PEGMA01 H601092X;
label value PEGMY01 H601093X;
label value PEGNO01 H601094X;
label value PEGOC01 H601095X;
label value PEGSE01 H601096X;
label value PENIMP01 H601097X;
label value PENSP01X H601098X;
label value PERSLA42 H601099X;
label value PHMONP01 H601100X;
label value PHMONP31 H601101X;
label value PHMONP42 H601102X;
label value PHONED42 H601103X;
label value PHYACT53 H601104X;
label value PHYSCL42 H601105X;
label value PMEDIN31 H601106X;
label value PMEDIN42 H601107X;
label value PMEDIN53 H601108X;
label value PMNCNP01 H601109X;
label value PMNCNP31 H601110X;
label value PMNCNP42 H601111X;
label value PNGAP01 H601112X;
label value PNGAU01 H601113X;
label value PNGDE01 H601114X;
label value PNGFE01 H601115X;
label value PNGJA01 H601116X;
label value PNGJL01 H601117X;
label value PNGJU01 H601118X;
label value PNGMA01 H601119X;
label value PNGMY01 H601120X;
label value PNGNO01 H601121X;
label value PNGOC01 H601122X;
label value PNGSE01 H601123X;
label value POGAP01 H601124X;
label value POGAU01 H601125X;
label value POGDE01 H601126X;
label value POGFE01 H601127X;
label value POGJA01 H601128X;
label value POGJL01 H601129X;
label value POGJU01 H601130X;
label value POGMA01 H601131X;
label value POGMY01 H601132X;
label value POGNO01 H601133X;
label value POGOC01 H601134X;
label value POGSE01 H601135X;
label value POUAP01 H601136X;
label value POUAU01 H601137X;
label value POUDE01 H601138X;
label value POUFE01 H601139X;
label value POUJA01 H601140X;
label value POUJL01 H601141X;
label value POUJU01 H601142X;
label value POUMA01 H601143X;
label value POUMY01 H601144X;
label value POUNO01 H601145X;
label value POUOC01 H601146X;
label value POUSE01 H601147X;
label value POVCAT01 H601148X;
label value PRDRNP01 H601149X;
label value PRDRNP31 H601150X;
label value PRDRNP42 H601151X;
label value PREEXC42 H601152X;
label value PREVCOVR H601153X;
label value PREVEN42 H601154X;
label value PRIAP01 H601155X;
label value PRIAU01 H601156X;
label value PRIDE01 H601157X;
label value PRIDK01 H601158X;
label value PRIDK31 H601159X;
label value PRIDK42 H601160X;
label value PRIDK53 H601161X;
label value PRIEU01 H601162X;
label value PRIEU31 H601163X;
label value PRIEU42 H601164X;
label value PRIEU53 H601165X;
label value PRIFE01 H601166X;
label value PRIJA01 H601167X;
label value PRIJL01 H601168X;
label value PRIJU01 H601169X;
label value PRIMA01 H601170X;
label value PRIMY01 H601171X;
label value PRING01 H601172X;
label value PRING31 H601173X;
label value PRING42 H601174X;
label value PRING53 H601175X;
label value PRINO01 H601176X;
label value PRIOC01 H601177X;
label value PRIOG01 H601178X;
label value PRIOG31 H601179X;
label value PRIOG42 H601180X;
label value PRIOG53 H601181X;
label value PRIS01 H601182X;
label value PRIS31 H601183X;
label value PRIS42 H601184X;
label value PRIS53 H601185X;
label value PRISE01 H601186X;
label value PRIV01 H601187X;
label value PRIV31 H601188X;
label value PRIV42 H601189X;
label value PRIV53 H601190X;
label value PRIVAT01 H601191X;
label value PRIVAT31 H601192X;
label value PRIVAT42 H601193X;
label value PRIVAT53 H601194X;
label value PRLIST42 H601195X;
label value PROUT01 H601196X;
label value PROUT31 H601197X;
label value PROUT42 H601198X;
label value PROUT53 H601199X;
label value PROVST42 H601200X;
label value PROVTY42 H601201X;
label value PROXY01 H601202X;
label value PROXY31 H601203X;
label value PROXY42 H601204X;
label value PROXY53 H601205X;
label value PRSAP01 H601206X;
label value PRSAU01 H601207X;
label value PRSDE01 H601208X;
label value PRSFE01 H601209X;
label value PRSJA01 H601210X;
label value PRSJL01 H601211X;
label value PRSJU01 H601212X;
label value PRSMA01 H601213X;
label value PRSMY01 H601214X;
label value PRSNO01 H601215X;
label value PRSOC01 H601216X;
label value PRSSE01 H601217X;
label value PRVDRL01 H601218X;
label value PRVDRL31 H601219X;
label value PRVDRL42 H601220X;
label value PRVEV01 H601221X;
label value PRVHMO01 H601222X;
label value PRVHMO31 H601223X;
label value PRVHMO42 H601224X;
label value PRVMNC01 H601225X;
label value PRVMNC31 H601226X;
label value PRVMNC42 H601227X;
label value PSA53 H601228X;
label value PSTATS31 H601229X;
label value PSTATS42 H601230X;
label value PSTATS53 H601231X;
label value PUB01X H601232X;
label value PUB31X H601233X;
label value PUB42X H601234X;
label value PUB53X H601235X;
label value PUBAP01X H601236X;
label value PUBAT01X H601237X;
label value PUBAT31X H601238X;
label value PUBAT42X H601239X;
label value PUBAT53X H601240X;
label value PUBAU01X H601241X;
label value PUBDE01X H601242X;
label value PUBFE01X H601243X;
label value PUBIMP01 H601244X;
label value PUBJA01X H601245X;
label value PUBJL01X H601246X;
label value PUBJU01X H601247X;
label value PUBMA01X H601248X;
label value PUBMY01X H601249X;
label value PUBNO01X H601250X;
label value PUBOC01X H601251X;
label value PUBP01X H601252X;
label value PUBSE01X H601253X;
label value PUBTRA42 H601254X;
label value RACETHNX H601255X;
label value RACEX H601256X;
label value RCHDIF31 H601257X;
label value RCHDIF53 H601258X;
label value READNW42 H601259X;
label value RECPEP42 H601260X;
label value REFDP01X H601261X;
label value REFFRL42 H601262X;
label value REFIMP01 H601263X;
label value REFUSE42 H601264X;
label value REFUSI42 H601265X;
label value REGION01 H601266X;
label value REGION31 H601267X;
label value REGION42 H601268X;
label value REGION53 H601269X;
label value RESP01 H601270X;
label value RESP31 H601271X;
label value RESP42 H601272X;
label value RESP53 H601273X;
label value RETPLN31 H601274X;
label value RETPLN42 H601275X;
label value RETPLN53 H601276X;
label value RFREL01X H601277X;
label value RFREL31X H601278X;
label value RFREL42X H601279X;
label value RFREL53X H601280X;
label value RNDFLG31 H601281X;
label value RTHLTH31 H601282X;
label value RTHLTH42 H601283X;
label value RTHLTH53 H601284X;
label value RTPROX31 H601285X;
label value RTPROX42 H601286X;
label value RTPROX53 H601287X;
label value RUCLAS01 H601288X;
label value RUCLAS31 H601289X;
label value RUCLAS42 H601290X;
label value RUCLAS53 H601291X;
label value RUSIZE01 H601292X;
label value RUSIZE31 H601293X;
label value RUSIZE42 H601294X;
label value RUSIZE53 H601295X;
label value RXEXP01 H601296X;
label value RXMCD01 H601297X;
label value RXMCR01 H601298X;
label value RXOFD01 H601299X;
label value RXOPR01 H601300X;
label value RXOPU01 H601301X;
label value RXOSR01 H601302X;
label value RXPRV01 H601303X;
label value RXSLF01 H601304X;
label value RXSTL01 H601305X;
label value RXTOT01 H601306X;
label value RXTRI01 H601307X;
label value RXVA01 H601308X;
label value RXWCP01 H601309X;
label value SAFEST42 H601310X;
label value SALEP01X H601311X;
label value SALIMP01 H601312X;
label value SCHLBH42 H601313X;
label value SCHLIM31 H601314X;
label value SCHLIM53 H601315X;
label value SCHPRO42 H601316X;
label value SCLNBD31 H601317X;
label value SCLNBD42 H601318X;
label value SCLNBD53 H601319X;
label value SEATBE53 H601320X;
label value SEEDIF42 H601321X;
label value SELDSI42 H601322X;
label value SELFCM31 H601323X;
label value SELFCM42 H601324X;
label value SELFCM53 H601325X;
label value SEX H601326X;
label value SFFLAG42 H601327X;
label value SIBPRO42 H601328X;
label value SICEAS42 H601329X;
label value SICPAY31 H601330X;
label value SICPAY42 H601331X;
label value SICPAY53 H601332X;
label value SOCLIM31 H601333X;
label value SOCLIM53 H601334X;
label value SPOUID01 H601335X;
label value SPOUID31 H601336X;
label value SPOUID42 H601337X;
label value SPOUID53 H601338X;
label value SPOUIN01 H601339X;
label value SPOUIN31 H601340X;
label value SPOUIN42 H601341X;
label value SPOUIN53 H601342X;
label value SPRPRO42 H601343X;
label value SRTHRT53 H601344X;
label value SSCIMP01 H601345X;
label value SSECP01X H601346X;
label value SSECTX01 H601347X;
label value SSIDIS01 H601348X;
label value SSIIMP01 H601349X;
label value SSIP01X H601350X;
label value SSNLJB31 H601351X;
label value SSNLJB42 H601352X;
label value SSNLJB53 H601353X;
label value STAAP01 H601354X;
label value STAAU01 H601355X;
label value STADE01 H601356X;
label value STAFE01 H601357X;
label value STAJA01 H601358X;
label value STAJL01 H601359X;
label value STAJU01 H601360X;
label value STAMA01 H601361X;
label value STAMY01 H601362X;
label value STANO01 H601363X;
label value STAOC01 H601364X;
label value STAPR01 H601365X;
label value STAPR31 H601366X;
label value STAPR42 H601367X;
label value STAPR53 H601368X;
label value STASE01 H601369X;
label value STJBDD31 H601370X;
label value STJBDD42 H601371X;
label value STJBDD53 H601372X;
label value STJBMM31 H601373X;
label value STJBMM42 H601374X;
label value STJBMM53 H601375X;
label value STJBYY31 H601376X;
label value STJBYY42 H601377X;
label value STJBYY53 H601378X;
label value STNDIF31 H601379X;
label value STNDIF53 H601380X;
label value STOMCH53 H601381X;
label value STOOL53 H601382X;
label value STPDIF31 H601383X;
label value STPDIF53 H601384X;
label value STPRAT01 H601385X;
label value STPRAT31 H601386X;
label value STPRAT42 H601387X;
label value STPRAT53 H601388X;
label value STRKDX53 H601389X;
label value SVERLANG H601390X;
label value TAXFRM01 H601391X;
label value TEMPJB31 H601392X;
label value TEMPJB42 H601393X;
label value TEMPJB53 H601394X;
label value THANTB53 H601395X;
label value THANTF53 H601396X;
label value THSWAB53 H601397X;
label value THSWBF53 H601398X;
label value THSYMF53 H601399X;
label value THSYMP53 H601400X;
label value TIMALN42 H601401X;
label value TOTDED01 H601402X;
label value TOTEXP01 H601403X;
label value TOTMCD01 H601404X;
label value TOTMCR01 H601405X;
label value TOTOFD01 H601406X;
label value TOTOPR01 H601407X;
label value TOTOPU01 H601408X;
label value TOTOSR01 H601409X;
label value TOTPRV01 H601410X;
label value TOTSLF01 H601411X;
label value TOTSTL01 H601412X;
label value TOTTCH01 H601413X;
label value TOTTRI01 H601414X;
label value TOTVA01 H601415X;
label value TOTWCP01 H601416X;
label value TRBLE42 H601417X;
label value TREATM42 H601418X;
label value TRIAP01X H601419X;
label value TRIAT01X H601420X;
label value TRIAT31X H601421X;
label value TRIAT42X H601422X;
label value TRIAT53X H601423X;
label value TRIAU01X H601424X;
label value TRICR01X H601425X;
label value TRICR31X H601426X;
label value TRICR42X H601427X;
label value TRICR53X H601428X;
label value TRIDE01X H601429X;
label value TRIEV01 H601430X;
label value TRIFE01X H601431X;
label value TRIJA01X H601432X;
label value TRIJL01X H601433X;
label value TRIJU01X H601434X;
label value TRIMA01X H601435X;
label value TRIMY01X H601436X;
label value TRINO01X H601437X;
label value TRIOC01X H601438X;
label value TRISE01X H601439X;
label value TRSTP01X H601440X;
label value TRTIMP01 H601441X;
label value TTLP01X H601442X;
label value TYPEPE42 H601443X;
label value TYPEPL42 H601444X;
label value UNABLE31 H601445X;
label value UNABLE53 H601446X;
label value UNEIMP01 H601447X;
label value UNEMP01X H601448X;
label value UNEMTX01 H601449X;
label value UNHAP42 H601450X;
label value UNINS01 H601451X;
label value UNION31 H601452X;
label value UNION42 H601453X;
label value UNION53 H601454X;
label value USCNOT42 H601455X;
label value USCQUA42 H601456X;
label value VETGULF H601457X;
label value VETIMP01 H601458X;
label value VETKOR H601459X;
label value VETOTH H601460X;
label value VETSP01X H601461X;
label value VETVIET H601462X;
label value VETWW H601463X;
label value VISEXP01 H601464X;
label value VISION42 H601465X;
label value VISMCD01 H601466X;
label value VISMCR01 H601467X;
label value VISOFD01 H601468X;
label value VISOPR01 H601469X;
label value VISOPU01 H601470X;
label value VISOSR01 H601471X;
label value VISPRV01 H601472X;
label value VISSLF01 H601473X;
label value VISSTL01 H601474X;
label value VISTCH01 H601475X;
label value VISTRI01 H601476X;
label value VISVA01 H601477X;
label value VISWCP01 H601478X;
label value WAGEP01X H601479X;
label value WAGIMP01 H601480X;
label value WAITTI42 H601481X;
label value WASAFDC H601482X;
label value WASCHAMP H601483X;
label value WASESTB H601484X;
label value WASMCAID H601485X;
label value WASMCARE H601486X;
label value WASOTGOV H601487X;
label value WASOTHER H601488X;
label value WASPRIV H601489X;
label value WASSSI H601490X;
label value WASSTAT1 H601491X;
label value WASSTAT2 H601492X;
label value WASVA H601493X;
label value WCMPP01X H601494X;
label value WCPIMP01 H601495X;
label value WHENST53 H601496X;
label value WHNBPR42 H601497X;
label value WHNBST42 H601498X;
label value WHNBWL53 H601499X;
label value WHNDEN42 H601500X;
label value WHNEAT42 H601501X;
label value WHNHEL42 H601502X;
label value WHNHGT42 H601503X;
label value WHNLAP42 H601504X;
label value WHNPHY42 H601505X;
label value WHNSAF42 H601506X;
label value WHNSMK42 H601507X;
label value WHNWGT42 H601508X;
label value WILFIL01 H601509X;
label value WKINBD31 H601510X;
label value WKINBD42 H601511X;
label value WKINBD53 H601512X;
label value WLKDIF31 H601513X;
label value WLKDIF53 H601514X;
label value WLKLIM31 H601515X;
label value WLKLIM53 H601516X;
label value WRGLAS42 H601517X;
label value WRHLTH42 H601518X;
label value WRKLIM31 H601519X;
label value WRKLIM53 H601520X;
label value YCHJ3142 H601521X;
label value YCHJ4253 H601522X;
label value YCHNGU42 H601523X;
label value YGOTOU42 H601524X;
label value YNOMOR42 H601525X;
label value YNOUSC42 H601526X;
label value ZIDEXP01 H601527X;
label value ZIDMCD01 H601528X;
label value ZIDMCR01 H601529X;
label value ZIDOFD01 H601530X;
label value ZIDOPR01 H601531X;
label value ZIDOPU01 H601532X;
label value ZIDOSR01 H601533X;
label value ZIDPRV01 H601534X;
label value ZIDSLF01 H601535X;
label value ZIDSTL01 H601536X;
label value ZIDTCH01 H601537X;
label value ZIDTRI01 H601538X;
label value ZIDVA01 H601539X;
label value ZIDWCP01 H601540X;
label value ZIFEXP01 H601541X;
label value ZIFMCD01 H601542X;
label value ZIFMCR01 H601543X;
label value ZIFOFD01 H601544X;
label value ZIFOPR01 H601545X;
label value ZIFOPU01 H601546X;
label value ZIFOSR01 H601547X;
label value ZIFPRV01 H601548X;
label value ZIFSLF01 H601549X;
label value ZIFSTL01 H601550X;
label value ZIFTCH01 H601551X;
label value ZIFTRI01 H601552X;
label value ZIFVA01 H601553X;
label value ZIFWCP01 H601554X;

*DISPLAY A DESCRIPTION OF STATA FILE;
describe;

*LIST FIRST 20 OBSERVATIONS IN THE FILE;
list in 1/20;


#delimit cr


/************************************************************************************************
 NOTES:                                                                                          
                                                                                                 
 1. This program has been tested on Stata Version 10 (for Windows).                              
                                                                                                 
 2. This program will create a permanent Stata dataset.  All additional analyses                 
    can be run using this dataset.  In addition to the dataset, this program creates             
    a log file named H60.LOG and a data file named H60.DTA.  If these files (H60.DTA and H60.LOG)
    already exist in the working directory, they will be replaced when this program is executed. 
                                                                                                 
 3. If the program ends prematurely, the log file will remain open.  Before running this         
    program again, the user should enter the following Stata command: log close                  
                                                                                                 
 4. The cd command assigns C:\MEPS\DATA as the working directory and location of the input       
    ASCII and output .DTA and .LOG files and can be modified by the user as necessary.           
                                                                                                 
 5. Stata commands end with a carriage return by default. The command                            
    #delimit ;                                                                                   
    temporarily changes the command ending delimiter from a carriage return to a semicolon.      
                                                                                                 
 6. The infix command assumes that the input variables are numeric unless the variable name      
    is prefaced by str.  For example, DUPERSID is the a string (or character) variable.          
                                                                                                 
************************************************************************************************/

